/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.user.service;

import com.huawei.ism.drm.wcc.util.kmc.KmcInstance;
import com.huawei.lego.cbb.user.sdk.hibernate.model.OperationInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.RoleInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserAclInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserCustomSetting;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserLoginPolicyInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserRelMoInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserSecPolicyInfo;
import com.huawei.lego.cbb.user.sdk.model.Role;
import com.huawei.lego.cbb.user.sdk.model.SystemSecPolicy;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.model.UserAcl;
import com.huawei.lego.cbb.user.sdk.model.UserLoginPolicy;
import com.huawei.lego.cbb.user.sdk.model.UserSecPolicy;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.cbb.user.service.IUserService;
import com.huawei.lego.cbb.user.service.common.ObjectConvertor;
import com.huawei.lego.cbb.user.service.notes.IBroadcastServices;
import com.huawei.lego.cbb.user.service.operation.IOperationService;
import com.huawei.lego.cbb.user.service.roleservice.IRoleService;
import com.huawei.lego.cbb.user.service.security.IAuthorityService;
import com.huawei.lego.cbb.user.service.security.ISecurity;
import com.huawei.lego.cbb.user.service.security.ThirdAuthorityFactory;
import com.huawei.lego.cbb.user.service.usercache.IUserLoginLocalCache;
import com.huawei.lego.cbb.user.service.userrelmo.IUserRelMoService;
import com.huawei.lego.cbb.user.thirdauth.SSOAuthority;
import com.huawei.lego.cbb.user.thirdauth.sdk.UserAuthorityType;
import com.huawei.lego.comm.unitepassword.IUnitePasswordSyncAdminMgr;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.base.structure.ILifecycle;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.comm.Paging;
import com.huawei.lego.core.sdk.comm.SortUnit;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.file.util.FileUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.AddressUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.KmcCompatible;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.LegoProperties;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import com.huawei.lego.core.sdk.util.tree.RootDataElement;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

@Service(Name="usermgr", Desc="", Interface=IUserMgr.class)
public class UserMgrImpl
extends BaseService
implements IUserMgr,
ILifecycle,
Serializable {
    private static final long serialVersionUID = 4885017051868053189L;
    private static final String DEFAULT_USERNAME = "system";
    private static final Integer ERR_PASSWORD_SAMEERROR = 266;
    private static final String SYNC_ADMIN = "SyncAdmin";
    private static final String SYS_DEFAULT_SYNC_USER_PWD_ISCHANGED = "sys.default.syncUserPwd.ischanged";
    private transient IAuthorityService authorityService;
    private transient IRoleService roleService;
    private transient IUserService userService;
    private transient IUserRelMoService userRelMoService;
    private transient ISecurity security;
    private transient IUserLoginLocalCache cacheService;
    private transient IBroadcastServices broadcastServices;
    private transient IOperationService operationService;
    private transient SSOAuthority ssoAuthority;
    private Log log = LogFactory.getInstance(UserMgrImpl.class);

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    public SSOAuthority getSsoAuthority() {
        return this.ssoAuthority;
    }

    public void setSsoAuthority(SSOAuthority ssoAuthority) {
        this.ssoAuthority = ssoAuthority;
    }

    public int addRoleInfo(Role oRole, List<Long> mapOpts) {
        return this.roleService.addRoleInfo(oRole, mapOpts);
    }

    public void deleteRole(long roleId) {
        this.roleService.deleteRole(roleId);
    }

    public BatchOperationResult batchDelRoles(List<BatchOperation> list) {
        return this.roleService.batchDelRoles(list);
    }

    public Role getRoleInf(long iRoleId) {
        return this.roleService.getRoleInf(iRoleId);
    }

    public Role getRoleInf(String roleName) {
        return this.roleService.getRoleInf(roleName);
    }

    public Role getRoleInfRelUser(long iRoleId, boolean isFetchUser) {
        return this.roleService.getRoleInfRelUser(iRoleId, true);
    }

    public int updataRole(Role oRole, List<Long> mapOpts) {
        return this.roleService.updataRole(oRole, mapOpts);
    }

    public List<Role> getAllRole() {
        return this.roleService.getAllRoles(false);
    }

    public Paging getAllRole(int start, int length, SortUnit su) {
        return this.roleService.getAllRoles(start, length, su);
    }

    public RootDataElement getOptTree(Long roleId) {
        RootDataElement rootDataElement = this.operationService.getOptTree(roleId);
        return rootDataElement;
    }

    public List<OperationInfo> getAllOperation() {
        return this.operationService.getAllOpt();
    }

    public int addUserInfo(User oUserInfo) {
        String userName = oUserInfo.getUserName();
        if (userName.equalsIgnoreCase(DEFAULT_USERNAME)) {
            throw new LegoCheckedException(291L);
        }
        UserInfo userInfo = ObjectConvertor.getUserInfo(oUserInfo);
        if (userInfo.getPasswordModel().intValue() == UserAuthorityType.local.getValue()) {
            userInfo.setUserPwdSalt("");
            userInfo.setUserPwd(KmcInstance.protectPwdEx((String)userInfo.getUserPwd()));
        }
        Set<UserAclInfo> userAclInfoSet = ObjectConvertor.getUserAclInfo(oUserInfo.getUserAclSet());
        userInfo.setUserAcls(userAclInfoSet);
        userInfo.setCreateTime(Long.valueOf(System.currentTimeMillis()));
        long newUserId = this.userService.addUserInfo(userInfo, oUserInfo.getRolesIdsSet(), oUserInfo.getMoAuthIdsSet(), oUserInfo.getMoGroupIdsSet());
        oUserInfo.setUserId(Long.valueOf(newUserId));
        String userLockKey = "USER_LOCK" + oUserInfo.getUserName();
        String loginFailKey = "USER_LOGIN_FAIL" + userName;
        if (null != this.cacheService) {
            if (this.cacheService.containsKey(userLockKey)) {
                this.cacheService.remove(userLockKey);
            }
            if (this.cacheService.containsKey(loginFailKey)) {
                this.cacheService.remove(loginFailKey);
            }
        }
        try {
            this.broadcastServices.noteAddUser(oUserInfo);
        }
        catch (Exception ex) {
            this.log.error((Object)("send message error " + ExceptionUtil.getErrorMessage((Throwable)ex)), 1L);
        }
        return (int)newUserId;
    }

    public synchronized void deleteUser(long userId, long operatorUserId) {
        List<User> onlineUserList = this.getAllOnlineUser(null);
        if (null != onlineUserList && !onlineUserList.isEmpty()) {
            for (User onlineUser : onlineUserList) {
                if (onlineUser.getUserId() != userId) continue;
                throw new LegoCheckedException(285L);
            }
        }
        this.security.unLockUserInCache(userId);
        if (userId != operatorUserId) {
            this.userService.deleteUser(userId);
        }
        try {
            this.broadcastServices.noteDelUser(userId);
        }
        catch (Exception ex) {
            this.log.error((Object)("send message error " + ExceptionUtil.getErrorMessage((Throwable)ex)), 1L);
        }
    }

    public void deleteUser(Long[] userIds, long operatorUserId) {
        Long[] longArray = userIds;
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long i2 = longArray[i];
            this.deleteUser(i2, operatorUserId);
        }
        this.log.debug((Object)"deleteUser:completed");
    }

    public synchronized BatchOperationResult batchDeleteUser(List<BatchOperation> list, long operatorUserId) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int fail = 0;
        int operCount = 0;
        if (null != list) {
            operCount = list.size();
            for (BatchOperation batchOperation : list) {
                try {
                    this.deleteUserAndLog(batchOperation, operatorUserId);
                }
                catch (LegoCheckedException ce) {
                    ++fail;
                    batchOperation.setErrorCode(ce.getErrorCode());
                    batchOperation.setDetailParam(ce.getParameters());
                }
                catch (LegoUncheckedException ue) {
                    ++fail;
                    batchOperation.setErrorCode(ue.getErrorCode());
                }
                catch (Exception e) {
                    ++fail;
                    batchOperation.setErrorCode(102L);
                }
                resultList.add(batchOperation);
            }
            result.setResult(resultList);
            result.setFailCount(fail);
            result.setTotalCount(operCount);
            result.setSucceedCount(operCount - fail);
        } else {
            this.log.debug((Object)"batchDeleteUser:list is null");
        }
        return result;
    }

    private void deleteUserAndLog(BatchOperation batchOperation, long operatorUserId) {
        long userId = batchOperation.getTargetId();
        List<User> onlineUserList = this.getAllOnlineUser(null);
        if (null != onlineUserList && !onlineUserList.isEmpty()) {
            for (User onlineUser : onlineUserList) {
                if (onlineUser.getUserId() != userId) continue;
                throw new LegoCheckedException(285L);
            }
        }
        this.security.unLockUserInCache(userId);
        if (userId != operatorUserId) {
            this.userService.deleteUser(userId);
            this.userService.setOldUserLog(batchOperation.getTargetName());
        }
        try {
            this.broadcastServices.noteDelUser(userId);
        }
        catch (Exception ex) {
            this.log.error((Object)("send message error " + ExceptionUtil.getErrorMessage((Throwable)ex)), 1L);
        }
    }

    public List<User> getAllUser() {
        List<UserInfo> allUserInfoList = this.userService.getAllUser();
        ArrayList<User> allUserList = new ArrayList<User>();
        if (null != allUserInfoList) {
            this.log.debug((Object)"getAllUser:allUserInfoList is not null");
            for (UserInfo userInfo : allUserInfoList) {
                User temp = this.getUser(userInfo, false, true);
                this.updateUserStatus(temp, allUserList);
            }
        }
        return allUserList;
    }

    private void updateUserStatus(User temp, List<User> allUserList) {
        if (null != temp) {
            String userLockKey = "USER_LOCK" + temp.getUserName();
            if (null != this.cacheService) {
                this.log.debug((Object)"updateUserStatus:cacheService is not null");
                if (this.cacheService.containsKey(userLockKey, true)) {
                    temp.setIsLock("true");
                }
            }
            allUserList.add(temp);
        }
    }

    public List<User> getAllUserExt() {
        List<UserInfo> allUserInfoList = this.userService.getAllUser();
        ArrayList<User> allUserList = new ArrayList<User>();
        User user = new User();
        user.setUserName(DEFAULT_USERNAME);
        user.setDescription(DEFAULT_USERNAME);
        allUserList.add(user);
        for (UserInfo userInfo : allUserInfoList) {
            User temp = this.getUser(userInfo, false, true);
            allUserList.add(temp);
        }
        return allUserList;
    }

    public Paging getAllUser(Map<String, String> map, int iStart, int iLength) {
        Paging pag = this.userService.getAllUser(map, iStart, iLength);
        List allUserInfoList = pag.getData();
        ArrayList<User> allUserList = new ArrayList<User>();
        for (UserInfo userInfo : allUserInfoList) {
            User temp = this.getUser(userInfo, false, true);
            if (null == temp) continue;
            this.log.debug((Object)"getAllUser:temp is not null");
            String userLockKey = "USER_LOCK" + temp.getUserName();
            if (null != this.cacheService && this.cacheService.containsKey(userLockKey, true)) {
                temp.setIsLock("true");
            }
            allUserList.add(temp);
        }
        pag.setData(allUserList);
        return pag;
    }

    private User getUser(UserInfo info, boolean isFetchRole, boolean isBaseUser) {
        User userTemp = ObjectConvertor.getUser(info, isFetchRole, isBaseUser);
        if (null != userTemp && !isBaseUser) {
            this.log.debug((Object)"getUser:userTemp is not null");
            List<UserRelMoInfo> relMoList = this.userRelMoService.getUserAllRelMO(info.getId());
            HashSet<Long> moAuthIdsSet = new HashSet<Long>();
            HashSet<Long> moGroupIdsSet = new HashSet<Long>();
            for (UserRelMoInfo userRelMoInfo : relMoList) {
                if (userRelMoInfo.isGroup()) {
                    moGroupIdsSet.add(userRelMoInfo.getId().getMoId());
                    continue;
                }
                moAuthIdsSet.add(userRelMoInfo.getId().getMoId());
            }
            Set userAclInfoSet = info.getUserAcls();
            Set<UserAcl> userAclSet = ObjectConvertor.getUserAcl(userAclInfoSet);
            userTemp.setUserAclSet(userAclSet);
            userTemp.setMoAuthIdsSet(moAuthIdsSet);
            userTemp.setMoGroupIdsSet(moGroupIdsSet);
        }
        return userTemp;
    }

    public User getUserInfo(long id) {
        this.log.trace((Object)"getUserInfo");
        UserInfo userInfo = id > 0L ? this.userService.getUserInfoById(id, true) : this.ssoAuthority.create(id, null);
        User temp = this.getUser(userInfo, true, false);
        return temp;
    }

    public User getUserByName(String userName) {
        UserInfo userInfo = this.userService.getUserInfoByName(userName, false);
        User temp = this.getUser(userInfo, false, false);
        if (null != temp) {
            String userPassword = temp.getUserPassword();
            try {
                temp.setUserPassword(KmcInstance.protectPwdEx((String)userPassword));
            }
            catch (Exception ex) {
                this.log.error((Object)("encrypt is error" + ExceptionUtil.getErrorMessage((Throwable)ex)), 1L);
            }
        }
        return temp;
    }

    public void updateUser(User user) {
        this.log.trace((Object)"updateUser");
        this.userService.updateUser(user);
        this.broadcastServices.noteUserChange(user);
    }

    public Set<Integer> getThirdUserAuthType() {
        this.log.trace((Object)"getThirdUserAuthType");
        return ThirdAuthorityFactory.getInstance().getAuthorityType();
    }

    public Boolean userLockState(String userName) {
        this.log.trace((Object)"userLockState");
        Boolean lockState = Boolean.FALSE;
        String userLockKey = "USER_LOCK" + userName;
        if (null != this.cacheService && this.cacheService.containsKey(userLockKey, true)) {
            lockState = Boolean.TRUE;
        }
        return lockState;
    }

    public Boolean userLockState(long userId) {
        Boolean lockState = Boolean.FALSE;
        UserInfo userInfotemp = null;
        try {
            userInfotemp = this.userService.getUserInfoById(userId, false);
        }
        catch (Exception ex) {
            this.log.error((Object)ExceptionUtil.getErrorMessage((Throwable)ex), 1L);
        }
        if (null != userInfotemp) {
            lockState = this.userLockState(userInfotemp.getUserName());
        }
        return lockState;
    }

    public User login(String hostIP, String userName, String pwd, boolean existInDB) {
        UserInfo userInfo = null;
        User user = null;
        this.log.debug((Object)"login authorityService before", 1L);
        userInfo = this.authorityService.login(hostIP, userName, pwd, existInDB);
        this.log.debug((Object)"login authorityService end", 1L);
        if (null != userInfo) {
            boolean checkLoginIP = this.checkAclIpAddress(userInfo, hostIP);
            if (!checkLoginIP) {
                throw new LegoCheckedException(265L);
            }
            if (!userInfo.isAdmin()) {
                User userFullInfo = this.getUserInfo(userInfo.getId());
                this.checkNBIRole(userFullInfo);
            }
            this.authorityService.checkUserSessionControl(userInfo);
            user = this.setSession(hostIP, existInDB, userInfo);
            if (null != user) {
                user.setMoAuthIdsSet(null);
                user.setMoAutSeth(null);
                user.setMoGroupIdsSet(null);
                user.setMoGroupIdsSet(null);
                user.setRolesIdsSet(null);
                user.setRolesSet(null);
            }
        }
        return user;
    }

    private void checkNBIRole(User userFullInfo) {
        Role role;
        if (userFullInfo.getIsAdmin().toUpperCase(Locale.US).equals("TRUE")) {
            return;
        }
        Set rolesSet = userFullInfo.getRolesSet();
        if (rolesSet == null) {
            return;
        }
        if (rolesSet.size() == 1 && (role = (Role)rolesSet.iterator().next()).getRoleName().toUpperCase(Locale.US).equals("NBIROLE")) {
            throw new LegoCheckedException(1073947435L);
        }
    }

    private void setUserIsAdmin(UserInfo userInfo, User user) {
        if (userInfo.isAdmin()) {
            user.setIsAdmin("true");
        } else {
            user.setIsAdmin("false");
        }
        if (userInfo.isLock()) {
            user.setIsLock("true");
        } else {
            user.setIsLock("false");
        }
        this.log.debug((Object)"setUserIsAdmin:completed");
    }

    public User loginForWos(String userName, String hostIP) {
        Set<UserAclInfo> userAclInfoSet;
        User user = this.getUserByName(userName);
        if (null == user) {
            this.log.info((Object)"get user by name in DB is null", 1L);
            return user;
        }
        if ("true".equalsIgnoreCase(user.getIsLock())) {
            throw new LegoCheckedException(293L);
        }
        UserInfo userInfo = ObjectConvertor.getUserInfo(user);
        boolean checkLoginIP = this.checkAclIpAddress(userInfo, hostIP, userAclInfoSet = ObjectConvertor.getUserAclInfo(user.getUserAclSet()));
        if (!checkLoginIP) {
            throw new LegoCheckedException(265L);
        }
        this.log.debug((Object)"login authorityService generateSessionId", 1L);
        String sessionId = this.authorityService.generateSessionId(userInfo, hostIP);
        this.log.debug((Object)"login authorityService generateSessionId", 1L);
        user = ObjectConvertor.getUser(userInfo, sessionId);
        user.setMoAuthIdsSet(null);
        user.setMoGroupIdsSet(null);
        user.setMoAutSeth(null);
        user.setMoGroupIdsSet(null);
        user.setRolesIdsSet(null);
        user.setRolesSet(null);
        return user;
    }

    public User login(User user, boolean existInDB) {
        return this.login(user.getIpAdr(), user.getUserName(), user.getUserPassword(), existInDB);
    }

    public Set<String> getSSOUserAllOpNames(long roleid) {
        return this.authorityService.getSSOUserAllOpNames(roleid);
    }

    public Boolean checkUserPsw(String userName, String pwd, boolean existInDB) {
        return this.authorityService.checkUserPsw(userName, pwd, existInDB);
    }

    public void logout(String sessionId) {
        this.authorityService.logout(sessionId);
    }

    public Boolean checkTimeOut(String sessionId) {
        return this.authorityService.checkTimeout(sessionId, false);
    }

    public Boolean checkTimeOut(String sessionId, boolean prolongTime) {
        return this.authorityService.checkTimeout(sessionId, prolongTime);
    }

    public List<User> getAllOnlineUser(User user) {
        return this.authorityService.getAllOnlineUser(user);
    }

    public List<User> getAllOnlineUser(User user, String sortFile, String sortType) {
        return this.authorityService.getAllOnlineUser(user, sortFile, sortType);
    }

    public Paging getAllOnlineUser(User user, String sortFile, String sortType, int pageStart, int pageSize) {
        Boolean hasRightViewAllOnlineUser;
        Paging paging = new Paging();
        if (null != user && (hasRightViewAllOnlineUser = this.checkUserIsAdmin(user.getUserId())).booleanValue()) {
            user = null;
        }
        List<User> list = this.authorityService.getAllOnlineUser(user, sortFile, sortType);
        ArrayList<User> pagUser = new ArrayList<User>();
        if (null != list && !list.isEmpty()) {
            int listSize = list.size();
            if (listSize >= pageStart + pageSize) {
                for (int index = pageStart; index < pageStart + pageSize; ++index) {
                    pagUser.add(list.get(index));
                }
            } else {
                for (int index = pageStart; index < list.size(); ++index) {
                    pagUser.add(list.get(index));
                }
            }
            paging.setiCount(listSize);
            paging.setData(pagUser);
        }
        this.log.debug((Object)"getAllOnlineUser:completed");
        return paging;
    }

    public List<Long> getUserGrandObjects(User userInfo) {
        return this.getUserGrandObjects(userInfo.getUserId());
    }

    public List<Long> getUserGrandObjects(long userId) {
        return this.authorityService.getUserGrandObjects(userId);
    }

    public Boolean checkUserGrandObject(long userId, long moId) {
        return this.authorityService.checkUserGrandObject(userId, moId);
    }

    public void grandObjectToUser(long userId, Set<Long> moIds) {
        this.userRelMoService.addUserRelMo(userId, moIds, null);
        try {
            if (!this.checkUserIsAdmin(userId).booleanValue()) {
                this.broadcastServices.grandObjectToUser(userId, moIds);
            }
        }
        catch (Exception ex) {
            this.log.error((Object)("send message erro " + ExceptionUtil.getErrorMessage((Throwable)ex)), 1L);
        }
    }

    public void unchainObjectToUser(long userId, Set<Long> moIds) {
        this.userRelMoService.deleteUserRelMO(userId, moIds, null);
        try {
            if (!this.checkUserIsAdmin(userId).booleanValue()) {
                this.broadcastServices.unchainObjectToUser(userId, moIds);
            }
        }
        catch (Exception ex) {
            this.log.error((Object)("send message erro " + ExceptionUtil.getErrorMessage((Throwable)ex)), 1L);
        }
    }

    public void delManageObject(Set<Long> moIds) {
        this.userRelMoService.deleteManageObject(moIds, null);
    }

    public Boolean checkUserRight(long userId, String opName) {
        return this.authorityService.checkUserRight(userId, opName);
    }

    public Map checkUserRight(long userId, List<String> opNames) {
        return this.authorityService.checkUserRight(userId, opNames);
    }

    public Boolean checkUserIsAdmin(long userId) {
        return this.authorityService.checkUserIsAdmin(userId);
    }

    public Boolean checkUserIsViewAllOperLog(long userId) {
        return this.authorityService.checkUserIsAdmin(userId) != false || this.authorityService.checkUserIsAuditor(userId) != false;
    }

    public Boolean checkUserIsAuditor(long userId) {
        return this.authorityService.checkUserIsAuditor(userId);
    }

    public Set<String> getUserAllOpids(User userInfo) {
        return this.getUserAllOpNames(userInfo.getUserId());
    }

    public Set<String> getUserAllOpids(long userId) {
        return this.getUserAllOpNames(userId);
    }

    public Set<String> getUserAllOpNames(long userId) {
        return this.authorityService.getUserAllOpNames(userId);
    }

    public void modifyPassword(User userInfo) {
        UserInfo userInfoTemp = this.userService.getUserInfoById(userInfo.getUserId(), false);
        if (null == userInfoTemp) {
            this.log.debug((Object)"modifyPassword:userInfoTemp is null");
            String[] param = new String[]{"lego.lab.usr"};
            throw new LegoCheckedException(204L, param);
        }
        userInfoTemp.setUserPwd(KmcInstance.protectPwdEx((String)userInfo.getUserPassword()));
        userInfoTemp.setUserPwdSalt("");
        userInfoTemp.setMustModiPassword(false);
        this.userService.updateUser(userInfoTemp, true);
    }

    public void modifyPassword(String oldPwd, String newPwd, long userId) {
        this.log.debug((Object)"modifyPassword");
        UserInfo userInfo = this.userService.getUserInfoById(userId, true);
        this.authorityService.checkLock(userInfo.getUserName(), userInfo.getUserPwd(), oldPwd, userInfo.getUserPwdSalt());
        if (KmcCompatible.isDataSame((String)newPwd, (String)userInfo.getUserPwdSalt(), (String)userInfo.getUserPwd())) {
            throw new LegoCheckedException((long)ERR_PASSWORD_SAMEERROR.intValue());
        }
        userInfo.setUserPwd(KmcInstance.protectPwdEx((String)newPwd));
        userInfo.setUserPwdSalt("");
        userInfo.setMustModiPassword(false);
        this.userService.updateUser(userInfo, true);
    }

    public void updateUserPwdPModel(long userId, String newPwd, int pwdModel) {
        this.updateUserPwdPModel(userId, newPwd, pwdModel, false);
        this.log.debug((Object)"updateUserPwdPModel:completed");
    }

    public void updateUserPwdPModel(long userId, String newPwd, int pwdModel, boolean mustModifyPwd) {
        UserInfo userInfo = this.userService.getUserInfoById(userId, false);
        boolean isUpdateSetTime = false;
        if (StringUtils.isNotEmpty((CharSequence)newPwd)) {
            userInfo.setUserPwd(KmcInstance.protectPwdEx((String)newPwd));
            userInfo.setUserPwdSalt("");
            isUpdateSetTime = true;
        }
        userInfo.setMustModiPassword(mustModifyPwd);
        userInfo.setPasswordModel(Integer.valueOf(pwdModel));
        this.userService.updateUser(userInfo, isUpdateSetTime);
        if (SYNC_ADMIN.equals(userInfo.getUserName())) {
            String enPwd = LegoConfig.getInstance().getKeyValue("sys.default.syncUserPwd", "");
            String file = "conf" + File.separator + "account.properties";
            HashMap<String, String> data = new HashMap<String, String>();
            if (newPwd.equals(WccEncryptor.decrypt((String)enPwd))) {
                data.put(SYS_DEFAULT_SYNC_USER_PWD_ISCHANGED, "false");
            } else {
                data.put(SYS_DEFAULT_SYNC_USER_PWD_ISCHANGED, "true");
            }
            try {
                FileUtil.modifyPropFileUsingStr((String)file, data, (String)file);
            }
            catch (Exception e) {
                this.log.error((Object)"Update accountPropFile error:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                throw new LegoCheckedException(-1L, "Update accountPropFile error");
            }
            IUnitePasswordSyncAdminMgr iUnitePasswordMgr = (IUnitePasswordSyncAdminMgr)ServiceLocator.getInstance().getService(IUnitePasswordSyncAdminMgr.class);
            iUnitePasswordMgr.modifySyncAdminPwd(newPwd);
        }
    }

    public void updateUserPwdPModelSuper(long userId, String newPwd, long currentUserid, String currentPwd, int pwdModel, boolean mustModifyPwd) {
        this.log.debug((Object)"updateUserPwdPModelSuper");
        UserInfo currentuser = this.userService.getUserInfoById(currentUserid, false);
        this.authorityService.checkLockSuper(currentuser.getUserName(), currentuser.getUserPwd(), currentPwd, currentuser.getUserPwdSalt());
        UserInfo userInfo = this.userService.getUserInfoById(userId, false);
        boolean isUpdateSetTime = false;
        if (StringUtils.isNotEmpty((CharSequence)newPwd)) {
            userInfo.setUserPwd(KmcInstance.protectPwdEx((String)newPwd));
            userInfo.setUserPwdSalt("");
            isUpdateSetTime = true;
        }
        userInfo.setMustModiPassword(mustModifyPwd);
        userInfo.setPasswordModel(Integer.valueOf(pwdModel));
        this.userService.updateUser(userInfo, isUpdateSetTime);
    }

    public void resetPassword(User userInfo) {
        this.log.debug((Object)"resetPassword(User)");
        UserInfo userInfoTemp = this.userService.getUserInfoById(userInfo.getUserId(), false);
        userInfoTemp.setUserPwd(KmcInstance.protectPwdEx((String)userInfo.getUserPassword()));
        userInfoTemp.setUserPwdSalt("");
        userInfoTemp.setMustModiPassword(false);
        this.userService.updateUser(userInfoTemp, true);
    }

    public void resetPassword(String newPwd, long userId) {
        this.log.debug((Object)"resetPassword");
        UserInfo userInfoTemp = this.userService.getUserInfoById(userId, false);
        userInfoTemp.setUserPwd(KmcInstance.protectPwdEx((String)newPwd));
        userInfoTemp.setUserPwdSalt("");
        userInfoTemp.setMustModiPassword(false);
        this.userService.updateUser(userInfoTemp, true);
    }

    public void lockUser(User userInfo) {
        this.security.lockUser(userInfo.getUserId());
    }

    public void lockUser(long userId) {
        this.security.lockUser(userId);
    }

    public void lockUser(Long[] userIds) {
        if (null != userIds) {
            this.log.debug((Object)"lockUser:userIds is not null");
            Long[] longArray = userIds;
            int n = longArray.length;
            for (int i = 0; i < n; ++i) {
                long i2 = longArray[i];
                this.security.lockUser(i2);
            }
        }
    }

    public void unLockUser(User userInfo) {
        this.security.unLockUser(userInfo.getUserId());
    }

    public void unLockUser(long userId) {
        this.security.unLockUser(userId);
    }

    public void unLockUser(Long[] userIds) {
        if (null != userIds) {
            this.log.debug((Object)"unLockUser:userIds is not null");
            Long[] longArray = userIds;
            int n = longArray.length;
            for (int i = 0; i < n; ++i) {
                long i2 = longArray[i];
                this.security.unLockUser(i2);
            }
        }
    }

    public BatchOperationResult lockUser(List<BatchOperation> list) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int fail = 0;
        int operCount = 0;
        if (null != list) {
            operCount = list.size();
            for (BatchOperation batchOperation : list) {
                try {
                    this.lockAndOnlineUser(batchOperation);
                }
                catch (LegoCheckedException ce) {
                    ++fail;
                    batchOperation.setErrorCode(ce.getErrorCode());
                }
                catch (LegoUncheckedException ue) {
                    ++fail;
                    batchOperation.setErrorCode(ue.getErrorCode());
                }
                catch (Exception e) {
                    ++fail;
                    batchOperation.setErrorCode(102L);
                }
                resultList.add(batchOperation);
            }
            result.setResult(resultList);
            result.setFailCount(fail);
            result.setTotalCount(operCount);
            result.setSucceedCount(operCount - fail);
        } else {
            this.log.debug((Object)"lockUser:list is null");
        }
        return result;
    }

    private void lockAndOnlineUser(BatchOperation batchOperation) {
        this.lockUser(batchOperation.getTargetId());
        List<String> onLineUserSessionList = this.authorityService.getOnlineUserSession(batchOperation.getTargetId());
        if (onLineUserSessionList != null && !onLineUserSessionList.isEmpty()) {
            for (String onLineUserSession : onLineUserSessionList) {
                this.logout(onLineUserSession);
            }
        }
    }

    public BatchOperationResult unLockUser(List<BatchOperation> list) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int fail = 0;
        int operCount = 0;
        if (null != list) {
            operCount = list.size();
            for (BatchOperation batchOperation : list) {
                try {
                    this.unLockUser(batchOperation.getTargetId());
                }
                catch (LegoCheckedException ce) {
                    ++fail;
                    batchOperation.setErrorCode(ce.getErrorCode());
                }
                catch (LegoUncheckedException ue) {
                    ++fail;
                    batchOperation.setErrorCode(ue.getErrorCode());
                }
                catch (Exception e) {
                    ++fail;
                    batchOperation.setErrorCode(102L);
                }
                resultList.add(batchOperation);
            }
            result.setResult(resultList);
            result.setFailCount(fail);
            result.setTotalCount(operCount);
            result.setSucceedCount(operCount - fail);
        } else {
            this.log.debug((Object)"unLockUser:list is null");
        }
        return result;
    }

    public void forceLogout(String sessionId) {
        this.logout(sessionId);
    }

    public SystemSecPolicy getSystemSecPolicy() {
        SystemSecPolicy secPolicy = new SystemSecPolicy();
        UserSecPolicy userPolicy = this.getUserSecPolicy();
        UserLoginPolicy loginPolicy = this.getLoginPolicy();
        secPolicy.setUserSecPolicy(userPolicy);
        secPolicy.setUserLoginPolicy(loginPolicy);
        return secPolicy;
    }

    public void updateSystemSecPolicy(SystemSecPolicy policy) {
        UserSecPolicy userPolicy = policy.getUserSecPolicy();
        UserLoginPolicy loginPolicy = policy.getUserLoginPolicy();
        this.updateUserSecPolicy(userPolicy);
        this.updateLoginPolicy(loginPolicy);
    }

    public UserLoginPolicy getLoginPolicy() {
        UserLoginPolicyInfo info = this.security.getLoginPolicy();
        UserLoginPolicy temp = ObjectConvertor.getUserLoginPolicy(info);
        return temp;
    }

    public void updateLoginPolicy(UserLoginPolicy policy) {
        UserLoginPolicyInfo info = ObjectConvertor.getUserLoginPolicy(policy);
        this.security.updateLoginPolicy(info);
        this.log.debug((Object)"updateLoginPolicy:completed");
    }

    public UserSecPolicy getUserSecPolicy() {
        UserSecPolicyInfo info = this.security.getUserSecPolicy();
        UserSecPolicy temp = ObjectConvertor.getUserSecPolicy(info);
        return temp;
    }

    public void updateUserSecPolicy(UserSecPolicy policy) {
        UserSecPolicyInfo info = ObjectConvertor.getUserSecPolicy(policy);
        this.security.updateUserSecPolicy(info);
        this.log.debug((Object)"updateUserSecPolicy:completed");
    }

    public void setAuthorityService(IAuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setRoleService(IRoleService roleService) {
        this.roleService = roleService;
    }

    public void setUserService(IUserService userService) {
        this.userService = userService;
    }

    public IAuthorityService getAuthorityService() {
        return this.authorityService;
    }

    public IRoleService getRoleService() {
        return this.roleService;
    }

    public IUserService getUserService() {
        return this.userService;
    }

    public void setSecurity(ISecurity security) {
        this.security = security;
    }

    public void setUserRelMoService(IUserRelMoService userRelMoService) {
        this.userRelMoService = userRelMoService;
    }

    public void setCacheService(IUserLoginLocalCache cacheService) {
        this.cacheService = cacheService;
    }

    public void setBroadcastServices(IBroadcastServices broadcastServices) {
        this.broadcastServices = broadcastServices;
    }

    public IOperationService getOperationService() {
        return this.operationService;
    }

    public void setOperationService(IOperationService operationService) {
        this.operationService = operationService;
    }

    public User login(String hostIP, String userName, String pwd) {
        return this.login(hostIP, userName, pwd, true);
    }

    public User login(User userInfo) {
        return this.login(userInfo, true);
    }

    public Boolean checkUserPsw(String userName, String pwd) {
        return this.checkUserPsw(userName, pwd, true);
    }

    public boolean lowerLogin(String upperIP, String upperUsername, String upperPwd) {
        UserInfo userinfo = this.authorityService.loginForUpNms(upperIP, upperUsername, upperPwd, true);
        if (null == userinfo) {
            this.log.debug((Object)"lowerLogin:userinfo is null");
            return false;
        }
        return true;
    }

    public List<String> getUserAuthority(Long userId) {
        return this.userService.getUserAuthority(userId);
    }

    public List<String> getAllUserAuthority() {
        return this.userService.getAllUserAuthority();
    }

    public User loginForUpNms(User user, boolean existInDB) {
        return this.loginForUpNms(user.getIpAdr(), user.getUserName(), user.getUserPassword(), existInDB);
    }

    public User loginForUpNms(String hostIP, String userName, String pwd, boolean existInDB) {
        UserInfo userInfo = null;
        User user = null;
        userInfo = this.authorityService.loginForUpNms(hostIP, userName, pwd, existInDB);
        if (null != userInfo) {
            boolean checkLoginIP = this.checkAclIpAddress(userInfo, hostIP);
            if (!checkLoginIP) {
                throw new LegoCheckedException(265L);
            }
            user = this.setSession(hostIP, existInDB, userInfo);
            if (null != user) {
                user.setMoAuthIdsSet(null);
                user.setMoAutSeth(null);
                user.setMoGroupIdsSet(null);
                user.setMoGroupIdsSet(null);
                user.setRolesIdsSet(null);
                user.setRolesSet(null);
            }
        }
        return user;
    }

    private User setSession(String hostIP, boolean existInDB, UserInfo userInfo) {
        User user;
        this.log.debug((Object)"login authorityService generateSessionId", 1L);
        String sessionId = this.authorityService.generateSessionId(userInfo, hostIP);
        this.log.debug((Object)"login authorityService generateSessionId", 1L);
        if (existInDB) {
            user = ObjectConvertor.getUser(userInfo, sessionId);
        } else {
            this.log.debug((Object)"login create a new user", 1L);
            user = new User();
            user.setSession(sessionId);
            user.setUserId(userInfo.getId());
            user.setDescription(userInfo.getUserDes());
            user.setUserName(userInfo.getUserName());
            user.setSelectType(userInfo.getSelectResView().intValue());
            user.setPasswordModel(userInfo.getPasswordModel().intValue());
            this.setUserIsAdmin(userInfo, user);
            user.setMustModifyPwd(userInfo.isMustModiPassword());
            user.setSetTime(userInfo.getSetTime());
            this.log.debug((Object)"login create a new user end", 1L);
        }
        return user;
    }

    public void checkRDUser(String username) {
        Set curroleset;
        if ("true".equals(LegoProperties.getProperty((String)"isCreateRDUser", (String)""))) {
            return;
        }
        UserInfo userInfo = null;
        try {
            userInfo = this.userService.getUserInfoByName(username, true);
        }
        catch (Exception e) {
            this.log.error((Object)"the user is not exist", 1L);
            return;
        }
        if (null != userInfo && null != (curroleset = userInfo.getRolesSet())) {
            this.checkRdRole(curroleset);
        }
    }

    private void checkRdRole(Set<RoleInfo> curroleset) {
        for (RoleInfo temprole : curroleset) {
            if (!LegoProperties.getProperty((String)"RD.custom.role", (String)"").equals(temprole.getRoleName())) continue;
            this.log.warn((Object)"checkRdRole error.");
            throw new LegoCheckedException(2603L);
        }
    }

    public void updateUserCustomSettings(long userId, Set<UserCustomSetting> updatedSettings) {
        UserInfo userInfoTemp = this.userService.getUserInfoById(userId, false);
        HashSet<UserCustomSetting> settings = userInfoTemp.getUserCustomSettings();
        if (null == settings) {
            this.log.debug((Object)"updateUserCustomSettings:settings is null");
            settings = new HashSet<UserCustomSetting>();
        }
        HashMap<String, UserCustomSetting> existedSettings = new HashMap<String, UserCustomSetting>();
        for (UserCustomSetting setting : settings) {
            existedSettings.put(setting.getItemName(), setting);
        }
        for (UserCustomSetting setting : updatedSettings) {
            String itemName = setting.getItemName();
            String itemValue = setting.getItemValue();
            UserCustomSetting existedSetting = (UserCustomSetting)existedSettings.get(itemName);
            if (null == existedSetting) {
                existedSetting = new UserCustomSetting();
                settings.add(existedSetting);
                existedSetting.setItemName(itemName);
                existedSetting.setUser(userInfoTemp);
            }
            existedSetting.setItemValue(itemValue);
        }
        this.userService.updateUser(userInfoTemp, false);
    }

    public Set<UserCustomSetting> getUserCustomSettings(long userId) {
        UserInfo userInfotemp = this.userService.getUserInfoById(userId, false);
        Set settings = userInfotemp.getUserCustomSettings();
        return settings;
    }

    public boolean checkAclIpAddress(String userName, String ipAddress) {
        UserInfo userInfo = this.userService.getUserInfoByName(userName, false);
        return this.checkAclIpAddress(userInfo, ipAddress);
    }

    private boolean checkAclIpAddress(UserInfo userInfo, String ipAddress) {
        return this.checkAclIpAddress(userInfo, ipAddress, userInfo.getUserAcls());
    }

    private boolean checkAclIpAddress(UserInfo userInfo, String ipAddress, Set<UserAclInfo> userAcls) {
        boolean allowedAddress = false;
        allowedAddress = userInfo.isAdmin() && AddressUtil.checkLocalIP((String)ipAddress) ? true : this.security.checkIP(ipAddress, userAcls);
        return allowedAddress;
    }

    public boolean adminAuth(String userName, String pwd) {
        return !VerifyUtil.isEmpty((Object)this.authorityService.login("", pwd, userName));
    }
}

