/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.user.service;

import com.huawei.lego.cbb.user.dao.IRoleDao;
import com.huawei.lego.cbb.user.dao.IUserDao;
import com.huawei.lego.cbb.user.sdk.hibernate.model.RoleInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserAclInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserInfo;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.service.IUserService;
import com.huawei.lego.cbb.user.service.common.ObjectConvertor;
import com.huawei.lego.cbb.user.service.common.SystemInitializeUser;
import com.huawei.lego.cbb.user.service.userrelmo.UserRelMoService;
import com.huawei.lego.core.base.persistance.dao.ICommonDao;
import com.huawei.lego.core.sdk.comm.Paging;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UserService
implements IUserService {
    private static final long DEFALT_ID = 1L;
    private IUserDao userDao;
    private IRoleDao roleDao;
    private ICommonDao comDao;
    private SystemInitializeUser systemInitUser;
    private Log log = LogFactory.getInstance(UserService.class);
    private UserRelMoService userRelMoService;

    @Override
    public void initSysUser() {
        UserInfo info = null;
        try {
            info = this.getUserInfoById(1L, false);
        }
        catch (Exception e) {
            this.log.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
        if (null == info) {
            UserInfo defaultUser = this.systemInitUser.getDefaultUserInfo();
            this.userDao.addUser(defaultUser);
        }
    }

    @Override
    public synchronized long addUserInfo(UserInfo oUserInfo) {
        UserInfo userInfo = null;
        this.userDao.checkUserLimit(true);
        try {
            userInfo = this.userDao.getUserByName(oUserInfo.getUserName(), false);
        }
        catch (Exception e) {
            this.log.error((Object)("get user by name failed, user is Exist, exception: " + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        if (null != userInfo) {
            throw new LegoCheckedException(263L);
        }
        long setTime = System.currentTimeMillis();
        oUserInfo.setSetTime(setTime);
        long userId = this.userDao.addUser(oUserInfo);
        oUserInfo.setId(Long.valueOf(userId));
        return userId;
    }

    @Override
    public long addUserInfo(UserInfo oUserInfo, Set<Long> roleIds, Set<Long> moIds, Set<Long> moGroupIds) {
        HashSet<RoleInfo> roleSet = null;
        if (null != roleIds) {
            roleSet = new HashSet<RoleInfo>();
            for (long i : roleIds) {
                RoleInfo info = null;
                try {
                    info = this.roleDao.getRoleById(i, false);
                }
                catch (Exception e) {
                    this.log.info((Object)("role is not Exist, exception: " + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
                }
                if (null == info) continue;
                roleSet.add(info);
            }
        }
        if (null == roleSet || roleSet.isEmpty()) {
            throw new LegoCheckedException(262L);
        }
        oUserInfo.setRolesSet(roleSet);
        long newUserId = this.addUserInfo(oUserInfo);
        this.userRelMoService.addUserRelMo(newUserId, moIds, moGroupIds);
        return newUserId;
    }

    @Override
    public void deleteUser(long userId) {
        this.userDao.deleteUser(userId);
        this.userRelMoService.deleteMOByUserId(userId);
    }

    @Override
    public void deleteUser(Long[] userIds) {
        if (null != userIds && userIds.length > 0) {
            Long[] longArray = userIds;
            int n = longArray.length;
            for (int i = 0; i < n; ++i) {
                long itemp = longArray[i];
                this.deleteUser(itemp);
            }
        } else {
            this.log.info((Object)"userIds is null", 1L);
        }
    }

    @Override
    public List<UserInfo> getAllUser() {
        return this.userDao.getAllUser(false);
    }

    @Override
    public Paging getAllUser(Map<String, String> map, int iStart, int iLength) {
        Paging roPaging = new Paging();
        if (null != map) {
            String hql = this.getHqlByCondition(map);
            List<?> userList = this.comDao.findPage(hql, iStart, iLength);
            StringBuffer buffer = new StringBuffer("select count(*) from UserInfo ");
            int iCount = Integer.parseInt(String.valueOf(this.comDao.getBaseHibernateTemplate().find(buffer.toString(), new Object[0]).listIterator().next()));
            roPaging.setiCount(iCount);
            roPaging.setData(userList);
        }
        return roPaging;
    }

    @Override
    public UserInfo getFullUserInfoById(Long userId) {
        UserInfo userInfo = this.userDao.getUserInfoById(userId, true);
        if (null != userInfo && !userInfo.isAdmin()) {
            Set rolesSet = userInfo.getRolesSet();
            HashSet<RoleInfo> rolesSetTemp = new HashSet<RoleInfo>();
            for (RoleInfo roleInfo : rolesSet) {
                RoleInfo temp = this.roleDao.getRoleById(roleInfo.getRoleIdx(), true);
                rolesSetTemp.add(temp);
            }
            userInfo.setRolesSet(rolesSetTemp);
        }
        return userInfo;
    }

    @Override
    public UserInfo getUserInfoByName(String userName, boolean isFetchRole) {
        return this.userDao.getUserByName(userName, isFetchRole);
    }

    @Override
    public UserInfo getUserInfoById(long userId, boolean isFetchRole) {
        return this.userDao.getUserInfoById(userId, isFetchRole);
    }

    @Override
    public String getSaltByUserName(String userName) {
        String salt = "";
        UserInfo userInfo = null;
        try {
            userInfo = this.userDao.getUserByName(userName, false);
        }
        catch (Exception e) {
            return salt;
        }
        if (null != userInfo) {
            salt = userInfo.getUserPwdSalt();
        }
        return salt;
    }

    @Override
    public void updateUser(UserInfo userInfo, boolean isUpdateSetTime) {
        this.log.debug((Object)"updateUser UserInfo");
        UserInfo ui = this.userDao.getUserInfoById(userInfo.getId(), false);
        if (userInfo.getPasswordModel() == 0) {
            if (ui == null || isUpdateSetTime) {
                long setTime = System.currentTimeMillis();
                userInfo.setSetTime(setTime);
            } else {
                userInfo.setSetTime(ui.getSetTime());
            }
        }
        this.userDao.updateUser(userInfo);
    }

    @Override
    public void updateUser(User user) {
        this.log.debug((Object)"updateUser user");
        UserInfo oUserInfo = this.coventUser(user);
        Set<UserAclInfo> userAclInfoSet = ObjectConvertor.getUserAclInfo(user.getUserAclSet());
        oUserInfo.setUserAcls(userAclInfoSet);
        this.updateUser(oUserInfo, false);
        Set moIds = user.getMoAuthIdsSet();
        Set moGroupIds = user.getMoGroupIdsSet();
        this.userRelMoService.deleteMOByUserId(user.getUserId());
        this.userRelMoService.addUserRelMo(oUserInfo.getId(), moIds, moGroupIds);
    }

    private UserInfo coventUser(User user) {
        UserInfo oUserInfo = null;
        oUserInfo = ObjectConvertor.getUserInfo(user);
        Set roleIds = null;
        roleIds = user.getRolesIdsSet();
        if (null != roleIds) {
            HashSet<RoleInfo> roleSet = new HashSet<RoleInfo>();
            Iterator iterator = roleIds.iterator();
            while (iterator.hasNext()) {
                long i = (Long)iterator.next();
                RoleInfo roleInfTemp = this.roleDao.getRoleById(i, false);
                if (roleInfTemp != null) {
                    roleSet.add(roleInfTemp);
                    continue;
                }
                this.log.warn((Object)"role not exist.");
                throw new LegoCheckedException(262L);
            }
            oUserInfo.setRolesSet(roleSet);
        }
        return oUserInfo;
    }

    private String getFile(String file) {
        String rtnFile = "";
        rtnFile = file.equalsIgnoreCase("sUserName") ? "userName" : (file.equalsIgnoreCase("description") ? "userDes" : file);
        return rtnFile;
    }

    public void setUserDao(IUserDao userDao) {
        this.userDao = userDao;
    }

    public void setRoleDao(IRoleDao roleDao) {
        this.roleDao = roleDao;
    }

    public void setSystemInitUser(SystemInitializeUser systemInitUser) {
        this.systemInitUser = systemInitUser;
    }

    public void setComDao(ICommonDao comDao) {
        this.comDao = comDao;
    }

    public void setUserRelMoService(UserRelMoService userRelMoService) {
        this.userRelMoService = userRelMoService;
    }

    private String getHqlByCondition(Map<String, String> map) {
        if (null == map) {
            return "FROM UserInfo ";
        }
        StringBuffer sBufQObj = new StringBuffer("FROM UserInfo ");
        Set<Map.Entry<String, String>> condition = map.entrySet();
        String order = "";
        String fileName = "";
        for (Map.Entry<String, String> entry : condition) {
            String key = entry.getKey();
            String filevalue = entry.getValue();
            String value = this.getFile(filevalue);
            if (key.equalsIgnoreCase("DESC") || key.equalsIgnoreCase("ASC")) {
                order = key;
                fileName = "order by " + value + " ";
                continue;
            }
            sBufQObj.append(" where ");
            sBufQObj.append(key + " like '*");
            sBufQObj.append(value);
            sBufQObj.append("*'");
        }
        sBufQObj.append(fileName);
        sBufQObj.append(order);
        return sBufQObj.toString();
    }

    @Override
    public List<String> getUserAuthority(Long userId) {
        List<?> list = this.comDao.findBySql("select opt_url from T_operations where opt_id in(select opt_id from T_operation_r_role where role_id in (select role_id from T_user_r_role where user_id = " + userId + "))");
        Iterator<?> itt = list.iterator();
        ArrayList<String> result = new ArrayList<String>();
        while (itt.hasNext()) {
            Object obj = itt.next();
            if (null == obj) continue;
            try {
                String ss = (String)obj;
                if (ss.trim().equals("")) continue;
                result.add(ss);
            }
            catch (Exception ex) {
                this.log.error((Object)ExceptionUtil.getErrorMessage((Throwable)ex), 1L);
            }
        }
        return result;
    }

    @Override
    public List<String> getAllUserAuthority() {
        List<?> list = this.comDao.findBySql("select opt_url from T_operations");
        Iterator<?> it = list.iterator();
        ArrayList<String> result = new ArrayList<String>();
        while (it.hasNext()) {
            String s;
            Object obj = it.next();
            if (null == obj || (s = (String)obj).trim().equals("")) continue;
            result.add(s);
        }
        return result;
    }

    @Override
    public RoleInfo getRoleByName(String roleName) {
        RoleInfo roleInfo = null;
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, roleName);
        List<?> allRoleList = this.comDao.findByHql("FROM RoleInfo u where u.roleName = ?", param);
        if (null != allRoleList && !allRoleList.isEmpty()) {
            roleInfo = (RoleInfo)allRoleList.get(0);
        }
        return roleInfo;
    }

    @Override
    public boolean checkUserExist(String userName) {
        UserInfo userInfo = null;
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, userName);
        List<?> allUserList = this.comDao.findByHql("FROM UserInfo u where u.userName = ?", param);
        if (null != allUserList && !allUserList.isEmpty()) {
            userInfo = (UserInfo)allUserList.get(0);
        }
        return null != userInfo;
    }

    @Override
    public void setOldUserLog(String username) {
        StringBuffer sbf = new StringBuffer();
        sbf.append("update OptLogMo t set t.isOld='true'");
        sbf.append(" where t.opUser=?");
        Object[] param = new Object[]{username};
        this.comDao.updateByHql(sbf.toString(), param);
    }
}

