/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.user.service.common;

import com.huawei.ism.drm.wcc.util.kmc.KmcInstance;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserAclInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserLoginPolicyInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserSecPolicyInfo;
import com.huawei.lego.cbb.user.service.IUserService;
import com.huawei.lego.cbb.user.service.security.ISecurity;
import com.huawei.lego.core.base.persistance.dao.ICommonDao;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.file.util.AdapterUtils;
import com.huawei.lego.core.sdk.file.util.FileUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.KmcCompatible;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.InitializingBean;

public class SystemInitializeUser
implements SystemStatusChangedListener,
InitializingBean {
    private static final String DEFALT_USER_NAME = "admin";
    private static final String DEFALT_USER_NAME_SYNC = "SyncAdmin";
    private static final String DEFAULT_PROPERTIES = "conf.properties";
    private static final Properties PROPS = new Properties();
    private static final String SYS_DEFAULT_SYNC_USER_PWD_ISCHANGED = "sys.default.syncUserPwd.ischanged";
    private static Log log = LogFactory.getInstance(SystemInitializeUser.class);
    private static boolean propertyInit = false;
    private transient ISecurity security;
    private transient IUserService userService;
    private ICommonDao commonDao;

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() == Status.STATUS_STARTED) {
            this.afterPropertiesSet();
        }
    }

    public void afterPropertiesSet() {
        this.initProperty();
        this.initSysUser();
        this.initSysSyncUser();
        this.initSysLoginPolicy();
        this.initAccountProperty();
    }

    private void initAccountProperty() {
        String file = "conf" + File.separator + "account.properties";
        HashMap<String, String> data = new HashMap<String, String>();
        try {
            this.diffSysUser(data);
            LegoConfig.diffDataBaseConfig(data);
            FileUtil.modifyPropFileUsingStr((String)file, data, (String)file);
        }
        catch (Exception e) {
            log.error((Object)"Update accountPropFile error:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }

    private void diffSysUser(Map<String, String> data) {
        UserInfo syncUserInfo;
        try {
            syncUserInfo = this.userService.getUserInfoByName(DEFALT_USER_NAME_SYNC, false);
        }
        catch (LegoCheckedException e) {
            log.error((Object)"System not exist syncSyncUser.");
            return;
        }
        String enSynUserPwd = LegoConfig.getInstance().getKeyValue("sys.default.syncUserPwd", "");
        if (!KmcCompatible.isDataSame((String)WccEncryptor.decrypt((String)enSynUserPwd), (String)syncUserInfo.getUserPwdSalt(), (String)syncUserInfo.getUserPwd())) {
            data.put(SYS_DEFAULT_SYNC_USER_PWD_ISCHANGED, "true");
        } else {
            data.put(SYS_DEFAULT_SYNC_USER_PWD_ISCHANGED, "false");
        }
    }

    private void initSysUser() {
        UserInfo userInfo = null;
        UserAclInfo aclInfoV4 = null;
        UserAclInfo aclInfoV6 = null;
        try {
            userInfo = this.userService.getUserInfoByName(DEFALT_USER_NAME, false);
        }
        catch (Exception e) {
            log.error((Object)"System not exist user", 1L);
        }
        if (null == userInfo) {
            this.initProperty();
            UserInfo defaultUser = this.getDefaultUserInfo();
            aclInfoV4 = this.getDefaultUserAclInfoV4();
            aclInfoV6 = this.getDefaultUserAclInfoV6();
            defaultUser.addTouserAcls(aclInfoV4);
            defaultUser.addTouserAcls(aclInfoV6);
            this.commonDao.saveOrUpdate(defaultUser);
        }
    }

    private void initSysSyncUser() {
        UserInfo syncUserInfo = null;
        UserAclInfo aclInfoV4 = null;
        UserAclInfo aclInfoV6 = null;
        try {
            syncUserInfo = this.userService.getUserInfoByName(DEFALT_USER_NAME_SYNC, false);
        }
        catch (Exception e) {
            log.error((Object)"System not exist syncSyncUser", 1L);
        }
        if (null == syncUserInfo) {
            this.initProperty();
            UserInfo defaultUser = this.getDefaultSyncUserInfoLego();
            aclInfoV4 = this.getDefaultUserAclInfoV4();
            aclInfoV6 = this.getDefaultUserAclInfoV6();
            defaultUser.addTouserAcls(aclInfoV4);
            defaultUser.addTouserAcls(aclInfoV6);
            this.commonDao.saveOrUpdate(defaultUser);
        }
    }

    private void initSysLoginPolicy() {
        UserSecPolicyInfo secInfo;
        UserLoginPolicyInfo info = this.security.getLoginPolicy();
        if (null == info) {
            this.initProperty();
            UserLoginPolicyInfo defaultLoginPolicy = this.getDefaultLoginPolicy();
            this.commonDao.save(defaultLoginPolicy);
        }
        if (null == (secInfo = this.security.getUserSecPolicy())) {
            this.initProperty();
            UserSecPolicyInfo defaultSecPolicy = this.getDefaultSecPolicy();
            this.commonDao.save(defaultSecPolicy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initProperty() {
        if (!propertyInit) {
            InputStream stream = null;
            try {
                String jarfileName = AdapterUtils.getClassJarPath(SystemInitializeUser.class);
                ClassLoader classLoader = AdapterUtils.getClassLoader(SystemInitializeUser.class);
                if (null == jarfileName || null == classLoader) {
                    log.error((Object)"get SystemInitializeUser ClassLoader fail");
                    return;
                }
                URL url = AdapterUtils.getUrlResourceFromJar((ClassLoader)classLoader, (String)jarfileName, (String)DEFAULT_PROPERTIES);
                if (null != url) {
                    stream = url.openStream();
                    PROPS.load(stream);
                }
            }
            catch (IOException e) {
                log.error((Object)"read default.properties fail.", (Throwable)e, 1L);
            }
            catch (Exception e) {
                log.error((Object)("read default.properties fail." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
            finally {
                try {
                    if (null != stream) {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)"IOException", (Throwable)e, 1L);
                }
            }
            Properties sysProps = System.getProperties();
            sysProps.putAll((Map<?, ?>)PROPS);
            System.setProperties(sysProps);
            propertyInit = true;
        }
    }

    public String getProperty(String key, String defaultValue) {
        String value = PROPS.getProperty(key);
        if (null == value || value.length() <= 0) {
            value = defaultValue;
        }
        return value;
    }

    public int getInt(String key) {
        String value = PROPS.getProperty(key);
        if (null == value || value.length() <= 0) {
            return 0;
        }
        return NumberUtil.convertToInteger((Object)value);
    }

    public UserInfo getDefaultUserInfoLego() {
        UserInfo info = new UserInfo();
        String userName = this.getProperty("sys.defalt.userName", "");
        String pwd = this.getProperty("sys.defalt.userPwd", "");
        info.setAdmin(true);
        info.setUserName(userName);
        info.setUserPwd(KmcInstance.protectPwdEx((String)WccEncryptor.decrypt((String)pwd)));
        info.setUserPwdSalt("");
        info.setMustModiPassword(true);
        info.setPasswordModel(Integer.valueOf(0));
        info.setSessionControl(Boolean.valueOf(false));
        info.setSessionLimit(Integer.valueOf(0));
        long setTime = System.currentTimeMillis();
        info.setSetTime(setTime);
        return info;
    }

    public UserInfo getDefaultSyncUserInfoLego() {
        UserInfo info = new UserInfo();
        String userName = this.getProperty("sys.defalt.syncUserName", "");
        String pwd = this.getProperty("sys.defalt.syncUserPwd", "");
        info.setAdmin(true);
        info.setUserName(userName);
        info.setUserPwd(KmcInstance.protectPwdEx((String)WccEncryptor.decrypt((String)pwd)));
        info.setUserPwdSalt("");
        info.setMustModiPassword(false);
        info.setPasswordModel(Integer.valueOf(0));
        info.setSessionControl(Boolean.valueOf(false));
        info.setSessionLimit(Integer.valueOf(0));
        info.setUserDes("user_syncAdmin_description_label");
        long setTime = System.currentTimeMillis();
        info.setSetTime(setTime);
        return info;
    }

    public UserInfo getDefaultUserInfo() {
        return this.getDefaultUserInfoLego();
    }

    public UserLoginPolicyInfo getDefaultLoginPolicy() {
        UserLoginPolicyInfo info = new UserLoginPolicyInfo();
        int lgoinInterval = this.getInt("system.login.policy.lgoinInterval");
        int lgoinCount = this.getInt("system.login.policy.lgoinCount");
        int lockTime = this.getInt("system.login.policy.lockTime");
        int unseal = 1;
        int sessionTimeOut = this.getInt("system.login.policy.sessionTimeOut");
        info.setId(Long.valueOf(1L));
        info.setLgoinCount(Integer.valueOf(lgoinCount));
        info.setLgoinInterval(Integer.valueOf(lgoinInterval));
        info.setLockTime(Integer.valueOf(lockTime));
        info.setSessionTimeOut(Integer.valueOf(sessionTimeOut));
        info.setUnseal(Integer.valueOf(unseal));
        return info;
    }

    public UserSecPolicyInfo getDefaultSecPolicy() {
        UserSecPolicyInfo info = new UserSecPolicyInfo();
        int pswLenth = this.getInt("system.sec.policy.pswLenth");
        int unseal = this.getInt("system.sec.policy.unseal");
        int usefulLife = this.getInt("system.sec.policy.usefulLife");
        String complex = this.getProperty("system.sec.policy.complex", "");
        info.setComplex(complex);
        info.setPswLenth(Integer.valueOf(pswLenth));
        info.setUnseal(Integer.valueOf(unseal));
        info.setUsefulLife(Integer.valueOf(usefulLife));
        info.setId(Long.valueOf(1L));
        return info;
    }

    public UserAclInfo getDefaultUserAclInfoV4() {
        UserAclInfo info = new UserAclInfo();
        String startIp = this.getProperty("system.sec.acl.startip", "");
        String endIp = this.getProperty("system.sec.acl.endip", "");
        info.setEndIp(endIp);
        info.setStartIp(startIp);
        return info;
    }

    public UserAclInfo getDefaultUserAclInfoV6() {
        UserAclInfo info = new UserAclInfo();
        String startIp = this.getProperty("system.sec.acl.v6.startip", "");
        String endIp = this.getProperty("system.sec.acl.v6.endip", "");
        info.setEndIp(endIp);
        info.setStartIp(startIp);
        return info;
    }

    public void setSecurity(ISecurity security) {
        this.security = security;
    }

    public void setUserService(IUserService userService) {
        this.userService = userService;
    }

    public void setCommonDao(ICommonDao commonDao) {
        this.commonDao = commonDao;
    }
}

