/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.user.thirdauth;

import com.huawei.lego.cbb.user.dao.IRoleDao;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserAclInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserInfo;
import com.huawei.lego.cbb.user.service.common.SystemInitializeUser;
import com.huawei.lego.cbb.user.thirdauth.sdk.ISSOAuthority;
import com.huawei.lego.cbb.user.thirdauth.sdk.UserAuthorityType;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.util.concurrent.atomic.AtomicLong;

public class SSOAuthority
implements ISSOAuthority {
    public static final long OC_ADMIN_ROLE = -1L;
    public static final int SESSION_LIMIT = 8;
    private static final long STEP = 2L;
    private SystemInitializeUser initializer;
    private IRoleDao roleDao;
    private AtomicLong ssoUserIdGenerator = new AtomicLong(Long.MAX_VALUE);

    public SystemInitializeUser getInitializer() {
        return this.initializer;
    }

    public void setInitializer(SystemInitializeUser initializer) {
        this.initializer = initializer;
    }

    public IRoleDao getRoleDao() {
        return this.roleDao;
    }

    public void setRoleDao(IRoleDao roleDao) {
        this.roleDao = roleDao;
    }

    public Boolean userAuthority(String userName, String password) {
        UserInfo userInfo = this.userAuthority(userName, password, false);
        return userInfo != null;
    }

    public UserAuthorityType getAuthorityType() {
        return UserAuthorityType.sso;
    }

    public UserInfo userAuthority(String username, String password, Boolean admin) {
        long id;
        int index = username.lastIndexOf(35);
        if (index != -1) {
            String userId = username.substring(index + 1);
            id = -NumberUtil.convertToLong((Object)userId).longValue();
            username = username.substring(0, index);
        } else {
            id = this.ssoUserIdGenerator.addAndGet(-2L) / 2L - 0x3FFFFFFFFFFFFFFFL;
        }
        return this.create(id, username);
    }

    public UserInfo create(long id, String username) {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(Long.valueOf(id));
        userInfo.setUserName(username);
        userInfo.setLock(false);
        userInfo.setMustModiPassword(false);
        userInfo.setAdmin(true);
        userInfo.setSessionLimit(Integer.valueOf(8));
        userInfo.setSessionControl(Boolean.valueOf(true));
        userInfo.setPasswordModel(Integer.valueOf(UserAuthorityType.sso.getValue()));
        UserAclInfo aclInfo = this.initializer.getDefaultUserAclInfoV4();
        UserAclInfo aclInfoV6 = this.initializer.getDefaultUserAclInfoV6();
        userInfo.addTouserAcls(aclInfo);
        userInfo.addTouserAcls(aclInfoV6);
        userInfo.addTorolesSet(this.roleDao.getRoleById(-1L, true));
        return userInfo;
    }
}

