/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.comm.internal.jms;

import com.huawei.lego.comm.internal.jms.MessageRegister;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public abstract class MessageTaskManager {
    private ExecutorService threadPool = null;
    private String listenerAppName = "";
    private transient Log logger = LogFactory.getInstance(MessageTaskManager.class);

    public MessageTaskManager() {
        this.buildThraedPool(2, this.getClass().getName());
    }

    public MessageTaskManager(int poolsize, String listenAppName) {
        this.buildThraedPool(poolsize, listenAppName);
    }

    private void buildThraedPool(int poolsize, String listenAppName) {
        this.threadPool = 0 < poolsize && 11 > poolsize ? Executors.newFixedThreadPool(poolsize) : Executors.newFixedThreadPool(2);
        if (null != listenAppName && listenAppName.equals("")) {
            throw new LegoUncheckedException("when creating MessageTaskManager,the args needed listenerAppName,but current name is : " + listenAppName);
        }
        this.listenerAppName = listenAppName;
    }

    public abstract void onMessage(MessageUnit var1);

    public abstract MessageRegister[] getTypes();

    public final void setMessage(byte[] b) {
        MessageTask mt = new MessageTask();
        mt.setB(b);
        Future<?> f = this.threadPool.submit(mt);
        if (null == f) {
            this.logger.error((Object)"threadPool.submit failed.", 1L);
        }
    }

    public final void destory() {
        try {
            if (null != this.threadPool) {
                this.threadPool.shutdown();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Exception " + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageUnit decodeMessage(byte[] b) {
        MessageUnit mu = null;
        ObjectInputStream oos = null;
        ByteArrayInputStream os = null;
        try {
            os = new ByteArrayInputStream(b);
            oos = new ObjectInputStream(os);
            mu = (MessageUnit)oos.readObject();
        }
        catch (Exception e) {
            this.logger.error((Object)("Exception " + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            try {
                if (null != os) {
                    os.close();
                }
            }
            catch (IOException e) {
                this.logger.error((Object)"decodeMessage(byte[] b) is error!!", (Throwable)e, 1L);
            }
            try {
                if (null != oos) {
                    oos.close();
                }
            }
            catch (IOException e) {
                this.logger.error((Object)"decodeMessage(byte[] b) is error!!", (Throwable)e, 1L);
            }
        }
        return mu;
    }

    public class MessageTask
    implements Runnable {
        private byte[] b = null;

        public byte[] getB() {
            return this.b;
        }

        public void setB(byte[] b) {
            this.b = b;
        }

        @Override
        public void run() {
            if (null != this.b) {
                long first = System.currentTimeMillis();
                MessageUnit mu = MessageTaskManager.this.decodeMessage(this.b);
                long second = System.currentTimeMillis();
                if (null == mu) {
                    return;
                }
                MessageTaskManager.this.logger.debug((Object)("be ready for onMessage(mu)!receiveApp's name is :" + MessageTaskManager.this.listenerAppName + " | the command code is : " + mu.getCmdcode() + "||||the time is : " + (second - first)), 1L);
                MessageTaskManager.this.onMessage(mu);
            }
        }
    }
}

