/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.comm.internal.jms.productor;

import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.comm.internal.jms.core.MsqQueueClient;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.exception.jms.LegoJMSDestoryException;
import com.huawei.lego.core.sdk.exception.jms.LegoJMSInitializeException;
import com.huawei.lego.core.sdk.exception.jms.LegoJMSRuntimeException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantLock;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.apache.activemq.ActiveMQConnectionFactory;

public class TopicClient
implements MsqQueueClient {
    private TopicConnection conn;
    private TopicSession session;
    private String name;
    private Topic topic;
    private TopicPublisher publisher;
    private TopicSubscriber subscriber;
    private MessageListener messagelistener = null;
    private String filter = "";
    private String url = "";
    private final ReentrantLock sessionLock = new ReentrantLock();
    private BlockingQueue<MessageUnit> failMsgs = new LinkedBlockingQueue<MessageUnit>();
    private transient Log log = LogFactory.getInstance(TopicClient.class);

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Override
    public void setListener(MessageListener listener) {
        this.log.info((Object)("Set listener " + this.topic), 1L);
        try {
            this.subscriber = this.filter.equals("") ? this.session.createSubscriber(this.topic) : this.session.createSubscriber(this.topic, this.filter, false);
            if (null == this.messagelistener) {
                this.messagelistener = listener;
            }
            this.subscriber.setMessageListener(listener);
        }
        catch (JMSException e) {
            this.log.error((Object)"setListener create subscriber error!", (Throwable)e, 1L);
            throw new LegoJMSRuntimeException("setListener create subscriber error!", (Throwable)e);
        }
    }

    @Override
    public void connect(String connectFactory) {
        this.url = connectFactory;
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(connectFactory);
        try {
            this.doReConnect((TopicConnectionFactory)connectionFactory);
            this.log.info((Object)"conn.start() is successful!", 1L);
            this.session = this.conn.createTopicSession(false, 1);
            this.topic = this.session.createTopic(this.name);
            this.publisher = this.session.createPublisher(this.topic);
        }
        catch (JMSException e) {
            this.log.error((Object)"connect activemq server error!", (Throwable)e, 1L);
            throw new LegoJMSInitializeException("connect activemq server error!", (Throwable)e);
        }
    }

    private void doReConnect(TopicConnectionFactory tcf) {
        try {
            this.conn = tcf.createTopicConnection();
            this.log.info((Object)"conn = connectionFactory.createTopicConnection()!", 1L);
            this.conn.start();
        }
        catch (Exception e) {
            try {
                if (null != this.conn) {
                    this.conn.close();
                }
                this.log.info((Object)"Attempt to connect Broker is failed, Do reconnect after 3s!", 1L);
                CommonUtil.sleep((long)3000L);
            }
            catch (Exception e1) {
                this.log.error((Object)("sleep is error : --" + ExceptionUtil.getErrorMessage((Throwable)e1)), 1L);
            }
            this.doReConnect(tcf);
        }
    }

    @Override
    public void closeRecv() {
        try {
            this.subscriber.close();
        }
        catch (JMSException e) {
            this.log.error((Object)"error occur closing receiver ", (Throwable)e, 1L);
            throw new LegoJMSDestoryException("error occur closing receiver ", (Throwable)e);
        }
    }

    @Override
    public void sendObj(MessageUnit detail) {
        this.sendObj(detail, true);
    }

    private void sendObj(MessageUnit detail, boolean retry) {
        BytesMessage bytesMessage = null;
        try {
            bytesMessage = this.session.createBytesMessage();
            bytesMessage.writeBytes(this.encodeSendMessage(detail));
            bytesMessage.setLongProperty("filter", detail.getCmdcode());
        }
        catch (JMSException e) {
            this.log.error((Object)"ActiveMQ create message object error!", (Throwable)e, 1L);
            if (this.sessionLock.isLocked()) {
                this.log.warn((Object)"sessionLock is lock! add message to failMsgs.");
                try {
                    this.failMsgs.put(detail);
                }
                catch (InterruptedException e1) {
                    this.log.error((Object)"failMsgs.put(mu) is InterruptedException!!", 1L);
                    return;
                }
                return;
            }
            if (retry) {
                this.rebuildsession();
                this.sendObj(detail, false);
                while (this.failMsgs.peek() != null) {
                    MessageUnit mu = (MessageUnit)this.failMsgs.poll();
                    this.sendObj(mu, false);
                }
                return;
            }
            throw new LegoJMSRuntimeException("ActiveMQ create message object error!", (Throwable)e);
        }
        try {
            this.publisher.publish((Message)bytesMessage);
        }
        catch (JMSException e) {
            this.log.error((Object)"ActiveMQ publisher error!", (Throwable)e, 1L);
            throw new LegoJMSRuntimeException("ActiveMQ publisher error!", (Throwable)e);
        }
    }

    public byte[] encodeSendMessage(MessageUnit detail) {
        byte[] bytes = null;
        ByteArrayOutputStream os = null;
        ObjectOutputStream oos = null;
        try {
            os = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(os);
            oos.writeObject(detail);
            bytes = os.toByteArray();
        }
        catch (IOException e) {
            this.log.error((Object)"encodeMessage is error!", (Throwable)e, 1L);
            throw new LegoUncheckedException("encodeSendMessage is error!", (Throwable)e);
        }
        finally {
            try {
                if (null != oos) {
                    oos.close();
                }
            }
            catch (IOException e) {
                this.log.error((Object)"stream's closing is error!", (Throwable)e, 1L);
            }
            try {
                if (null != os) {
                    os.close();
                }
            }
            catch (IOException e) {
                this.log.error((Object)"stream's closing is error!", (Throwable)e, 1L);
            }
        }
        return bytes;
    }

    private void reconnect(String connectFactory) {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(connectFactory);
        try {
            this.disconnect();
            this.conn = connectionFactory.createTopicConnection();
            this.conn.start();
            this.session = this.conn.createTopicSession(false, 1);
            this.topic = this.session.createTopic(this.name);
            this.publisher = this.session.createPublisher(this.topic);
            if (null != this.messagelistener) {
                this.setListener(this.messagelistener);
            } else {
                this.log.error((Object)"when reconnect,the TopoicClient's SubscriberProxy-messagelistener is null !!", 1L);
            }
        }
        catch (JMSException e) {
            this.log.error((Object)"reconnect activemq server error!", (Throwable)e, 1L);
            throw new LegoJMSInitializeException("reconnect activemq server error!", (Throwable)e);
        }
    }

    private void rebuildsession() {
        this.sessionLock.lock();
        try {
            this.closeSubscriberPublisherAndSession();
            this.session = this.conn.createTopicSession(false, 1);
            this.topic = this.session.createTopic(this.name);
            this.publisher = this.session.createPublisher(this.topic);
            if (null != this.messagelistener) {
                this.setListener(this.messagelistener);
            } else {
                this.log.error((Object)"when rebuildsession,the TopoicClient's SubscriberProxy-messagelistener is null !!", 1L);
            }
        }
        catch (JMSException e) {
            this.log.error((Object)"rebuildsession error!!", (Throwable)e, 1L);
            this.reconnect(this.url);
        }
        finally {
            this.sessionLock.unlock();
        }
    }

    @Override
    public void disconnect() {
        JMSException ex = null;
        boolean shouldThrow = false;
        try {
            this.closeSubscriberPublisherAndSession();
        }
        catch (JMSException e) {
            ex = e;
            shouldThrow = true;
        }
        if (null != this.conn) {
            try {
                this.conn.close();
            }
            catch (JMSException e) {
                ex = e;
                shouldThrow = true;
            }
        }
        if (shouldThrow) {
            this.log.error((Object)"disconnect topic error!", (Throwable)ex, 1L);
            throw new LegoJMSDestoryException("disconnect topic error!", (Throwable)ex);
        }
    }

    private void closeSubscriberPublisherAndSession() throws JMSException {
        JMSException ex = null;
        boolean shouldThrow = false;
        try {
            if (null != this.subscriber) {
                this.subscriber.close();
            }
        }
        catch (JMSException e) {
            ex = e;
            shouldThrow = true;
        }
        try {
            if (null != this.publisher) {
                this.publisher.close();
            }
        }
        catch (JMSException e) {
            ex = e;
            shouldThrow = true;
        }
        try {
            if (null != this.session) {
                this.session.close();
            }
        }
        catch (JMSException e) {
            ex = e;
            shouldThrow = true;
        }
        if (shouldThrow) {
            throw ex;
        }
    }
}

