/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.comm.security;

import com.huawei.lego.comm.security.CertificateServerCallbackManager;
import com.huawei.lego.comm.security.IBcmX509TrustHandler;
import com.huawei.lego.comm.security.SecurityCertificateManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.file.util.FileUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.PathUtil;
import java.io.File;
import java.security.KeyStore;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class BcmX509TrustManager
implements X509TrustManager {
    public static final long SYS_CERT_NOT_VALID = 1073947460L;
    public static final long SYS_CERT_NOT_TRUST = 1073947461L;
    public static final String KEYSTORE_FILE = PathUtil.getRuntimePath() + File.separator + "LegoRuntime" + File.separator + "certs" + File.separator + "bcm.keystore";
    private static final Log logger = LogFactory.getInstance(BcmX509TrustManager.class);
    private static final ConcurrentSkipListSet<String> ALARMS = new ConcurrentSkipListSet();
    private X509TrustManager trustManager = null;
    private String ipAddress;
    private IBcmX509TrustHandler handler = null;
    private Set<String> revokedCertSnSet;

    public BcmX509TrustManager(String ipAddress) {
        this(SecurityCertificateManager.getDefaultKeyStore(KEYSTORE_FILE), ipAddress);
    }

    public BcmX509TrustManager(String ipAddress, IBcmX509TrustHandler handler) {
        this(ipAddress);
        this.handler = handler;
    }

    public BcmX509TrustManager(KeyStore keyStore, String ipAddress) {
        this.trustManager = this.getTrustManager(keyStore);
        this.ipAddress = ipAddress;
        this.loadCrl();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (null == this.trustManager) {
            logger.error((Object)("The trust manager is not initialized.ipAddress=" + this.ipAddress));
            return;
        }
        if (!LegoConfig.getInstance().isCertAlarmSwitch()) {
            return;
        }
        this.checkRevoked(chain);
        boolean validity = this.checkValidity(chain);
        if (!validity) {
            return;
        }
        boolean trust = this.checkTrusted(chain, authType);
        if (trust) {
            if (this.handler != null) {
                this.handler.handle(0L);
            }
            CertificateServerCallbackManager.getInstance().success(this.ipAddress);
        }
    }

    private void checkRevoked(X509Certificate[] chain) {
        try {
            if (null == this.revokedCertSnSet || this.revokedCertSnSet.isEmpty()) {
                HashSet<String> normalCertSet = new HashSet<String>();
                normalCertSet.add(this.ipAddress);
                CertificateServerCallbackManager.getNormalCert().addAll(normalCertSet);
                return;
            }
            HashMap<String, Set<String>> revokedCertsMap = new HashMap<String, Set<String>>();
            HashSet<String> normalCertSet = new HashSet<String>();
            for (int i = 0; i < chain.length; ++i) {
                X509Certificate cert = chain[i];
                String serialNumber = cert.getSerialNumber().toString(16).toUpperCase(Locale.ENGLISH);
                Principal principal = cert.getSubjectDN();
                if (this.revokedCertSnSet.contains(serialNumber)) {
                    this.addToSet(revokedCertsMap, this.ipAddress, String.valueOf(principal));
                    logger.warn((Object)"found revokect cert: ip:%s, sn:%s, principal:%s", new Object[]{this.ipAddress, serialNumber, String.valueOf(principal)});
                    continue;
                }
                normalCertSet.add(this.ipAddress);
            }
            CertificateServerCallbackManager.getRevokedCertMap().putAll(revokedCertsMap);
            CertificateServerCallbackManager.getNormalCert().addAll(normalCertSet);
        }
        catch (Exception e) {
            logger.error((Object)"checkRevoked error!", (Throwable)e);
        }
    }

    private void addToSet(Map<String, Set<String>> map, String key, String value) {
        Set<String> set = map.get(key);
        if (null == set) {
            set = new HashSet<String>();
            map.put(key, set);
        }
        set.add(value);
    }

    private void loadCrl() {
        try {
            List lineList;
            File crlFile = new File(PathUtil.getRuntimePath() + File.separator + "LegoRuntime" + File.separator + "certs" + File.separator + "bcm.crl");
            if (crlFile.exists() && crlFile.isFile() && null != (lineList = FileUtil.readLines((File)crlFile)) && !lineList.isEmpty()) {
                this.revokedCertSnSet = new HashSet<String>(lineList);
            }
        }
        catch (Exception e) {
            logger.error((Object)"loadCrl error!", (Throwable)e);
        }
    }

    private boolean checkValidity(X509Certificate[] chain) {
        try {
            for (int i = 0; i < chain.length; ++i) {
                chain[i].checkValidity();
            }
            this.cleanCertAlarmRecord("cert-invalidity");
            return true;
        }
        catch (CertificateException e) {
            this.failForCertInvalidity(e);
        }
        catch (Exception e) {
            this.failForCertInvalidity(e);
        }
        return false;
    }

    private void cleanCertAlarmRecord(String s) {
        if (ALARMS.remove(this.ipAddress + ":" + s)) {
            logger.info((Object)"remove %s record for %s success.", new Object[]{s, this.ipAddress});
        }
    }

    private void failForCertInvalidity(Exception e) {
        if (ALARMS.add(this.ipAddress + ":cert-invalidity")) {
            logger.error((Object)"Check server certificate failed. cert is not invalidity. ip=%s, msg: %s", new Object[]{this.ipAddress, ExceptionUtil.getErrorMessage((Throwable)e)});
            this.cleanCertAlarmRecord("cert-not-trust");
        }
        if (this.handler == null) {
            CertificateServerCallbackManager.getInstance().failForCertInvalidity(this.ipAddress);
        } else {
            this.handler.handle(1073947460L);
        }
    }

    private boolean checkTrusted(X509Certificate[] chain, String authType) {
        try {
            this.trustManager.checkServerTrusted(chain, authType);
            this.cleanCertAlarmRecord("cert-not-trust");
            return true;
        }
        catch (CertificateException e) {
            this.failForCertNoTrust(e);
        }
        catch (Exception e) {
            this.failForCertNoTrust(e);
        }
        return false;
    }

    private void failForCertNoTrust(Exception e) {
        if (ALARMS.add(this.ipAddress + ":cert-not-trust")) {
            logger.error((Object)"Check server certificate failed, cert is not trusted, ip=%s, msg: %s", new Object[]{this.ipAddress, ExceptionUtil.getErrorMessage((Throwable)e)});
            this.cleanCertAlarmRecord("cert-invalidity");
        }
        if (this.handler == null) {
            CertificateServerCallbackManager.getInstance().failForCertNoTrust(this.ipAddress);
        } else {
            this.handler.handle(1073947461L);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }

    private X509TrustManager getTrustManager(KeyStore keyStore) {
        if (null == keyStore) {
            logger.warn((Object)"The keyStore is null.");
            throw new LegoCheckedException(207L);
        }
        X509TrustManager defaultTrustManager = null;
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
        }
        catch (Exception e) {
            logger.error((Object)("Initialized TrustManager failed by the certificate." + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException(207L, (Throwable)e);
        }
        return defaultTrustManager;
    }
}

