/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.comm.security;

import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.service.ICommonService;
import com.huawei.lego.cbb.resource.sdk.service.IResourceService;
import com.huawei.lego.comm.security.CertAuthFail;
import com.huawei.lego.comm.security.ICertificateServerCallback;
import com.huawei.lego.core.sdk.common.ServiceProvider;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.AddressUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import io.netty.util.internal.ConcurrentSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class CertificateServerCallbackManager {
    private static final int LIST_SIZE = 10240;
    private static final int START_TIME = 60000;
    private static final int INTERVAL_TIME = 60000;
    private static Log logger = LogFactory.getInstance(CertificateServerCallbackManager.class);
    private static CertificateServerCallbackManager instance;
    private static Map<String, CertAuthFail> certFailMap;
    private static Set<ICertificateServerCallback> callbackList;
    private static Map<String, Set<String>> revokedCertMap;
    private static Set<String> normalCert;

    public static synchronized CertificateServerCallbackManager getInstance() {
        if (null == instance) {
            instance = new CertificateServerCallbackManager();
            ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
            scheduler.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        CertificateServerCallbackManager.processCert();
                    }
                    catch (Exception e) {
                        logger.error((Object)("exception occured when processCert(), " + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
                    }
                    try {
                        CertificateServerCallbackManager.processRevokedCert();
                    }
                    catch (Exception e) {
                        logger.error((Object)"exception occured when processRevokedCert(), ", (Throwable)e);
                    }
                }
            }, 60000L, 60000L, TimeUnit.MILLISECONDS);
        }
        return instance;
    }

    public void onBind(ICertificateServerCallback callback, Map<?, ?> properties) {
        callbackList.add(callback);
    }

    public void onUnbind(ICertificateServerCallback callback, Map<?, ?> properties) {
        callbackList.remove(callback);
    }

    public void success(String ipAddress) {
        logger.debug((Object)("verify certificate success. Ip:" + ipAddress));
        if (VerifyUtil.isEmpty(callbackList)) {
            logger.info((Object)"callbackList is empty.", 1L);
            return;
        }
        CertificateServerCallbackManager.removeFromList(ipAddress);
        String alarmParam = CertificateServerCallbackManager.getAlarmParam(ipAddress);
        if (VerifyUtil.isEmpty((String)alarmParam)) {
            return;
        }
        for (ICertificateServerCallback callback : callbackList) {
            try {
                callback.success(ipAddress, alarmParam);
            }
            catch (Exception e) {
                logger.error((Object)("verify cert success callback exception." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
        }
    }

    private static String getAlarmParam(String ipAddress) {
        IResourceService resourceService = ServiceProvider.getResourceService();
        if (null == resourceService) {
            logger.info((Object)"get IResourceService null.", 1L);
            return null;
        }
        ManagedObject managedObject = resourceService.getMoByIp(ipAddress);
        if (null != managedObject) {
            return managedObject.getUuid();
        }
        String moId = CertificateServerCallbackManager.getMoIdForRemoteServer(ipAddress);
        if (!VerifyUtil.isEmpty((String)moId)) {
            return moId;
        }
        String remoteSyslogServerId = CertificateServerCallbackManager.getIdForRemoteSyslogServer(ipAddress);
        if (!VerifyUtil.isEmpty((String)remoteSyslogServerId)) {
            return remoteSyslogServerId;
        }
        String ssoServerId = CertificateServerCallbackManager.getSSOAlarmParam(ipAddress);
        if (!VerifyUtil.isEmpty((String)ssoServerId)) {
            return ssoServerId;
        }
        logger.debug((Object)("device is not exist in DB.ipAddress=" + ipAddress), 1L);
        return null;
    }

    private static String getSSOAlarmParam(String ipAddress) {
        if (ipAddress == null) {
            return null;
        }
        if (!ipAddress.startsWith("SSO-Server:")) {
            return null;
        }
        String ipInfo = AddressUtil.getIpInStr((String)ipAddress);
        if (ipInfo == null) {
            return null;
        }
        return "syslog" + ipInfo.replace(".", "");
    }

    public void failForCertInvalidity(String ipAddress) {
        CertAuthFail certAuthFail = new CertAuthFail();
        certAuthFail.setIpAddress(ipAddress);
        certAuthFail.setCertAuthFailType(1);
        certAuthFail.setHappenTime(System.currentTimeMillis());
        this.addToList(certAuthFail);
    }

    public void failForCertNoTrust(String ipAddress) {
        CertAuthFail certAuthFail = new CertAuthFail();
        certAuthFail.setIpAddress(ipAddress);
        certAuthFail.setCertAuthFailType(2);
        certAuthFail.setHappenTime(System.currentTimeMillis());
        this.addToList(certAuthFail);
    }

    private void addToList(CertAuthFail certAuthFail) {
        if (certFailMap.size() >= 10240) {
            logger.error((Object)"certFailMap exceed max.", 1L);
            return;
        }
        if (!certFailMap.containsKey(certAuthFail.getIpAddress())) {
            certFailMap.put(certAuthFail.getIpAddress(), certAuthFail);
        }
    }

    private static void removeFromList(String ipAddress) {
        if (certFailMap.containsKey(ipAddress)) {
            certFailMap.remove(ipAddress);
        }
    }

    public static Map<String, Set<String>> getRevokedCertMap() {
        return revokedCertMap;
    }

    public static Set<String> getNormalCert() {
        return normalCert;
    }

    public static void processCert() {
        try {
            Iterator<Map.Entry<String, CertAuthFail>> iterate = certFailMap.entrySet().iterator();
            while (iterate.hasNext()) {
                Map.Entry<String, CertAuthFail> entry = iterate.next();
                String ip = entry.getKey();
                CertAuthFail certAuthFail = entry.getValue();
                String alarmParam = CertificateServerCallbackManager.getAlarmParam(ip);
                if (!VerifyUtil.isEmpty((String)alarmParam)) {
                    CertificateServerCallbackManager.notifyAllCallback(certAuthFail, alarmParam);
                    CertificateServerCallbackManager.removeFromList(certAuthFail.getIpAddress());
                    iterate = certFailMap.entrySet().iterator();
                    continue;
                }
                if (System.currentTimeMillis() - certAuthFail.getHappenTime() <= 0x6DDD00L) continue;
                CertificateServerCallbackManager.removeFromList(certAuthFail.getIpAddress());
                iterate = certFailMap.entrySet().iterator();
            }
        }
        catch (Exception t) {
            logger.error((Object)("processCert Catch a Exception" + ExceptionUtil.getErrorMessage((Throwable)t)), 200L);
        }
    }

    public static void processRevokedCert() {
        String ipAddress;
        Iterator<Map.Entry<String, Set<String>>> revokedIterator = revokedCertMap.entrySet().iterator();
        while (revokedIterator.hasNext()) {
            Map.Entry<String, Set<String>> entry = revokedIterator.next();
            ipAddress = entry.getKey();
            Set<String> set = entry.getValue();
            normalCert.remove(ipAddress);
            for (ICertificateServerCallback callback : callbackList) {
                try {
                    callback.failForRevokedCert(ipAddress, set);
                    revokedIterator.remove();
                }
                catch (Exception e) {
                    logger.error((Object)"failForRevokedCert notify callback exception.", (Throwable)e);
                }
            }
        }
        Iterator<String> normalIterator = normalCert.iterator();
        while (normalIterator.hasNext()) {
            ipAddress = normalIterator.next();
            for (ICertificateServerCallback callback : callbackList) {
                try {
                    callback.restoreForRevokedCert(ipAddress);
                    normalIterator.remove();
                }
                catch (Exception e) {
                    logger.error((Object)"failForRevokedCert notify callback exception.", (Throwable)e);
                }
            }
        }
    }

    private static void notifyAllCallback(CertAuthFail certAuthFail, String moUuid) {
        CertificateServerCallbackManager.writeCertAlarmLog(certAuthFail);
        if (VerifyUtil.isEmpty(callbackList)) {
            logger.info((Object)"callbackList is empty.", 1L);
            return;
        }
        for (ICertificateServerCallback callback : callbackList) {
            try {
                CertificateServerCallbackManager.notifyCallback(certAuthFail, moUuid, callback);
            }
            catch (Exception e) {
                logger.error((Object)("verify cert notify callback exception." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
        }
    }

    private static void writeCertAlarmLog(CertAuthFail certAuthFail) {
        int type = certAuthFail.getCertAuthFailType();
        if (type == 1) {
            logger.info((Object)("verify certificate fail,Certificate is invalid. Ip:" + certAuthFail.getIpAddress()));
        } else if (type == 2) {
            logger.info((Object)("verify certificate fail,Certificate is not trusted. Ip:" + certAuthFail.getIpAddress()));
        } else {
            logger.error((Object)("CertAuthFailType is invalid:" + type + ",IP:" + certAuthFail.getIpAddress()), 1L);
        }
    }

    private static void notifyCallback(CertAuthFail certAuthFail, String moUuid, ICertificateServerCallback callback) {
        int type = certAuthFail.getCertAuthFailType();
        if (type == 1) {
            callback.failForCertInvalidity(certAuthFail.getIpAddress(), moUuid);
        } else if (type == 2) {
            callback.failForCertNoTrust(certAuthFail.getIpAddress(), moUuid);
        } else {
            logger.error((Object)("CertAuthFailType is invalid:" + type + ",IP:" + certAuthFail.getIpAddress()), 1L);
        }
    }

    private static String getIdForRemoteSyslogServer(String ipAddress) {
        String sql;
        ICommonService commonService = ServiceProvider.getCommonService();
        List list = commonService.findBySql(sql = "select PROTOCALPROPS from ti_lognotifyserver");
        if (!VerifyUtil.isEmpty((Collection)list)) {
            for (Object object : list) {
                if (!String.valueOf(object).contains(ipAddress)) continue;
                return "syslog" + ipAddress.replace(".", "");
            }
        }
        return null;
    }

    private static String getMoIdForRemoteServer(String ipAddress) {
        try {
            ICommonService commonService = ServiceProvider.getCommonService();
            String sql = "select MOID from TI_MANAGEMENTSERVER where IP = '" + ipAddress + "'";
            List list = commonService.findBySql(sql);
            if (!VerifyUtil.isEmpty((Collection)list)) {
                return String.valueOf(list.get(0));
            }
        }
        catch (Exception e) {
            logger.error((Object)("get remote server service failue" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        return null;
    }

    static {
        certFailMap = new HashMap<String, CertAuthFail>();
        callbackList = new HashSet<ICertificateServerCallback>();
        revokedCertMap = new ConcurrentHashMap<String, Set<String>>();
        normalCert = new ConcurrentSet();
    }
}

