/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.comm.security;

import com.huawei.lego.comm.security.ProtocolComparator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;

public class ProtocolManager {
    private static final Log logger = LogFactory.getInstance(ProtocolManager.class);

    public static void resetEnabledProtocolsAndCipherSuites(SSLSocket sslSocket, String[] protocols) {
        if (null == sslSocket) {
            logger.error((Object)"sslSocket is null.");
            return;
        }
        Object[] enabledProtocols = sslSocket.getEnabledProtocols();
        logger.debug((Object)("sslSocket protocol:" + Arrays.toString(enabledProtocols) + ",set protocols:" + Arrays.toString(protocols)));
        if (null != protocols && 0 < protocols.length) {
            sslSocket.setEnabledProtocols(protocols);
            enabledProtocols = protocols;
        }
        sslSocket.setEnabledCipherSuites(ProtocolManager.getCipherSuitesByProtocols(ProtocolManager.sortProtocolsByVersion((String[])enabledProtocols)));
    }

    private static String[] getCipherSuitesByProtocols(String[] protocolsParam) {
        HashSet<String> cipherSuites = new HashSet<String>();
        for (String protocol : protocolsParam) {
            Set<String> suites = ProtocolManager.getCipherSuitesByProtocol(protocol);
            cipherSuites.addAll(suites);
        }
        return cipherSuites.toArray(new String[0]);
    }

    private static Set<String> getCipherSuitesByProtocol(String protocol) {
        HashSet<String> cipherSuites = new HashSet<String>();
        try {
            SSLContext sslcontext = SSLContext.getInstance(protocol);
            sslcontext.init(null, null, null);
            SSLParameters sslParam = sslcontext.getDefaultSSLParameters();
            if (null == sslParam) {
                logger.error((Object)"sslParam is null.");
                return cipherSuites;
            }
            String[] defaultCipherSuites = sslParam.getCipherSuites();
            if (null == defaultCipherSuites) {
                logger.error((Object)"defaultCipherSuites is null.");
                return cipherSuites;
            }
            for (String cipherSuite : defaultCipherSuites) {
                if (cipherSuites.contains(cipherSuite)) continue;
                cipherSuites.add(cipherSuite);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Getting cipher suites failed. Protocol:" + protocol + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        return cipherSuites;
    }

    private static String[] sortProtocolsByVersion(String[] protocolsParam) {
        List<String> protocolList = Arrays.asList(protocolsParam);
        Collections.sort(protocolList, new ProtocolComparator());
        return protocolList.toArray(new String[0]);
    }
}

