/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.comm.security;

import com.huawei.lego.core.base.util.KeyStoreLoader;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class SecurityCertificateManager {
    private static final Map<String, KeyStoreLoader> LOADERS = new ConcurrentHashMap<String, KeyStoreLoader>();
    private static final String KEY_STORE = "keyStore";

    private SecurityCertificateManager() {
    }

    public static KeyStore getDefaultKeyStore(String keyStoreFile) {
        return KeyStoreLoader.getKeyStore(keyStoreFile, () -> new KeyStoreLoader(KeyStore.getDefaultType(), Paths.get(keyStoreFile, new String[0]), SecurityCertificateManager::getKeyStorePassword));
    }

    public static String getKeyStorePassword() {
        return WccEncryptor.decrypt((String)LegoConfig.getInstance().getKeyValue(KEY_STORE));
    }
}

