/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.comm.security;

import com.huawei.lego.comm.security.BcmSSLSocketFactory;
import com.huawei.lego.comm.security.BcmX509TrustManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.security.SecureRandom;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class SmtpSSLSocketFactory
extends BcmSSLSocketFactory {
    private static final Log logger = LogFactory.getInstance(SmtpSSLSocketFactory.class);

    public SmtpSSLSocketFactory() {
        super(System.getProperties().getProperty("smtpIpAddress"), "TLSv1.2");
    }

    @Override
    public SSLSocketFactory createSSLSocketFactory() {
        SSLSocketFactory sslSocketFactory;
        Properties props = System.getProperties();
        try {
            SSLContext context = null;
            context = "SSL".equals(props.getProperty("smtpSSLContext")) ? SSLContext.getInstance("SSL") : SSLContext.getInstance("TLS");
            context.init(null, new TrustManager[]{new BcmX509TrustManager(props.getProperty("smtpIpAddress"))}, new SecureRandom());
            sslSocketFactory = context.getSocketFactory();
        }
        catch (Exception e) {
            logger.error((Object)("Creating SSLSocketFactory failed,ipAddress=" + props.getProperty("smtpIpAddress") + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException(207L, "Initializing BcmSSLSocketFactory failed.", (Throwable)e);
        }
        return sslSocketFactory;
    }
}

