/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.comm.security;

import com.huawei.lego.comm.security.BcmX509TrustManager;
import com.huawei.lego.comm.security.ITrustManagerService;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.io.Serializable;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.collections4.keyvalue.DefaultKeyValue;

@Service(Name="com.huawei.lego.comm.security.ITrustManagerService", Desc="", Interface=ITrustManagerService.class)
public class TrustManagerService
extends BaseService
implements ITrustManagerService,
Serializable {
    private static final long serialVersionUID = 2164090210462378266L;
    private static final Log logger = LogFactory.getInstance(TrustManagerService.class);
    private Map<Long, DefaultKeyValue<Long, X509TrustManager>> managers;
    private AtomicLong idGenerator = new AtomicLong(0L);
    private Object lock = new Object();

    public TrustManagerService() {
        this.managers = new LinkedHashMap<Long, DefaultKeyValue<Long, X509TrustManager>>();
    }

    public long createTrustManager(String ip) {
        this.cleanExpiredTrustManager();
        BcmX509TrustManager manager = new BcmX509TrustManager(ip);
        long time = System.currentTimeMillis();
        DefaultKeyValue item = new DefaultKeyValue((Object)time, (Object)manager);
        return this.addTrustManager((DefaultKeyValue<Long, X509TrustManager>)item);
    }

    public X509Certificate[] getAcceptedIssuers(long id) {
        X509TrustManager manager = this.getTrustManager(id);
        if (manager == null) {
            return new X509Certificate[0];
        }
        X509Certificate[] acceptedIssuers = manager.getAcceptedIssuers();
        this.delTrustManager(id);
        return acceptedIssuers;
    }

    public void checkServerTrusted(long id, X509Certificate[] chain, String authType) throws CertificateException {
        X509TrustManager manager = this.getTrustManager(id);
        if (manager == null) {
            throw new CertificateException("no trust manager for id " + id);
        }
        manager.checkServerTrusted(chain, authType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private X509TrustManager getTrustManager(long id) {
        DefaultKeyValue<Long, X509TrustManager> item;
        Object object = this.lock;
        synchronized (object) {
            item = this.managers.get(id);
        }
        if (item == null) {
            logger.debug((Object)new StringBuilder("not found trust manager #").append(id));
            return null;
        }
        return (X509TrustManager)item.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanExpiredTrustManager() {
        long e = System.currentTimeMillis();
        long t = TimeUnit.MINUTES.toMillis(1L);
        Object object = this.lock;
        synchronized (object) {
            Iterator<Map.Entry<Long, DefaultKeyValue<Long, X509TrustManager>>> it = this.managers.entrySet().iterator();
            while (it.hasNext()) {
                boolean timeout;
                Map.Entry<Long, DefaultKeyValue<Long, X509TrustManager>> entry = it.next();
                long s = (Long)entry.getValue().getKey();
                boolean bl = timeout = e - s > t;
                if (!timeout) break;
                it.remove();
                logger.debug((Object)new StringBuilder("trust manager #").append(entry.getKey()).append(" is timeout"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addTrustManager(DefaultKeyValue<Long, X509TrustManager> item) {
        long id = this.idGenerator.incrementAndGet();
        Object object = this.lock;
        synchronized (object) {
            this.managers.put(id, item);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delTrustManager(long id) {
        Object object = this.lock;
        synchronized (object) {
            this.managers.remove(id);
        }
    }
}

