/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base;

import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.core.base.persistance.dao.ICommonDao;
import com.huawei.lego.core.base.service.IMoGenerator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.function.Function;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class LegoMoGenerator
implements IMoGenerator {
    private ICommonDao dao;
    private Log log = LogFactory.getInstance(LegoMoGenerator.class);

    public void setDao(ICommonDao dao) {
        this.dao = dao;
    }

    @Override
    public ManagedObject generateMO() {
        ManagedObject reValue = null;
        try {
            String hql = "from ManagedObject mo where mo.name ='Management System'";
            List<?> result = this.dao.findByHql(hql);
            String ip = this.getInstallServerIp();
            if (result == null || result.isEmpty()) {
                TopoObject mo = new TopoObject();
                mo.setUuid(UUIDGenerator.getUUID());
                mo.setName("Management System");
                mo.setDescription("Management System");
                mo.setMainType("lego.dic.legosystem.maintype");
                mo.setSubType("lego.dic.legosystem.subtype");
                mo.setIpAddress(this.getInstallServerIp());
                mo.setIsGroup(Boolean.valueOf(false));
                mo.setManaged(Boolean.valueOf(true));
                this.dao.save(mo);
                reValue = mo;
                this.log.info((Object)"+++++++++++++++Management System Managed Object has been generated!!", 1L);
            } else {
                reValue = (ManagedObject)result.get(0);
                this.log.info((Object)("system ip:" + ip), 1L);
                TopoObject topoObject = (TopoObject)reValue;
                if (null != ip && !"".equals(ip) && !ip.equals(topoObject.getIpAddress())) {
                    topoObject.setIpAddress(ip);
                    this.dao.saveOrUpdate(reValue);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)("generate Lego self MO failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        return reValue;
    }

    public String getIpForTrap() {
        return this.resolve(document -> {
            String ip = "";
            try {
                ip = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                return "";
            }
            this.log.info((Object)("The default ip is:" + ip));
            if (null == document) {
                this.log.error((Object)"The document is null.");
                return ip;
            }
            Element root = document.getRootElement();
            String floatIp = this.getFloatIp(root);
            if (!VerifyUtil.isEmpty((String)floatIp)) {
                return floatIp;
            }
            this.log.error((Object)"get lego install ip from RDInstalled.xml failed!");
            return ip;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String resolve(Function<Document, String> handler) {
        String realPath = this.getRealPath();
        SAXReader reader = new SAXReader();
        try (FileInputStream inputStream = new FileInputStream(realPath);){
            CommonUtil.setSecurityFeatures((SAXReader)reader);
            Document document = reader.read((InputStream)inputStream);
            if (document == null) {
                String string2 = "";
                return string2;
            }
            String string = handler.apply(document);
            return string;
        }
        catch (Exception e) {
            this.log.error((Object)("resolve install information failed, error is: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            return "";
        }
    }

    private String getFloatIp(Element root) {
        Element floatNode = root.element("floatip");
        if (null != floatNode && !VerifyUtil.isEmpty((String)floatNode.getText())) {
            this.log.info((Object)"get floatIp successful!");
            return floatNode.getText();
        }
        Element ipNode = root.element("httpsip");
        if (null != ipNode && !VerifyUtil.isEmpty((String)ipNode.getText())) {
            this.log.info((Object)"get lego install ip successful");
            return ipNode.getText();
        }
        return "";
    }

    public String getInstallServerIp() {
        return this.resolve(document -> {
            String ip = "";
            Node floatNode = document.selectSingleNode("//install/floatip");
            if (null != floatNode && null != (ip = floatNode.getText()) && !ip.trim().isEmpty()) {
                this.log.info((Object)("The lego float ip is:" + ip), 1L);
                return ip;
            }
            Node httpNode = document.selectSingleNode("//install/httpsip");
            if (null != httpNode) {
                ip = httpNode.getText();
                this.log.info((Object)("The lego install ip is:" + ip), 1L);
                return ip;
            }
            return ip;
        });
    }

    public String getInstallServerPort() {
        return this.resolve(document -> {
            Element root = document.getRootElement();
            Element portNode = root.element("httpsport");
            if (null != portNode && !VerifyUtil.isEmpty((String)portNode.getText())) {
                this.log.info((Object)("get port successful! port is : " + portNode.getText()));
                return portNode.getText();
            }
            return "";
        });
    }

    private String getRealPath() {
        String current;
        String legoinstallPath = "/monitor/RDInstalled.xml";
        try {
            current = new File(System.getProperty("user.dir")).getCanonicalPath();
        }
        catch (IOException e) {
            this.log.error((Object)("get current path failed: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            return "";
        }
        String legoruntime = "/LegoRuntime";
        int i = current.length() - legoruntime.length();
        String newCurrentPath = i >= 0 ? current.substring(0, i) : "";
        return newCurrentPath + legoinstallPath;
    }
}

