/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.bound;

import com.huawei.lego.core.base.LegoSystem;
import com.huawei.lego.core.base.bound.BoundUtil;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.CollectionUtils;

public class BoundAnnotationBeanPostProcessor
implements BeanPostProcessor,
ApplicationContextAware {
    private static Log log = LogFactory.getInstance(BoundAnnotationBeanPostProcessor.class);
    private static LegoSystem legoSystem = null;
    private static final int TWO = 2;
    private ApplicationContext context;

    public static LegoSystem getLegoSystem() {
        return legoSystem;
    }

    public static void setLegoSystem(LegoSystem paramObject) {
        legoSystem = paramObject;
    }

    public Object postProcessBeforeInitialization(Object paramObject, String paramString) throws BeansException {
        return paramObject;
    }

    public Object postProcessAfterInitialization(Object paramObject, String paramString) throws BeansException {
        log.debug((Object)("postProcessAfterInitialization:" + paramObject.getClass().getName() + "   " + paramString));
        if (paramObject instanceof LegoSystem) {
            BoundAnnotationBeanPostProcessor.setLegoSystem((LegoSystem)paramObject);
        }
        this.initListContainer(paramObject);
        return paramObject;
    }

    public void setApplicationContext(ApplicationContext paramApplicationContext) throws BeansException {
        this.context = paramApplicationContext;
    }

    private void initListContainer(Object invokePramObject) {
        Map<String, ServiceBoundInfo> interfaceMap = BoundUtil.getAnnotation(invokePramObject.getClass());
        if (!CollectionUtils.isEmpty(interfaceMap)) {
            for (Map.Entry<String, ServiceBoundInfo> entry : interfaceMap.entrySet()) {
                ServiceBoundInfo annotation = entry.getValue();
                String[] methodArray = annotation.methodName().split(",");
                String[] targetBeanArray = annotation.targetBeanName().split(",");
                if (methodArray == null || targetBeanArray == null || methodArray.length != targetBeanArray.length) {
                    log.error((Object)("initListContainer Osgi list Method:" + annotation.methodName() + "  targetBean:" + annotation.targetBeanName()));
                    return;
                }
                int pos = 0;
                for (String methodName : methodArray) {
                    Object object = this.context.getBean(targetBeanArray[pos]);
                    ++pos;
                    this.invokeBoundInfoAllMethods(invokePramObject, annotation, methodName, object);
                }
            }
        }
    }

    private void invokeBoundInfoAllMethods(Object invokePramObject, ServiceBoundInfo annotation, String methodName, Object object) {
        Method[] methods = object.getClass().getMethods();
        if (methods != null && methods.length > 0) {
            for (Method method : methods) {
                this.invokeBoundInfo(invokePramObject, annotation, methodName, object, method);
            }
        }
    }

    private void invokeBoundInfo(Object invokePramObject, ServiceBoundInfo annotation, String methodName, Object object, Method method) {
        if (method.getName().equals(methodName)) {
            String properStr = annotation.properties();
            Map<String, Object> properties = null;
            if (properStr != null && properStr.length() > 0) {
                properties = this.buildProperties(properStr);
            }
            try {
                method.invoke(object, invokePramObject, properties);
            }
            catch (ReflectiveOperationException e) {
                log.error((Object)("invokeBoundInfo error:" + methodName + "  " + object + "  " + invokePramObject));
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("invokeBoundInfo error:" + methodName + "  " + object + "  " + invokePramObject));
            }
        }
    }

    private Map<String, Object> buildProperties(String properStr) {
        String[] properArray;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String pro : properArray = properStr.split(";")) {
            String[] keyValue = pro.split(":");
            if (keyValue.length != 2) continue;
            if (keyValue[1].contains("##")) {
                properties.put(keyValue[0], Arrays.asList(keyValue[1].split("##")));
                continue;
            }
            properties.put(keyValue[0], keyValue[1]);
        }
        return properties;
    }
}

