/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.confmgr;

import com.huawei.lego.core.base.service.IProcessEntry;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;
import org.dom4j.Node;

public class EntryProcessor {
    private Log log = LogFactory.getInstance(EntryProcessor.class);
    private Map<String, List<IProcessEntry>> entries = new HashMap<String, List<IProcessEntry>>();
    private Map<String, Map> contexts = new HashMap<String, Map>();
    private Map<String, List<Element>> elements = new HashMap<String, List<Element>>();

    public void setElement(String type, Element element) {
        if (element != null) {
            List<Element> tmpList = this.elements.get(type);
            if (tmpList == null) {
                tmpList = new ArrayList<Element>();
            }
            tmpList.add(element);
            this.elements.put(type, tmpList);
        }
    }

    public void setContext(String type, Map context) {
        if (this.contexts.containsKey(type)) {
            this.contexts.get(type).putAll(context);
        } else {
            this.contexts.put(type, context);
        }
        this.log.info((Object)("set context,type:" + type));
    }

    public Map getContext(String type) {
        return this.contexts.get(type);
    }

    public void addEntry(String type, IProcessEntry entry) {
        if (this.entries != null) {
            List<IProcessEntry> list = this.entries.get(type);
            if (list == null) {
                list = new ArrayList<IProcessEntry>();
            }
            list.add(entry);
            this.entries.put(type, list);
        }
    }

    public void process() {
        Set<Map.Entry<String, List<IProcessEntry>>> entrySet = this.entries.entrySet();
        for (Map.Entry<String, List<IProcessEntry>> entry : entrySet) {
            String type = entry.getKey();
            Map context = this.contexts.get(type);
            List<Element> roots = this.elements.get(type);
            for (Element element : roots) {
                List<IProcessEntry> processEntryList = entry.getValue();
                for (IProcessEntry processEntry : processEntryList) {
                    processEntry.enterProcessing((Node)element, context);
                }
            }
        }
    }
}

