/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.confmgr;

import com.huawei.lego.core.base.confmgr.EntryProcessor;
import com.huawei.lego.core.base.confmgr.parser.XmlConfigParser;
import com.huawei.lego.core.base.service.DefaultProcessEntry;
import com.huawei.lego.core.base.service.IParser;
import com.huawei.lego.core.base.service.IProcessEntry;
import com.huawei.lego.core.sdk.file.util.AdapterUtils;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ParserCreator {
    private Log log = LogFactory.getInstance(ParserCreator.class);
    private Map<String, IParser> parsers = new HashMap<String, IParser>();
    private Map<String, IProcessEntry> entries = new HashMap<String, IProcessEntry>();
    private Map<String, String> entryConfig;

    public void setEntryConfig(Map<String, String> entryConfig) {
        this.entryConfig = entryConfig;
    }

    public void initProcessEntry(String type) {
        try {
            if (!this.entryConfig.containsKey(type)) {
                return;
            }
            String path = this.entryConfig.get(type);
            Properties p = new Properties();
            URL url = ParserCreator.class.getResource(path);
            if (url == null) {
                this.log.error((Object)("Get resource: from bundle:" + path + " error!!"), 1L);
                return;
            }
            p.load(url.openStream());
            Object[] entriesParam = p.values().toArray();
            this.initProcessEntry(type, p, entriesParam);
        }
        catch (IOException e) {
            this.log.error((Object)e, 1L);
        }
        catch (InstantiationException e) {
            this.log.error((Object)e, 1L);
        }
        catch (IllegalAccessException e) {
            this.log.error((Object)e, 1L);
        }
        catch (ClassNotFoundException e) {
            this.log.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
    }

    private void initProcessEntry(String type, Properties p, Object[] entriesParam) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (entriesParam.length <= 0) {
            this.log.info((Object)("entriesParam is empty,type:" + type));
        }
        IProcessEntry current = null;
        for (int i = 1; i <= entriesParam.length; ++i) {
            String clazz = p.getProperty(String.valueOf(i));
            IProcessEntry temp = (IProcessEntry)Class.forName(clazz).newInstance();
            if (current != null) {
                ((DefaultProcessEntry)current).setNextParser(temp);
                current = temp;
                continue;
            }
            current = temp;
            this.entries.put(type, current);
            this.log.info((Object)("put IProcessEntry into entries,type:" + type));
        }
    }

    public IParser createParser(String type, EntryProcessor processor) {
        IParser parser = null;
        this.initProcessEntry(type);
        if (!this.parsers.containsKey(type)) {
            if (this.entries != null && this.entries.containsKey(type)) {
                IProcessEntry entry = this.entries.get(type);
                if (type.equals("com.huawei.lego.core.domain")) {
                    parser = new XmlConfigParser(AdapterUtils.getAllClassPathEntries((String)"domain/*-domain-model.xml"), processor, entry);
                    this.parsers.put(type, parser);
                }
            } else {
                this.log.info((Object)("get IProcessEntry fail,type:" + type));
            }
        } else {
            parser = this.parsers.get(type);
        }
        if (null == parser) {
            this.log.info((Object)("parser is null,type:" + type));
        }
        return parser;
    }
}

