/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.framework.container.support;

import com.huawei.lego.core.base.framework.container.StructurePreProcessor;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.Registry;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.LegoProperties;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;

public class ServiceExportPreProcessor
extends StructurePreProcessor {
    private static Log sLogger = LogFactory.getInstance(ServiceExportPreProcessor.class);

    @Override
    public void doProcess() {
        ArrayList<Registry> registries = new ArrayList<Registry>();
        if (this.getRegistryBeans().isEmpty()) {
            Registry registry = new Registry();
            StringBuffer defaultRegUrlStrBuf = new StringBuffer();
            defaultRegUrlStrBuf.append("rmi://");
            defaultRegUrlStrBuf.append(LegoProperties.getIPAddress() + ":");
            defaultRegUrlStrBuf.append(LegoProperties.getPort() + "/");
            try {
                registry.setRegistryURL(new URI(defaultRegUrlStrBuf.toString()));
            }
            catch (URISyntaxException e) {
                sLogger.error((Object)"", (Throwable)e);
            }
            registries.add(registry);
        } else {
            registries.addAll(this.getRegistryBeans());
        }
        Collection<BaseService> collections = this.getServices();
        for (BaseService service : collections) {
            if (service.getRegistries() == null) {
                service.setRegistries(registries);
            }
            service.bindToApplication();
        }
    }
}

