/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.framework.container.support;

import com.huawei.lego.core.base.bound.BoundAnnotationBeanPostProcessor;
import com.huawei.lego.core.base.framework.container.Launcher;
import com.huawei.lego.core.base.framework.container.Monitor;
import com.huawei.lego.core.base.framework.container.PreLaunchProcessor;
import com.huawei.lego.core.base.framework.container.PrepareCondition;
import com.huawei.lego.core.base.framework.container.StructurePreProcessor;
import com.huawei.lego.core.base.framework.container.support.BundleRefreshedMonitor;
import com.huawei.lego.core.base.framework.container.support.ConditionPreProcessor;
import com.huawei.lego.core.base.framework.container.support.GenerateDefaultMoPreProcessor;
import com.huawei.lego.core.base.framework.container.support.SpringFrameworkHook;
import com.huawei.lego.core.base.framework.container.support.StartupMonitorPreProcessor;
import com.huawei.lego.core.sdk.base.structure.ICallback;
import com.huawei.lego.core.sdk.base.structure.ILifecycle;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.springframework.context.ApplicationContext;

public class SystemLauncher
extends Launcher {
    private static ApplicationContext springContext = null;
    private Log log = LogFactory.getInstance(SystemLauncher.class);
    private boolean beenLaunched = false;
    private PrepareCondition condition;

    public SystemLauncher(SpringFrameworkHook container) {
        super(container);
        this.getMonitors().add(new BundleRefreshedMonitor());
        this.getPreProcessors().add(new StartupMonitorPreProcessor(this.getMonitors()));
        this.getPreProcessors().add(new GenerateDefaultMoPreProcessor());
    }

    public static ApplicationContext getSpringContext() {
        return springContext;
    }

    public static void setSpringContext(ApplicationContext aContext) {
        springContext = aContext;
    }

    public void setCondition(PrepareCondition condition) {
        this.condition = condition;
        this.getPreProcessors().add(new ConditionPreProcessor(super.getMonitors(), this.condition));
    }

    @Override
    public synchronized void launch(ApplicationContext aContext) throws MalformedURLException, URISyntaxException {
        SystemLauncher.setSpringContext(aContext);
        for (PreLaunchProcessor processor : this.getPreProcessors()) {
            if (processor instanceof StructurePreProcessor) {
                ((StructurePreProcessor)processor).initStructureContext(aContext);
            }
            processor.doProcess();
        }
        if (!this.beenLaunched) {
            ArrayList<Object> initCallbacks = new ArrayList<Object>();
            initCallbacks.add(new Launcher.ListenerInitializeCallback());
            initCallbacks.add(new SystemMonitorCallback());
            BoundAnnotationBeanPostProcessor.getLegoSystem().initialize(initCallbacks);
            this.log.info((Object)"finished system initializing....", 1L);
            this.statistic(true);
            ArrayList<Object> startCallbacks = new ArrayList<Object>();
            startCallbacks.add(new StartCallback());
            startCallbacks.add(new SystemMonitorCallback());
            BoundAnnotationBeanPostProcessor.getLegoSystem().start(startCallbacks);
            this.log.info((Object)"finished system starting....", 1L);
            this.statistic(true);
            this.beenLaunched = true;
        }
    }

    private void statistic(boolean reset) {
        for (Monitor monitor : super.getMonitors()) {
            monitor.getCount();
            if (!reset) continue;
            monitor.reset();
        }
    }

    static class StartCallback
    implements ICallback {
        StartCallback() {
        }

        public void invoke(ILifecycle life) {
        }
    }

    class SystemMonitorCallback
    implements ICallback {
        SystemMonitorCallback() {
        }

        public void invoke(ILifecycle life) {
            for (Monitor monitor : SystemLauncher.this.getMonitors()) {
                monitor.count(life);
            }
        }
    }
}

