/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.framework.container.support;

import com.huawei.lego.core.base.framework.container.Monitor;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.structure.AbsApplication;
import com.huawei.lego.core.sdk.base.structure.ILifecycle;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SystemStartupMonitor
implements Monitor {
    private int srvFailedCount = 0;
    private int appFailedCount = 0;
    private Map<String, Boolean> allApps;
    private Map<String, Boolean> allServices;
    private Log log = LogFactory.getInstance(SystemStartupMonitor.class);

    public SystemStartupMonitor() {
        this.allApps = new HashMap<String, Boolean>();
        this.allServices = new HashMap<String, Boolean>();
    }

    @Override
    public boolean count(Object object) {
        if (object instanceof ILifecycle) {
            ILifecycle life = (ILifecycle)object;
            String key = life.getClass().getSimpleName();
            if (this.allApps.containsKey(key)) {
                this.allApps.put(key, true);
            }
            if (this.allServices.containsKey(key)) {
                this.allServices.put(key, true);
            }
        }
        return true;
    }

    @Override
    public int getCount() {
        StringBuffer msg = new StringBuffer();
        msg.append("Applications :[");
        Set<Map.Entry<String, Boolean>> entries = this.allApps.entrySet();
        for (Map.Entry<String, Boolean> entry : entries) {
            if (entry.getValue().booleanValue()) continue;
            msg = this.appFailedCount == 0 ? msg.append(entry.getKey()) : msg.append("," + entry.getKey());
            ++this.appFailedCount;
        }
        msg.append("] total:" + this.appFailedCount + " failed! ");
        this.log.warn((Object)msg.toString(), 1L);
        msg.append("Services :[");
        entries = this.allServices.entrySet();
        for (Map.Entry<String, Boolean> entry : entries) {
            if (entry.getValue().booleanValue()) continue;
            msg = this.srvFailedCount == 0 ? msg.append(entry.getKey()) : msg.append("," + entry.getKey());
            ++this.srvFailedCount;
        }
        msg.append("] total:" + this.srvFailedCount + " failed! ");
        this.log.warn((Object)msg.toString(), 1L);
        return 0;
    }

    @Override
    public void monitor(Object object) {
        if (object instanceof ILifecycle) {
            ILifecycle life = (ILifecycle)object;
            if (life instanceof AbsApplication) {
                this.allApps.put(life.getClass().getSimpleName(), false);
            }
            if (life instanceof BaseService) {
                this.allServices.put(life.getClass().getSimpleName(), false);
            }
        }
    }

    @Override
    public void reset() {
        Set<Map.Entry<String, Boolean>> entries = this.allApps.entrySet();
        for (Map.Entry<String, Boolean> entry : entries) {
            entry.setValue(false);
        }
        entries = this.allServices.entrySet();
        for (Map.Entry<String, Boolean> entry : entries) {
            entry.setValue(false);
        }
        this.srvFailedCount = 0;
        this.appFailedCount = 0;
    }
}

