/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.framework.rpc.rmi;

import com.huawei.lego.core.base.framework.rpc.Protocol;
import com.huawei.lego.core.base.framework.rpc.metadata.AnnotationMetadata;
import com.huawei.lego.core.base.framework.rpc.rmi.SecurityInterceptor;
import com.huawei.lego.core.base.framework.rpc.util.AnnotationUtil;
import com.huawei.lego.core.sdk.base.StaticRmiServerSocketFactory;
import com.huawei.lego.core.sdk.base.StaticRmiSocketFactory;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.base.structure.IService;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoProperties;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.lang.reflect.Field;
import java.net.URI;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.remoting.rmi.RmiServiceExporter;

public class RmiProtocol
implements Protocol {
    private static final String DEFAULT_RMI_SERVICE_PORT_10092 = "10092";
    private static final String KEY_SPRING_EXP_RMI1 = "spring.expRmi1";
    private static final String LOCAL_HOST_IP = "127.0.0.1";
    private static StaticRmiServerSocketFactory srsf = new StaticRmiServerSocketFactory();
    private static SecurityInterceptor rmiInterceptor = new SecurityInterceptor();
    private static Map<String, RmiServiceExporter> rmiExperHandlerMap = new ConcurrentHashMap<String, RmiServiceExporter>(5);
    private static Map<Object, String> rmiExportObjectMap = new ConcurrentHashMap<Object, String>();
    private Log log = LogFactory.getInstance(RmiProtocol.class);
    private Registry registry;
    private Class exportInterface;
    private String exportName;
    private RmiServiceExporter exporter = null;

    public synchronized void setRegistry(Registry registry) {
        this.registry = registry;
    }

    private void buildContext(IService service) {
        AnnotationMetadata metadata = AnnotationUtil.getAnnotationType(service);
        if (metadata != null) {
            this.exportInterface = metadata.getExportInterface();
            Service sAnno = metadata.getsAnno();
            if (sAnno != null) {
                String appName = sAnno.Name();
                if (service.getContainer() != null) {
                    appName = service.getContainer().getInfor().getAppName();
                }
                this.exportName = appName.concat("/").concat(sAnno.Name());
            }
        }
    }

    @Override
    public synchronized void apply(IService service, URI url) {
        this.initExporter();
        try {
            this.buildContext(service);
            this.exporter.setInterceptors(new Object[]{rmiInterceptor});
            this.exporter.setServiceInterface(this.exportInterface);
            this.exporter.setServiceName(this.exportName);
            this.exporter.setService((Object)service);
            this.exporter.setRegistry(this.registry);
            this.exporter.setRegistryHost(url.getHost());
            this.exporter.setRegistryPort(url.getPort());
            this.exporter.setServicePort(NumberUtil.convertToInteger((Object)LegoProperties.getProperty((String)KEY_SPRING_EXP_RMI1, (String)DEFAULT_RMI_SERVICE_PORT_10092)).intValue());
            this.exporter.afterPropertiesSet();
            this.cacheExportObj();
            this.log.info((Object)("export RMI Service " + this.exportInterface.getName() + " to [" + url.toString() + "] registry OK!"), 1L);
        }
        catch (Exception e) {
            this.log.error((Object)("export RMI Service " + this.exportInterface.getName() + " to [" + url.toString() + "] registry failed!"), 1L);
            this.log.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
    }

    private void cacheExportObj() {
        try {
            Class<?> cls = this.exporter.getClass();
            Field field = cls.getDeclaredField("exportedObject");
            field.setAccessible(true);
            Object exportObj = field.get(this.exporter);
            rmiExportObjectMap.put(exportObj, exportObj.getClass().getName());
            this.log.info((Object)("export RMI cache service:" + this.exportInterface.getName() + " is OK."), 1L);
        }
        catch (Exception ex) {
            this.log.error((Object)("Cache export service error." + ExceptionUtil.getErrorMessage((Throwable)ex)), 1L);
        }
        rmiExperHandlerMap.put(this.exportName, this.exporter);
    }

    private void initExporter() {
        if (this.exporter == null) {
            this.exporter = new RmiServiceExporter();
            StaticRmiSocketFactory cfy = new StaticRmiSocketFactory(LOCAL_HOST_IP, 0);
            this.exporter.setClientSocketFactory((RMIClientSocketFactory)cfy);
            this.exporter.setServerSocketFactory((RMIServerSocketFactory)srsf);
        }
    }

    @Override
    public synchronized void destory(IService service) {
        try {
            this.buildContext(service);
            if (this.registry != null) {
                this.registry.unbind(this.exportName);
                rmiExperHandlerMap.remove(this.exportName);
                this.log.info((Object)("unexport RMI Service " + this.exportInterface.getName() + " OK!"), 1L);
            }
        }
        catch (Exception e) {
            this.log.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
    }

    @Override
    public String getProtocolType() {
        return "rmi";
    }
}

