/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.framework.rpc.support;

import com.huawei.lego.core.base.framework.rpc.MetadataInforCreator;
import com.huawei.lego.core.base.framework.rpc.Publisher;
import com.huawei.lego.core.base.framework.rpc.metadata.MetadataCreatorFactory;
import com.huawei.lego.core.sdk.base.IServiceExporter;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.base.model.ServiceInfo;
import com.huawei.lego.core.sdk.base.structure.ICallback;
import com.huawei.lego.core.sdk.base.structure.ILifecycle;
import com.huawei.lego.core.sdk.base.structure.IService;
import java.util.List;

public class ServicePublisher
extends Publisher {
    private List<IServiceExporter<IService>> serviceExporter;

    public void setExporter(List<IServiceExporter<IService>> exporter) {
        this.serviceExporter = exporter;
    }

    @Override
    public void unpublish(IService service, ICallback callback) {
        for (IServiceExporter<IService> exporter : this.serviceExporter) {
            exporter.unExport(service);
        }
        if (callback != null) {
            callback.invoke((ILifecycle)service);
        }
    }

    @Override
    public void publish(IService service, ICallback callback) {
        MetadataInforCreator creator = MetadataCreatorFactory.getFactory().produceMetadataInforCreator(service);
        ServiceInfo srvInfo = (ServiceInfo)creator.createInfor(service);
        srvInfo.setApp(this.getAppinfo());
        this.getAppinfo().addService(srvInfo);
        Service sAnno = (Service)creator.getAnnotationInfor();
        if (sAnno != null && sAnno.IsRemote()) {
            for (IServiceExporter<IService> exporter : this.serviceExporter) {
                exporter.export(service);
            }
            if (callback != null) {
                callback.invoke((ILifecycle)service);
            }
        }
    }
}

