/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.framework.rpc.util;

import com.huawei.lego.core.base.framework.rpc.metadata.AnnotationMetadata;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.base.structure.IService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.ClassUtils;

public class AnnotationUtil {
    public static AnnotationMetadata getAnnotationType(IService service) {
        AnnotationMetadata metadata = null;
        Service sAnno = null;
        if (service.getClass().isAnnotationPresent(Service.class)) {
            sAnno = service.getClass().getAnnotation(Service.class);
            metadata = new AnnotationMetadata(sAnno, sAnno.Interface());
        } else {
            Class[] clazzes;
            for (Class clazz : clazzes = ClassUtils.getAllInterfaces((Object)service)) {
                if (!clazz.isAnnotationPresent(Service.class)) continue;
                sAnno = clazz.getAnnotation(Service.class);
                metadata = new AnnotationMetadata(sAnno, clazz);
                break;
            }
        }
        return metadata;
    }

    public static List<AnnotationMetadata> getAnnotationTypes(IService service) {
        ArrayList<AnnotationMetadata> metadatas = new ArrayList<AnnotationMetadata>();
        Service sAnno = null;
        if (service.getClass().isAnnotationPresent(Service.class)) {
            sAnno = service.getClass().getAnnotation(Service.class);
            metadatas.add(new AnnotationMetadata(sAnno, sAnno.Interface()));
        } else {
            Class<?>[] clazzes;
            for (Class<?> clazz : clazzes = service.getClass().getInterfaces()) {
                if (!clazz.isAnnotationPresent(Service.class)) continue;
                sAnno = clazz.getAnnotation(Service.class);
                metadatas.add(new AnnotationMetadata(sAnno, clazz));
            }
        }
        return metadatas;
    }
}

