/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.log;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.File;
import org.apache.logging.log4j.core.config.Configurator;
import org.springframework.beans.factory.InitializingBean;

public class LogConfiguratorProcess
implements InitializingBean {
    private static final String CUSTOME_LOG4J_FILE = "customlog4j.xml";
    private static Log log = LogFactory.getInstance(LogConfiguratorProcess.class);

    public void afterPropertiesSet() {
        log.info((Object)"<<<<<<<<<<start log configurator>>>>>>>>>>>", 1L);
        File confDir = new File("conf/");
        if (!confDir.exists()) {
            log.warn((Object)"read custome log4j.xml failed, no conf derectory found.", 1L);
            return;
        }
        boolean hasCustom = false;
        File[] files = confDir.listFiles();
        if (null == files) {
            log.error((Object)"Getting custom configuration files failed.", 1L);
            return;
        }
        for (File file : files) {
            if (!file.getName().equals(CUSTOME_LOG4J_FILE)) continue;
            log.info((Object)"found custome log4j.xml, set it as log4j configuration.", 1L);
            try {
                Configurator.initialize(null, (String)file.getCanonicalPath());
                hasCustom = true;
            }
            catch (Exception e) {
                log.error((Object)("configure customelog4j.xml failed, please check file." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
            break;
        }
        if (!hasCustom) {
            log.info((Object)"<<<<<<<<<<no custome log4j.xml, use lego log4j configuration>>>>>>>>>>>", 1L);
        }
        log.info((Object)"<<<<<<<<<<log configurator end>>>>>>>>>>>", 1L);
    }
}

