/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.persistance;

import com.huawei.lego.core.base.persistance.dao.CommonDaoImpl;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.core.NamedThreadLocal;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class HibernateUtil {
    public static final String OPEN_TYPE = "openType";
    public static final String CURRENT_TYPE = "currentType";
    public static final String MANUAL_CURRENT_TYPE = "manual_current_type";
    private static final Log logger = LogFactory.getInstance(HibernateUtil.class);
    private static final ThreadLocal<HashMap<Session, Set<String>>> CURRENTSESSION_FLAG = new NamedThreadLocal("CurrentSession Flag");
    private static CommonDaoImpl dao;

    private HibernateUtil(CommonDaoImpl dao) {
        HibernateUtil.setDao(dao);
    }

    public static void setDao(CommonDaoImpl dao) {
        HibernateUtil.dao = dao;
    }

    public static void closeSession(Session session) {
        logger.trace((Object)"start close session!");
        if (null != session && session.isOpen()) {
            try {
                if (!session.getTransaction().isActive()) {
                    if (HibernateUtil.containCurrentSessionType(session, CURRENT_TYPE)) {
                        TransactionSynchronizationManager.clear();
                        TransactionSynchronizationManager.unbindResourceIfPossible((Object)dao.getSessionFactory());
                    }
                    session.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)("Closing session failed." + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        }
    }

    public static void rollbackSession(Session session) {
        if (null != session) {
            try {
                Transaction transaction = session.getTransaction();
                if (transaction != null && transaction.isActive()) {
                    logger.error((Object)"transaction got error. start to rollback...");
                    transaction.rollback();
                    logger.info((Object)"transaction got error. rollback success");
                }
            }
            catch (Exception e) {
                logger.error((Object)("rollback session failed." + ExceptionUtil.getErrorMessage((Throwable)e)), (Throwable)e);
            }
        }
    }

    public static void beginTransaction(Session session) {
        Transaction transaction = session.getTransaction();
        if (transaction != null && !transaction.isActive()) {
            HibernateUtil.setCurrentSessionFlag(session, MANUAL_CURRENT_TYPE);
            session.beginTransaction();
        }
    }

    public static void commit(Session session) {
        Transaction transaction = session.getTransaction();
        if (transaction != null && transaction.isActive() && HibernateUtil.containCurrentSessionType(session, MANUAL_CURRENT_TYPE)) {
            transaction.commit();
            HibernateUtil.removeCurrentSessionFlag(session, MANUAL_CURRENT_TYPE);
        }
    }

    public static void setCurrentSessionFlag(Session session, String type) {
        if (HibernateUtil.isCurrentSessionFlag()) {
            HashMap<Session, Set<String>> map = CURRENTSESSION_FLAG.get();
            Set flags = map.getOrDefault(session, new HashSet());
            flags.add(type);
            map.put(session, flags);
        } else {
            HashMap map = new HashMap();
            HashSet<String> flags = new HashSet<String>();
            flags.add(type);
            map.put(session, flags);
            CURRENTSESSION_FLAG.set(map);
        }
    }

    public static boolean isCurrentSessionFlag() {
        return CURRENTSESSION_FLAG.get() != null;
    }

    public static void removeAllCurrentSessionFlag(Session session) {
        if (HibernateUtil.isCurrentSessionFlag()) {
            CURRENTSESSION_FLAG.get().remove(session);
            if (CURRENTSESSION_FLAG.get().isEmpty()) {
                CURRENTSESSION_FLAG.remove();
            }
        }
    }

    public static void removeCurrentSessionFlag(Session session, String type) {
        if (HibernateUtil.isCurrentSessionFlag()) {
            Set<String> flags = CURRENTSESSION_FLAG.get().get(session);
            flags.remove(type);
        }
    }

    public static Set<String> getCurrentSessionType(Session session) {
        if (HibernateUtil.isCurrentSessionFlag()) {
            return CURRENTSESSION_FLAG.get().get(session);
        }
        return null;
    }

    public static boolean containCurrentSessionType(Session session, String type) {
        Set<String> flags = HibernateUtil.getCurrentSessionType(session);
        if (flags == null) {
            return false;
        }
        return flags.contains(type);
    }

    public static String convertToJpaStyle(String queryString) {
        if (VerifyUtil.isEmpty((String)queryString) || !queryString.contains("?")) {
            return queryString;
        }
        if (queryString.contains("?0")) {
            return queryString;
        }
        StringBuilder sb = new StringBuilder();
        int index = 0;
        for (char s : queryString.toCharArray()) {
            sb.append(s);
            if (s != '?') continue;
            sb.append(index++);
        }
        return sb.toString();
    }
}

