/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.persistance.initializer;

import com.huawei.lego.core.base.persistance.initializer.HibernateCfgInitializer;
import com.huawei.lego.core.base.persistance.initializer.HibernateClassInitializer;
import com.huawei.lego.core.base.persistance.initializer.HibernateHbmInitializer;
import com.huawei.lego.core.base.persistance.initializer.HibernateInitializer;
import com.huawei.lego.core.base.persistance.service.DynamicConfiguration;
import com.huawei.lego.core.base.persistance.service.DynamicSessionFactoryService;
import com.huawei.lego.core.sdk.base.IBundleHelper;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Map;

public class HibernateConfigurationBuilder {
    private Log log = LogFactory.getInstance(HibernateConfigurationBuilder.class);
    private DynamicSessionFactoryService service;
    private IBundleHelper helper;

    public void setHelper(IBundleHelper helper) {
        this.helper = helper;
    }

    public void setSessionFactoryService(DynamicSessionFactoryService sessionFactoryService) {
        this.service = sessionFactoryService;
    }

    public HibernateInitializer createInitializer(String name) {
        HibernateInitializer initlizer = null;
        if ("com.huawei.lego.orm.hibernate.ds".equals(name)) {
            initlizer = new HibernateCfgInitializer();
        } else if ("com.huawei.lego.orm.hibernate.po".equals(name)) {
            initlizer = new HibernateClassInitializer();
        } else if ("com.huawei.lego.orm.hibernate.hbm".equals(name)) {
            initlizer = new HibernateHbmInitializer();
        }
        if (initlizer != null) {
            initlizer.setBundleHelper(this.helper).setService(this.service);
        }
        return initlizer;
    }

    public void buildAllSessionFactory() {
        Map<String, DynamicConfiguration> configurations = this.service.getAllConfigurations();
        if (configurations == null || configurations.isEmpty()) {
            throw new LegoUncheckedException("Hibernate configuration is null!");
        }
        for (Map.Entry<String, DynamicConfiguration> entry : configurations.entrySet()) {
            try {
                this.service.buildSessionFactory(entry.getKey());
            }
            catch (Exception e) {
                throw new LegoUncheckedException("Create hibernate session factory failed,because of ", (Throwable)e);
            }
            this.log.info((Object)(">>build " + entry.getKey() + " hibernate session factory ok!"), 1L);
        }
    }
}

