/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.persistance.initializer;

import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.hibernate.Filter;
import org.hibernate.LockMode;
import org.hibernate.ReplicationMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.criterion.DetachedCriteria;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class HibernateTemplateWrapper
extends HibernateTemplate {
    private static Log logger = LogFactory.getInstance(HibernateTemplateWrapper.class);

    public HibernateTemplateWrapper() {
    }

    public HibernateTemplateWrapper(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    protected <T> T transaction(Supplier<T> supplier, boolean isReadOnly) {
        SessionFactory sessionFactory;
        Session session;
        boolean manage;
        boolean bl = manage = !TransactionSynchronizationManager.isSynchronizationActive();
        if (manage) {
            logger.debug((Object)"operation not in transaction, need init spring session context!");
            TransactionSynchronizationManager.initSynchronization();
        }
        if (null == (session = (sessionFactory = this.getSessionFactory()).getCurrentSession())) {
            logger.error((Object)("session is null, manage:" + manage));
            throw new LegoUncheckedException("session is null, manage:" + manage);
        }
        Transaction transaction = null;
        try {
            if (manage) {
                if (!isReadOnly) {
                    transaction = session.beginTransaction();
                }
            } else {
                transaction = session.getTransaction();
                if (transaction == null) {
                    logger.debug((Object)"transaction is null, begin transaction");
                    transaction = session.beginTransaction();
                }
            }
            T res = supplier.get();
            if (manage) {
                logger.debug((Object)"manual commit transaction");
                if (!isReadOnly && transaction != null) {
                    transaction.commit();
                }
            }
            T t = res;
            return t;
        }
        catch (Exception ex) {
            if (manage && transaction != null) {
                logger.error((Object)"transaction got error,start to rollback.");
                transaction.rollback();
            }
            throw ExceptionUtil.convertException((Throwable)ex, (String)ExceptionUtil.getErrorMessage((Throwable)ex), (long)101L, (String[])new String[0], (Log)logger);
        }
        finally {
            if (manage) {
                if (null != session) {
                    session.close();
                }
                TransactionSynchronizationManager.clear();
                TransactionSynchronizationManager.unbindResourceIfPossible((Object)sessionFactory);
            }
        }
    }

    protected void transaction(Runnable runnable, boolean isReadOnly) {
        this.transaction(() -> {
            runnable.run();
            return null;
        }, isReadOnly);
    }

    public <T> T execute(HibernateCallback<T> action) throws DataAccessException {
        return (T)this.transaction(() -> super.execute(action), false);
    }

    public <T> T get(Class<T> entityClass, Serializable id) throws DataAccessException {
        return (T)this.transaction(() -> super.get(entityClass, id), true);
    }

    public <T> T get(Class<T> entityClass, Serializable id, LockMode lockMode) throws DataAccessException {
        return (T)this.transaction(() -> super.get(entityClass, id, lockMode), true);
    }

    public Object get(String entityName, Serializable id) throws DataAccessException {
        return this.transaction(() -> super.get(entityName, id), true);
    }

    public Object get(String entityName, Serializable id, LockMode lockMode) throws DataAccessException {
        return this.transaction(() -> super.get(entityName, id, lockMode), true);
    }

    public <T> T load(Class<T> entityClass, Serializable id) throws DataAccessException {
        return (T)this.transaction(() -> super.load(entityClass, id), true);
    }

    public <T> T load(Class<T> entityClass, Serializable id, LockMode lockMode) throws DataAccessException {
        return (T)this.transaction(() -> super.load(entityClass, id, lockMode), true);
    }

    public Object load(String entityName, Serializable id) throws DataAccessException {
        return this.transaction(() -> super.load(entityName, id), true);
    }

    public Object load(String entityName, Serializable id, LockMode lockMode) throws DataAccessException {
        return this.transaction(() -> super.load(entityName, id, lockMode), true);
    }

    public <T> List<T> loadAll(Class<T> entityClass) throws DataAccessException {
        return this.transaction(() -> super.loadAll(entityClass), true);
    }

    public void load(Object entity, Serializable id) throws DataAccessException {
        this.transaction(() -> super.load(entity, id), true);
    }

    public void refresh(Object entity) throws DataAccessException {
        this.transaction(() -> super.refresh(entity), true);
    }

    public void refresh(Object entity, LockMode lockMode) throws DataAccessException {
        this.transaction(() -> super.refresh(entity, lockMode), true);
    }

    public boolean contains(Object entity) throws DataAccessException {
        return this.transaction(() -> super.contains(entity), true);
    }

    public void evict(Object entity) throws DataAccessException {
        this.transaction(() -> super.evict(entity), true);
    }

    public void initialize(Object proxy) throws DataAccessException {
        this.transaction(() -> super.initialize(proxy), true);
    }

    public Filter enableFilter(String filterName) throws IllegalStateException {
        return this.transaction(() -> super.enableFilter(filterName), true);
    }

    public void lock(Object entity, LockMode lockMode) throws DataAccessException {
        this.transaction(() -> super.lock(entity, lockMode), true);
    }

    public void lock(String entityName, Object entity, LockMode lockMode) throws DataAccessException {
        this.transaction(() -> super.lock(entityName, entity, lockMode), true);
    }

    public Serializable save(Object entity) throws DataAccessException {
        return this.transaction(() -> super.save(entity), false);
    }

    public Serializable save(String entityName, Object entity) throws DataAccessException {
        return this.transaction(() -> super.save(entityName, entity), false);
    }

    public void update(Object entity) throws DataAccessException {
        this.transaction(() -> super.update(entity), false);
    }

    public void update(Object entity, LockMode lockMode) throws DataAccessException {
        this.transaction(() -> super.update(entity, lockMode), false);
    }

    public void update(String entityName, Object entity) throws DataAccessException {
        this.transaction(() -> super.update(entityName, entity), false);
    }

    public void update(String entityName, Object entity, LockMode lockMode) throws DataAccessException {
        this.transaction(() -> super.update(entityName, entity, lockMode), false);
    }

    public void saveOrUpdate(Object entity) throws DataAccessException {
        this.transaction(() -> super.saveOrUpdate(entity), false);
    }

    public void saveOrUpdate(String entityName, Object entity) throws DataAccessException {
        this.transaction(() -> super.saveOrUpdate(entityName, entity), false);
    }

    public void replicate(Object entity, ReplicationMode replicationMode) throws DataAccessException {
        this.transaction(() -> super.replicate(entity, replicationMode), false);
    }

    public void replicate(String entityName, Object entity, ReplicationMode replicationMode) throws DataAccessException {
        this.transaction(() -> super.replicate(entityName, entity, replicationMode), false);
    }

    public void persist(Object entity) throws DataAccessException {
        this.transaction(() -> super.persist(entity), false);
    }

    public void persist(String entityName, Object entity) throws DataAccessException {
        this.transaction(() -> super.persist(entityName, entity), false);
    }

    public <T> T merge(T entity) throws DataAccessException {
        return (T)this.transaction(() -> super.merge(entity), false);
    }

    public <T> T merge(String entityName, T entity) throws DataAccessException {
        return (T)this.transaction(() -> super.merge(entityName, entity), false);
    }

    public void delete(Object entity) throws DataAccessException {
        this.transaction(() -> super.delete(entity), false);
    }

    public void delete(Object entity, LockMode lockMode) throws DataAccessException {
        this.transaction(() -> super.delete(entity, lockMode), false);
    }

    public void delete(String entityName, Object entity) throws DataAccessException {
        this.transaction(() -> super.delete(entityName, entity), false);
    }

    public void delete(String entityName, Object entity, LockMode lockMode) throws DataAccessException {
        this.transaction(() -> super.delete(entityName, entity, lockMode), false);
    }

    public void deleteAll(Collection<?> entities) throws DataAccessException {
        this.transaction(() -> super.deleteAll(entities), false);
    }

    public void flush() throws DataAccessException {
        this.transaction(() -> super.flush(), true);
    }

    public void clear() throws DataAccessException {
        this.transaction(() -> super.clear(), true);
    }

    public List<?> findByCriteria(DetachedCriteria criteria) throws DataAccessException {
        return this.transaction(() -> super.findByCriteria(criteria), true);
    }

    public List<?> findByCriteria(DetachedCriteria criteria, int firstResult, int maxResults) throws DataAccessException {
        return this.transaction(() -> super.findByCriteria(criteria, firstResult, maxResults), true);
    }

    public <T> List<T> findByExample(T exampleEntity) throws DataAccessException {
        return this.transaction(() -> super.findByExample(exampleEntity), true);
    }

    public <T> List<T> findByExample(String entityName, T exampleEntity) throws DataAccessException {
        return this.transaction(() -> super.findByExample(entityName, exampleEntity), true);
    }

    public <T> List<T> findByExample(T exampleEntity, int firstResult, int maxResults) throws DataAccessException {
        return this.transaction(() -> super.findByExample(exampleEntity, firstResult, maxResults), true);
    }

    public <T> List<T> findByExample(String entityName, T exampleEntity, int firstResult, int maxResults) throws DataAccessException {
        return this.transaction(() -> super.findByExample(entityName, exampleEntity, firstResult, maxResults), true);
    }

    public List<?> find(String queryString, Object ... values) throws DataAccessException {
        return this.transaction(() -> super.find(queryString, values), true);
    }

    public List<?> findByNamedParam(String queryString, String paramName, Object value) throws DataAccessException {
        return this.transaction(() -> super.findByNamedParam(queryString, paramName, value), true);
    }

    public List<?> findByNamedParam(String queryString, String[] paramNames, Object[] values) throws DataAccessException {
        return this.transaction(() -> super.findByNamedParam(queryString, paramNames, values), true);
    }

    public List<?> findByValueBean(String queryString, Object valueBean) throws DataAccessException {
        return this.transaction(() -> super.findByValueBean(queryString, valueBean), true);
    }

    public List<?> findByNamedQuery(String queryName, Object ... values) throws DataAccessException {
        return this.transaction(() -> super.findByNamedQuery(queryName, values), true);
    }

    public List<?> findByNamedQueryAndNamedParam(String queryName, String paramName, Object value) throws DataAccessException {
        return this.transaction(() -> super.findByNamedQueryAndNamedParam(queryName, paramName, value), true);
    }

    public List<?> findByNamedQueryAndNamedParam(String queryName, String[] paramNames, Object[] values) throws DataAccessException {
        return this.transaction(() -> super.findByNamedQueryAndNamedParam(queryName, paramNames, values), true);
    }

    public List<?> findByNamedQueryAndValueBean(String queryName, Object valueBean) throws DataAccessException {
        return this.transaction(() -> super.findByNamedQueryAndValueBean(queryName, valueBean), true);
    }

    public Iterator<?> iterate(String queryString, Object ... values) throws DataAccessException {
        return this.transaction(() -> super.iterate(queryString, values), true);
    }

    public void closeIterator(Iterator<?> it) throws DataAccessException {
        this.transaction(() -> super.closeIterator(it), true);
    }

    public int bulkUpdate(String queryString, Object ... values) throws DataAccessException {
        return this.transaction(() -> super.bulkUpdate(queryString, values), false);
    }
}

