/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.persistance.track;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import org.hibernate.SessionFactory;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.LoadEvent;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.stat.EntityStatistics;
import org.hibernate.stat.SessionStatistics;
import org.hibernate.stat.Statistics;

public class OperationTrackListener
implements LoadEventListener {
    private static final long serialVersionUID = -5043950293766506842L;
    private Log log = LogFactory.getInstance(OperationTrackListener.class);

    public void onLoad(LoadEvent event, LoadEventListener.LoadType loadType) {
        EventSource session = event.getSession();
        SessionFactory sf = session.getSessionFactory();
        Statistics statistics = sf.getStatistics();
        this.trackSessionStatistics(session.getStatistics());
        this.trackSessionFactoryStatistics(statistics);
        this.trackEntityStatistics(event.getEntityClassName(), statistics.getEntityStatistics(event.getEntityClassName()));
    }

    private void trackSessionStatistics(SessionStatistics statistics) {
        statistics.getCollectionCount();
        statistics.getEntityCount();
    }

    private void trackSessionFactoryStatistics(Statistics statistics) {
        statistics.getConnectCount();
        statistics.getEntityDeleteCount();
        statistics.getEntityFetchCount();
        statistics.getEntityInsertCount();
        statistics.getEntityLoadCount();
        statistics.getEntityUpdateCount();
        statistics.getFlushCount();
        statistics.getOptimisticFailureCount();
        statistics.getPrepareStatementCount();
        this.log.info((Object)("--------------Invoke " + statistics.getQueryExecutionCount() + " Queries,Max time query is:" + statistics.getQueryExecutionMaxTimeQueryString() + " spends " + statistics.getQueryExecutionMaxTime()), 1L);
        double queryCacheHitCount = statistics.getQueryCacheHitCount();
        double queryCacheMissCount = statistics.getQueryCacheMissCount();
        double queryCacheHitRatio = queryCacheHitCount / (queryCacheHitCount + queryCacheMissCount);
        this.log.info((Object)("--------------Query Hit ratio:" + queryCacheHitRatio), 1L);
        statistics.getSessionCloseCount();
        statistics.getSessionOpenCount();
        this.log.info((Object)("--------------" + statistics.getSessionOpenCount() + " sessions was opened," + statistics.getSessionCloseCount() + " sessions was closed," + (statistics.getSessionOpenCount() - statistics.getSessionCloseCount()) + " sessions need to closed!"), 1L);
        if (statistics.getTransactionCount() > 0L) {
            double tranHitRatio = (double)statistics.getSuccessfulTransactionCount() / (double)statistics.getTransactionCount();
            this.log.info((Object)("--------------Transaction invoked successful ratio:" + tranHitRatio), 1L);
        }
    }

    private void trackEntityStatistics(String entity, EntityStatistics statistics) {
        statistics.getDeleteCount();
        statistics.getFetchCount();
        statistics.getInsertCount();
        statistics.getLoadCount();
        statistics.getOptimisticFailureCount();
        statistics.getUpdateCount();
        long changes = statistics.getInsertCount() + statistics.getUpdateCount() + statistics.getDeleteCount();
        this.log.info((Object)("--------------" + entity + " changed " + changes + "times"), 1L);
    }
}

