/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.service;

import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.log.ILogConfigService;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;

@Service(Name="logConfigService", Desc="", Interface=ILogConfigService.class)
public class LogConfigService
extends BaseService
implements ILogConfigService {
    private static final String NAME_LOGGER_COM_HUAWEI_LEGO = "com.huawei.lego";
    private static Map<String, Level> levels = new HashMap<String, Level>(6);
    private Log log = LogFactory.getInstance(LogConfigService.class);

    public boolean changeLevel(String level) {
        String levelStr = level.toLowerCase(Locale.US);
        if (!levels.keySet().contains(levelStr)) {
            this.log.error((Object)("Wrong Param: " + level), 1L);
            return false;
        }
        this.log.fatal((Object)("##### change level is: " + levelStr), 1L);
        Configurator.setAllLevels((String)NAME_LOGGER_COM_HUAWEI_LEGO, (Level)levels.get(levelStr));
        return true;
    }

    public String checkService() {
        return "succ";
    }

    static {
        levels.put("debug", Level.DEBUG);
        levels.put("info", Level.INFO);
        levels.put("warn", Level.WARN);
        levels.put("error", Level.ERROR);
        levels.put("fatal", Level.FATAL);
    }
}

