/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.thread;

import com.huawei.lego.core.base.thread.Cache;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class Enhancer {
    private static final Log logger = LogFactory.getInstance(Enhancer.class);

    private Enhancer() {
    }

    public static <T> Callable<T> timeCallable(String name, Callable<T> task) {
        return () -> {
            long s = System.currentTimeMillis();
            try {
                Object result = task.call();
                logger.debug((Object)(name + " is success"));
                Object v = result;
                return v;
            }
            finally {
                long e = System.currentTimeMillis();
                logger.debug((Object)(name + " time cost: " + (e - s) + "ms"));
            }
        };
    }

    public static <T> Supplier<T> timeSupplier(String name, Supplier<T> task) {
        return () -> {
            long s = System.currentTimeMillis();
            try {
                Object result = task.get();
                logger.debug((Object)(name + " is success"));
                Object t = result;
                return t;
            }
            finally {
                long e = System.currentTimeMillis();
                logger.debug((Object)(name + " time cost: " + (e - s) + "ms"));
            }
        };
    }

    public static Runnable timeRunnable(String name, Runnable task) {
        return () -> {
            long s = System.currentTimeMillis();
            try {
                task.run();
                logger.debug((Object)(name + " is success"));
            }
            finally {
                long e = System.currentTimeMillis();
                logger.debug((Object)(name + " time cost: " + (e - s) + "ms"));
            }
        };
    }

    public static <T> List<Callable<T>> shareableCallables(List<Callable<T>> tasks) {
        return tasks.stream().map(Enhancer::shareableCallable).collect(Collectors.toList());
    }

    public static <T> Callable<T> shareableCallable(Callable<T> callable) {
        Cache cache = Cache.get();
        if (cache == null) {
            return callable;
        }
        StackTraceElement[] caller = new RuntimeException().getStackTrace();
        return () -> Cache.call(() -> {
            StackTraceElement[] callee = new RuntimeException().getStackTrace();
            cache.share(Cache.get(), caller, callee);
            return callable.call();
        }, new Runnable[0]);
    }

    public static Runnable shareableRunnable(Runnable runnable) {
        Cache cache = Cache.get();
        if (cache == null) {
            return runnable;
        }
        StackTraceElement[] caller = new RuntimeException().getStackTrace();
        return () -> Cache.call(() -> {
            StackTraceElement[] callee = new RuntimeException().getStackTrace();
            cache.share(Cache.get(), caller, callee);
            runnable.run();
            return null;
        }, new Runnable[0]);
    }
}

