/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.thread;

import com.huawei.lego.core.base.thread.BaseTaskResult;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;

public class FutureResult<T> {
    private T data;
    private Throwable cause;

    public FutureResult(T data) {
        this.data = data;
    }

    public FutureResult(Throwable cause) {
        this.cause = cause;
    }

    public FutureResult(T data, Throwable cause) {
        this.data = data;
        this.cause = cause;
    }

    public T getData() {
        return this.data;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public boolean success() {
        return this.cause == null;
    }

    public boolean failure() {
        if (this.cause != null) {
            return true;
        }
        if (this.data instanceof BaseTaskResult) {
            return !((BaseTaskResult)this.data).isResultFlag();
        }
        return false;
    }

    public FutureResult<T> rethrow() {
        if (this.cause instanceof LegoCheckedException) {
            throw (LegoCheckedException)this.cause;
        }
        if (this.cause != null) {
            throw new LegoCheckedException(-1L, this.cause);
        }
        return this;
    }

    public static <E> boolean hasFailedResult(Collection<FutureResult<E>> results) {
        return !FutureResult.getFailedResults(results).isEmpty();
    }

    public static <E> Collection<FutureResult<E>> getFailedResults(Collection<FutureResult<E>> results) {
        return Optional.ofNullable(results).orElseGet(Collections::emptyList).stream().filter(FutureResult::failure).collect(Collectors.toList());
    }

    public static <E> void check(Collection<FutureResult<E>> results) {
        FutureResult.check(results, -1L, new String[0]);
    }

    public static <E> void check(Collection<FutureResult<E>> results, long errorCode, String ... params) {
        Collection<FutureResult<E>> failures = FutureResult.getFailedResults(results);
        if (failures.isEmpty()) {
            return;
        }
        LegoCheckedException[] errors = (LegoCheckedException[])failures.stream().map(FutureResult::getCause).map(e -> LegoCheckedException.cast((Throwable)e, (long)errorCode, (String[])params)).toArray(LegoCheckedException[]::new);
        if (errors.length == 1) {
            throw errors[0];
        }
        throw LegoCheckedException.combine((LegoCheckedException[])errors);
    }
}

