/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.util;

import com.huawei.lego.core.base.util.ConverterUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;

class LegoDBProperties {
    public static final String MYSQL = "mysql";
    public static final String SQLSERVER = "sqlserver";
    private static final String LEGO_PROPERTIES = "lego.properties";
    private static final Properties PROPS = new Properties();
    private static Log log = LogFactory.getInstance(ConverterUtil.class);

    LegoDBProperties() {
    }

    public static String getDBType() {
        String dbType = MYSQL;
        String value = PROPS.getProperty("hibernate.connection.url");
        if (null != value && value.toLowerCase(Locale.US).indexOf(SQLSERVER) >= 0) {
            dbType = SQLSERVER;
        }
        return dbType;
    }

    static {
        InputStream ins = null;
        try {
            ClassLoader cLoader = LegoDBProperties.class.getClassLoader();
            if (null != cLoader) {
                ins = cLoader.getResourceAsStream(LEGO_PROPERTIES);
            }
            if (null != ins) {
                PROPS.load(ins);
            }
        }
        catch (IOException e) {
            log.error((Object)"read default.properties fail.", (Throwable)e, 0L);
        }
        finally {
            if (null != ins) {
                try {
                    ins.close();
                }
                catch (IOException e) {
                    log.error((Object)"Close default.properties fail.", (Throwable)e, 0L);
                }
            }
        }
    }
}

