/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.domain;

import com.huawei.lego.core.domain.DomainApplicaton;
import com.huawei.lego.core.domain.DomainContainer;
import com.huawei.lego.core.domain.context.ModelContext;
import com.huawei.lego.core.domain.context.ModelServiceMapping;
import com.huawei.lego.core.domain.context.ProductContext;
import com.huawei.lego.core.domain.context.ServiceContext;
import com.huawei.lego.core.sdk.base.structure.AbsApplication;
import com.huawei.lego.core.sdk.domain.IInitializer;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Element;

public class ContainerInitializer
implements IInitializer {
    private DomainContainer container;
    private AbsApplication application;
    private Log log = LogFactory.getInstance(ContainerInitializer.class);

    public void setContainer(DomainContainer container) {
        this.container = container;
    }

    public DomainContainer getContainer() {
        return this.container;
    }

    public void setApplication(AbsApplication application) {
        this.application = application;
    }

    public void initialize(Collection<Map> context) {
        this.initContainer(context);
    }

    private void initContainer(Collection<Map> contexts) {
        this.log.info((Object)"~~~~~~~~~~~~~~~~ start initializing domain container!", 1L);
        if (contexts != null && !contexts.isEmpty()) {
            Iterator<Map> iterator = contexts.iterator();
            HashMap<String, ProductContext> pCtxMapping = new HashMap<String, ProductContext>();
            while (iterator.hasNext()) {
                Map context = iterator.next();
                this.fillProductContext(pCtxMapping, context);
            }
            if (this.application != null) {
                ((DomainApplicaton)this.application).setProductContext(pCtxMapping);
                this.log.info((Object)("+++++++++++++++" + pCtxMapping), 1L);
            }
        }
    }

    private void fillProductContext(Map<String, ProductContext> pCtxMapping, Map context) {
        Element modelNode = (Element)context.get("ctx.domain.model");
        if (modelNode.getParent() != null) {
            ProductContext pContext;
            String pID = modelNode.getParent().attributeValue("id");
            if (!pCtxMapping.containsKey(pID)) {
                pContext = new ProductContext(modelNode.getParent());
                pCtxMapping.put(pContext.getId(), pContext);
                pContext.setpModelMappings(new HashMap<String, ModelServiceMapping>());
            } else {
                pContext = pCtxMapping.get(pID);
            }
            String indentifier = modelNode.attributeValue("bundle");
            ModelContext modelCtx = new ModelContext(modelNode);
            ModelServiceMapping mapping = new ModelServiceMapping(modelCtx, this.initMoServices(context));
            mapping.setBundleIdentifier(indentifier);
            pContext.getpModelMappings().put(modelNode.attributeValue("id"), mapping);
        }
    }

    private ServiceContext[] initMoServices(Map context) {
        Map services;
        ServiceContext[] srvContexts = null;
        if (context != null && !context.isEmpty() && (services = (Map)context.get("ctx.domain.service")) != null) {
            Collection eles = services.values();
            srvContexts = new ServiceContext[eles.size()];
            int count = 0;
            for (Element ele : eles) {
                srvContexts[count++] = new ServiceContext(ele);
            }
        }
        return srvContexts;
    }
}

