/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.domain.context;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.Messages;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Iterator;
import org.dom4j.Attribute;
import org.dom4j.Element;

public abstract class BaseContext
implements Serializable {
    protected static final boolean DEBUG = false;
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getInstance(BaseContext.class);

    public void initContextField(BaseContext ctx, Element element) {
        Iterator iterator = element.attributeIterator();
        while (iterator.hasNext()) {
            Attribute attr = (Attribute)iterator.next();
            try {
                this.processClassField(ctx, attr);
            }
            catch (SecurityException e) {
                log.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)e, 1L);
            }
            catch (IllegalAccessException e) {
                log.error((Object)e, 1L);
            }
        }
    }

    private void processClassField(BaseContext ctx, Attribute attr) throws IllegalAccessException {
        Field f;
        block6: {
            f = null;
            try {
                f = ctx.getClass().getDeclaredField(attr.getName());
            }
            catch (NoSuchFieldException e) {
                if (attr.getName().equalsIgnoreCase("bundle")) break block6;
                log.info((Object)(attr.getName() + " " + Messages.getMessage((String)"MODEL_ATTRIBUTE_NOT_DEFINE")), 1L);
            }
        }
        if (f != null) {
            f.setAccessible(true);
            if (f.getType() == String.class) {
                String value = attr.getValue();
                if (value.contains(";")) {
                    f.set(ctx, value.split(";"));
                } else {
                    f.set(ctx, value);
                }
            }
        }
    }

    public Log getLog() {
        return log;
    }
}

