/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.log4j;

import com.huawei.lego.core.log4j.SecurityThrowable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.impl.ThrowableFormatOptions;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.util.StringBuilderWriter;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="FilterThrowablePatternConverter", category="Converter")
@ConverterKeys(value={"bcmex"})
public class FilterThrowablePatternConvert
extends LogEventPatternConverter {
    protected final List<PatternFormatter> formatters;
    private final boolean nonStandardLineSeparator;
    private final boolean subShortOption;
    private final ThrowableFormatOptions options;
    private String rawOption;

    @Deprecated
    protected FilterThrowablePatternConvert(String name, String style, String[] options) {
        this(name, style, options, null);
    }

    protected FilterThrowablePatternConvert(String name, String style, String[] options, Configuration config) {
        super(name, style);
        List suffixFormatters;
        List parsedSuffixFormatters;
        if (options != null && options.length > 0) {
            this.rawOption = options[0];
        }
        this.options = ThrowableFormatOptions.newInstance((String[])options);
        this.formatters = this.options.getSuffix() == null ? Collections.emptyList() : ((parsedSuffixFormatters = PatternLayout.createPatternParser((Configuration)config).parse(this.options.getSuffix())) != null && !parsedSuffixFormatters.isEmpty() ? ((suffixFormatters = parsedSuffixFormatters.stream().filter(item -> !item.handlesThrowable()).collect(Collectors.toList())).size() != parsedSuffixFormatters.size() ? suffixFormatters : parsedSuffixFormatters) : parsedSuffixFormatters);
        this.subShortOption = "short.message".equalsIgnoreCase(this.rawOption) || "short.localizedMessage".equalsIgnoreCase(this.rawOption) || "short.fileName".equalsIgnoreCase(this.rawOption) || "short.lineNumber".equalsIgnoreCase(this.rawOption) || "short.methodName".equalsIgnoreCase(this.rawOption) || "short.className".equalsIgnoreCase(this.rawOption);
        this.nonStandardLineSeparator = !Strings.LINE_SEPARATOR.equals(this.options.getSeparator());
    }

    public static FilterThrowablePatternConvert newInstance(Configuration config, String[] options) {
        return new FilterThrowablePatternConvert("Throwable", "throwable", options, config);
    }

    public void format(LogEvent event, StringBuilder buffer) {
        SecurityThrowable throwable;
        SecurityThrowable securityThrowable = throwable = event.getThrown() != null ? new SecurityThrowable(event.getThrown()) : null;
        if (this.subShortOption) {
            this.formatSubShortOption(throwable, this.getSuffix(event), buffer);
        } else if (throwable != null && this.options.anyLines()) {
            this.formatOption(throwable, this.getSuffix(event), buffer);
        }
    }

    private void formatSubShortOption(Throwable t, String suffix, StringBuilder buffer) {
        if (t != null) {
            StackTraceElement throwingMethod = null;
            StackTraceElement[] trace = t.getStackTrace();
            if (trace != null && trace.length > 0) {
                throwingMethod = trace[0];
            }
            if (throwingMethod != null) {
                String toAppend;
                switch (this.rawOption) {
                    case "short.className": {
                        toAppend = throwingMethod.getClassName();
                        break;
                    }
                    case "short.methodName": {
                        toAppend = throwingMethod.getMethodName();
                        break;
                    }
                    case "short.lineNumber": {
                        toAppend = String.valueOf(throwingMethod.getLineNumber());
                        break;
                    }
                    case "short.message": {
                        toAppend = t.getMessage();
                        break;
                    }
                    case "short.localizedMessage": {
                        toAppend = t.getLocalizedMessage();
                        break;
                    }
                    case "short.fileName": {
                        toAppend = throwingMethod.getFileName();
                        break;
                    }
                    default: {
                        toAppend = "";
                    }
                }
                if (buffer.length() > 0 && !Character.isWhitespace(buffer.charAt(buffer.length() - 1))) {
                    buffer.append(' ');
                }
                buffer.append(toAppend);
                if (Strings.isNotBlank((String)suffix)) {
                    buffer.append(' ').append(suffix);
                }
            }
        }
    }

    private void formatOption(Throwable throwable, String suffix, StringBuilder buffer) {
        if (buffer.length() > 0 && !Character.isWhitespace(buffer.charAt(buffer.length() - 1))) {
            buffer.append(' ');
        }
        if (!this.options.allLines() || this.nonStandardLineSeparator || Strings.isNotBlank((String)suffix)) {
            StringWriter w = new StringWriter();
            throwable.printStackTrace(new PrintWriter(w));
            String[] array = w.toString().split(Strings.LINE_SEPARATOR);
            boolean suffixNotBlank = Strings.isNotBlank((String)suffix);
            int limit = this.options.minLines(array.length) - 1;
            for (int i = 0; i <= limit; ++i) {
                buffer.append(array[i]);
                if (suffixNotBlank) {
                    buffer.append(' ').append(suffix);
                }
                if (i == limit) continue;
                buffer.append(this.options.getSeparator());
            }
        } else {
            throwable.printStackTrace(new PrintWriter((Writer)new StringBuilderWriter(buffer)));
        }
    }

    public boolean handlesThrowable() {
        return true;
    }

    protected String getSuffix(LogEvent event) {
        if (!this.formatters.isEmpty()) {
            StringBuilder toAppendTo = new StringBuilder();
            for (PatternFormatter formatter : this.formatters) {
                formatter.format(event, toAppendTo);
            }
            return toAppendTo.toString();
        }
        return "";
    }

    public ThrowableFormatOptions getOptions() {
        return this.options;
    }
}

