/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.mediation.nepoll;

import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.cbb.resource.sdk.model.TopoObjectQueryCondition;
import com.huawei.lego.cbb.resource.sdk.service.IDataExplore;
import com.huawei.lego.core.mediation.nepoll.PingPoll;
import com.huawei.lego.core.mediation.nepoll.PollPlugin;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.List;

class InitPollThread
implements Runnable {
    private static final long VALUE_3000L = 3000L;
    private Log logger = LogFactory.getInstance(InitPollThread.class);
    private IDataExplore dateExplorer = null;

    public InitPollThread(IDataExplore dateExplorer) {
        this.dateExplorer = dateExplorer;
    }

    @Override
    public void run() {
        try {
            CommonUtil.sleep((long)3000L);
            TopoObjectQueryCondition condition = new TopoObjectQueryCondition();
            condition.setUserId(null);
            condition.setIsManaged(Boolean.valueOf(true));
            List topoObjects = this.dateExplorer.getDataList(condition);
            for (TopoObject topoMo : topoObjects) {
                if (topoMo.getUuid().equals(PollPlugin.getInstance().getMediationApp().getLegoSystem().getUuid())) continue;
                long moId = topoMo.getMoId();
                String moIP = topoMo.getIpAddress();
                String moName = topoMo.getName();
                if (!topoMo.getSupportPing().booleanValue()) {
                    this.logger.error((Object)("no support ping,ip:" + moIP + ",moId:" + moId + ",moName:" + moName), 1L);
                    continue;
                }
                if (null == moIP) {
                    this.logger.error((Object)("moIP is null, can not add a poll task while starting, moId:" + moId), 1L);
                    continue;
                }
                String descr = topoMo.getDescription();
                if (null != descr && descr.equals("manual")) {
                    this.logger.info((Object)("no need to add a poll task while starting, moId: " + moId + ", moName: " + moName + ", moIP: " + moIP), 1L);
                    continue;
                }
                PollPlugin.getInstance().addPingPoll(new PingPoll(moId, moIP, moName));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("get all TopoObject in PollPlugin failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
    }
}

