/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.mediation.nepoll;

import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.core.mediation.nepoll.PingPoll;
import com.huawei.lego.core.mediation.nepoll.PollPlugin;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collection;
import java.util.Map;

public class NeAddSubscriber {
    private Log logger = LogFactory.getInstance(NeAddSubscriber.class);

    public void onMessage(Map<Long, ManagedObject> msgObj) {
        if (null == msgObj) {
            this.logger.error((Object)"recv a null message object, message type: COMMAND_RES_ADD", 1L);
            return;
        }
        try {
            this.logger.info((Object)("recv a COMMAND_RES_ADD message, moIds: " + msgObj.keySet()), 1L);
            Collection<ManagedObject> moList = msgObj.values();
            this.constructMessage(moList);
        }
        catch (Exception e) {
            this.logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
    }

    private void constructMessage(Collection<ManagedObject> moList) {
        for (ManagedObject mo : moList) {
            if (!(mo instanceof TopoObject)) continue;
            TopoObject topoMo = (TopoObject)mo;
            String moIP = topoMo.getIpAddress();
            if (null == moIP) {
                this.logger.error((Object)"moIP is null, can not add a poll task.", 1L);
                continue;
            }
            this.logger.info((Object)("TopoObject contained in COMMAND_RES_ADD message which moId: " + topoMo.getMoId() + ", moIP: " + moIP), 1L);
            String descr = topoMo.getDescription();
            if (null != descr && descr.equals("manual")) {
                this.logger.info((Object)("recv a manual add device in NeAddSubscriber, no need to add a poll task, ip: " + moIP), 1L);
                continue;
            }
            this.constructPollTask(moIP, topoMo);
        }
    }

    private void constructPollTask(String moIP, TopoObject topoMo) {
        long moId = topoMo.getMoId();
        String moName = topoMo.getName();
        if (!topoMo.getSupportPing().booleanValue()) {
            this.logger.error((Object)("no support ping,ip:" + moIP + ",moId:" + moId + ",moName:" + moName), 1L);
            return;
        }
        PollPlugin.getInstance().addPingPoll(new PingPoll(moId, moIP, moName));
    }
}

