/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.mediation.nepoll;

import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.core.mediation.nepoll.PingPoll;
import com.huawei.lego.core.mediation.nepoll.PollPlugin;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collection;
import java.util.Map;

public class NeUpdateSubscriber {
    private Log logger = LogFactory.getInstance(NeUpdateSubscriber.class);

    public void onMessage(Map<Long, ManagedObject> msgObj) {
        if (null == msgObj) {
            this.logger.error((Object)"recv a null message object, message type: COMMAND_RES_UPDATE", 1L);
            return;
        }
        try {
            Collection<ManagedObject> moList = msgObj.values();
            this.logger.info((Object)("recv a COMMAND_RES_UPDATE message, moIds: " + msgObj.keySet()), 1L);
            this.contructMessage(moList);
        }
        catch (Exception e) {
            this.logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
    }

    private void contructMessage(Collection<ManagedObject> moList) {
        for (ManagedObject mo : moList) {
            if (!(mo instanceof TopoObject)) continue;
            TopoObject topoMo = (TopoObject)mo;
            String moIP = topoMo.getIpAddress();
            if (null == moIP) {
                this.logger.error((Object)"moIP is null, can not add a poll task.", 1L);
                continue;
            }
            this.logger.info((Object)("TopoObject contained in COMMAND_RES_UPDATE message which moId: " + topoMo.getMoId() + ", moIP: " + moIP), 1L);
            String descr = topoMo.getDescription();
            if (null != descr && descr.equals("manual")) {
                this.logger.info((Object)("recv a manual add device in NeUpdateSubscriber, no need to add a poll task, ip: " + moIP), 1L);
                continue;
            }
            this.updatePollTask(moIP, topoMo);
        }
    }

    private void updatePollTask(String moIP, TopoObject topoMo) {
        long moId = topoMo.getMoId();
        String moName = topoMo.getName();
        if (!topoMo.getSupportPing().booleanValue()) {
            this.logger.error((Object)("no support ping,ip:" + moIP + ",moId:" + moId + ",moName:" + moName), 1L);
            return;
        }
        PollPlugin.getInstance().updatePingPoll(new PingPoll(moId, moIP, moName));
    }
}

