/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.mediation.nepoll;

import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.mediation.nepoll.PollPlugin;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.Serializable;
import java.util.HashMap;

public class PingPoll
implements Serializable {
    private static final long serialVersionUID = 312499003263152431L;
    private static final int STATUS_ONLINE = 0;
    private static final int STATUS_OFFLINE = -1;
    private Log logger = LogFactory.getInstance(PingPoll.class);
    private long moId;
    private String moIP;
    private String moName;
    private boolean isFirstTime = true;
    private boolean isOnline = true;

    public PingPoll(long moId, String moIP, String moName) {
        this.moId = moId;
        this.moIP = moIP;
        this.moName = moName;
    }

    public void sendOffLineMsg() {
        try {
            this.logger.warn((Object)("ping " + this.moIP + " is not reachable."), 1L);
            if (this.isOnline) {
                IMessageCenter mc = PollPlugin.getInstance().getMc();
                HashMap<Long, Integer> msg = new HashMap<Long, Integer>();
                msg.put(this.moId, -1);
                MessageUnit mu = new MessageUnit();
                mu.setCmdcode(109L);
                mu.setObj(msg);
                mu.setMt(MessageTopic.COMMAND);
                mu.setSourceAppName(this.getClass().getName());
                mc.sendMessage(mu);
                this.isOnline = false;
                this.isFirstTime = false;
                this.logger.info((Object)("send mo offline message success and generate a offline alarm, moId: " + this.getMoId() + ", moIP: " + this.moIP), 1L);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("send mo offline message and generate offline alarm failed, moId: " + this.getMoId() + ", moIP: " + this.moIP + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
    }

    public void sendOnLineMsg() {
        this.logger.debug((Object)("ping " + this.moIP + " is reachable."), 1L);
        HashMap<Long, Integer> msg = new HashMap<Long, Integer>();
        msg.put(this.getMoId(), 0);
        if (this.isFirstTime) {
            IMessageCenter mc = PollPlugin.getInstance().getMc();
            MessageUnit mu = new MessageUnit();
            mu.setCmdcode(110L);
            mu.setObj(msg);
            mu.setMt(MessageTopic.COMMAND);
            mu.setSourceAppName(this.getClass().getName());
            mc.sendMessage(mu);
            this.isFirstTime = false;
            this.isOnline = true;
            this.logger.info((Object)("send mo online message and generate a offline restore alarm at first time, moId: " + this.getMoId() + ", moIP: " + this.moIP), 1L);
            return;
        }
        try {
            if (!this.isOnline) {
                IMessageCenter mc = PollPlugin.getInstance().getMc();
                MessageUnit mu = new MessageUnit();
                mu.setCmdcode(110L);
                mu.setObj(msg);
                mu.setMt(MessageTopic.COMMAND);
                mu.setSourceAppName(this.getClass().getName());
                mc.sendMessage(mu);
                this.isOnline = true;
                this.logger.info((Object)("send mo online message and generate a offline restore alarm, moId: " + this.getMoId() + ", moIP: " + this.moIP), 1L);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("send mo offline message and generate offline restore alarm failed, moId: " + this.getMoId() + ", moIP: " + this.moIP + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
    }

    public long getMoId() {
        return this.moId;
    }

    public void setMoId(long moId) {
        this.moId = moId;
    }

    public String getMoIP() {
        return this.moIP;
    }

    public void setMoIP(String moIP) {
        this.moIP = moIP;
    }

    public String getMoName() {
        return this.moName;
    }

    public void setMoName(String moName) {
        this.moName = moName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.moIP == null ? 0 : this.moIP.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        PingPoll other = (PingPoll)obj;
        return other.getMoId() == this.getMoId();
    }

    public String toString() {
        return new StringBuffer().append("moId: ").append(this.moId).append(", moIP:").append(this.moIP).append(", moName: ").append(this.moName).toString();
    }
}

