/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.mediation.nepoll;

import com.huawei.lego.cbb.resource.sdk.service.IDataExplore;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.base.thread.ThreadPoolManager;
import com.huawei.lego.core.mediation.IPlugin;
import com.huawei.lego.core.mediation.MediationApp;
import com.huawei.lego.core.mediation.nepoll.InitPollThread;
import com.huawei.lego.core.mediation.nepoll.PingPoll;
import com.huawei.lego.core.mediation.nepoll.PollTask;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.base.event.ServiceStatusChangedListener;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.nem.webnms.sdk.service.IPingService;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class PollPlugin
implements IPlugin,
ServiceStatusChangedListener {
    public static final Object SLOCK = new Object();
    private static final Object PLOCK = new Object();
    private static PollPlugin sInstance = null;
    private Log logger = LogFactory.getInstance(PollPlugin.class);
    private long interval;
    private int timeout = 5;
    private int retries = 1;
    private int batchCount = 10;
    private IMessageCenter mc;
    private List<PollTask> pollTaskCache = new ArrayList<PollTask>();
    private IDataExplore dateExplorer = null;
    private IPingService pingService = null;
    private MediationApp mediationApp = null;

    private PollPlugin() {
    }

    public static synchronized PollPlugin getInstance() {
        if (null == sInstance) {
            sInstance = new PollPlugin();
        }
        return sInstance;
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        try {
            if (event.getStatus() == Status.STATUS_STARTED) {
                if (event.getEventTarget() instanceof IPingService) {
                    this.pingService = (IPingService)ServiceContext.getInstance().lookup("discover/pingService");
                } else if (event.getEventTarget() instanceof IDataExplore) {
                    this.dateExplorer = (IDataExplore)ServiceContext.getInstance().lookup("ResourceApplication/DeviceDataExplore");
                    ExecutionService.submitTask(new InitPollThread(this.dateExplorer));
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("look up ResourceApplication/DeviceDataExplore failed in InitPollThread." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
    }

    @Override
    public void init() {
        Properties props = new Properties();
        InputStream ins = null;
        try {
            ClassLoader clazzLoader = this.getClass().getClassLoader();
            if (null != clazzLoader) {
                ins = clazzLoader.getResourceAsStream("poll.properties");
            }
            if (null != ins) {
                props.load(ins);
            }
            this.interval = NumberUtil.convertToLong((Object)props.getProperty("poll_interval", "600"));
            this.timeout = NumberUtil.convertToInteger((Object)props.getProperty("poll_timeout", "5"));
            this.retries = NumberUtil.convertToInteger((Object)props.getProperty("poll_retries", "1"));
            this.batchCount = NumberUtil.convertToInteger((Object)props.getProperty("batch_count", "10"));
        }
        catch (Exception e) {
            this.logger.error((Object)("read poll.properties error." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            throw new LegoUncheckedException((Throwable)e);
        }
        finally {
            if (null != ins) {
                try {
                    ins.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)"Close the input stream failed.", (Throwable)e, 1L);
                }
            }
        }
        this.logger.info((Object)"PollPlugin in Mediation has started.", 1L);
    }

    @Override
    public void destroy() {
    }

    public long getInterval() {
        return this.interval;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getRetries() {
        return this.retries;
    }

    public int getBatchCount() {
        return this.batchCount;
    }

    public IMessageCenter getMc() {
        return this.mc;
    }

    public void setMc(IMessageCenter mc) {
        this.mc = mc;
    }

    public IPingService getPingService() {
        try {
            while (null == this.pingService) {
                CommonUtil.sleep((long)1000L);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
        return this.pingService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheTask(PollTask task) {
        Object object = PLOCK;
        synchronized (object) {
            if (null != task) {
                this.pollTaskCache.add(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPingPoll(PingPoll pingPoll) {
        Object object = PLOCK;
        synchronized (object) {
            try {
                this.addPingPollTasks(pingPoll);
                CommonUtil.sleep((long)50L);
            }
            catch (Exception e) {
                this.logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
            }
        }
    }

    private void addPingPollTasks(PingPoll pingPoll) {
        boolean result = false;
        for (PollTask task : this.pollTaskCache) {
            if (result || !task.hasSpace()) continue;
            task.addPingPoll(pingPoll);
            result = true;
        }
        if (!result) {
            PollTask newTask = new PollTask();
            newTask.addPingPoll(pingPoll);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePingPoll(PingPoll pingPoll) {
        Object object = PLOCK;
        synchronized (object) {
            PingPoll oldPoll = null;
            for (PollTask task : this.pollTaskCache) {
                oldPoll = task.getPingPoll(pingPoll.getMoId());
                if (null == oldPoll) continue;
                task.updatePingPoll(pingPoll);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePingPoll(long moId) {
        Object object = PLOCK;
        synchronized (object) {
            Iterator<PollTask> itor = this.pollTaskCache.iterator();
            while (itor.hasNext()) {
                PollTask task = itor.next();
                long taskTimeStamp = task.getTimeStamp();
                task.deletePingPoll(moId);
                if (!task.isEmpty()) continue;
                itor.remove();
                ThreadPoolManager.deleteTask(taskTimeStamp);
            }
        }
    }

    public MediationApp getMediationApp() {
        return this.mediationApp;
    }

    public void setMediationApp(MediationApp mediationApp) {
        this.mediationApp = mediationApp;
    }
}

