/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.mediation.nepoll;

import com.huawei.lego.core.base.thread.RunnableTask;
import com.huawei.lego.core.base.thread.ThreadPoolManager;
import com.huawei.lego.core.mediation.nepoll.PingPoll;
import com.huawei.lego.core.mediation.nepoll.PollPlugin;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PollTask
extends RunnableTask {
    private static final int VAULE_32 = 32;
    private Log logger = LogFactory.getInstance(PollTask.class);
    private Object lock = new Object();
    private List<PingPoll> pingPollList = Collections.synchronizedList(new ArrayList());
    private long lastExcuteTime = 0L;

    public PollTask() {
        this.setPeriodTask(true);
        PollPlugin.getInstance().cacheTask(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPingPoll(PingPoll pingPoll) {
        Object object = PollPlugin.SLOCK;
        synchronized (object) {
            long mId = pingPoll.getMoId();
            String mIP = pingPoll.getMoIP();
            String mName = pingPoll.getMoName();
            PingPoll oldPoll = this.getPingPoll(mId);
            if (null != oldPoll && !mIP.equals(oldPoll.getMoIP())) {
                String oldIP = oldPoll.getMoIP();
                oldPoll.setMoIP(mIP);
                ThreadPoolManager.addTask(this, false);
                this.logger.info((Object)("update a polltask success, moId: " + mId + ", moName: " + mName + ", moIP: " + mIP + ", oldIP: " + oldIP), 1L);
                return;
            }
            if (this.pingPollList.contains(pingPoll)) {
                this.logger.info((Object)("find a duplicate polltask, moId: " + mId + ", moName: " + mName + ", moIP: " + mIP), 1L);
                return;
            }
            this.pingPollList.add(pingPoll);
            ThreadPoolManager.addTask(this, false);
            this.logger.info((Object)("add a new polltask success, moId: " + mId + ", moName: " + mName + ", moIP: " + mIP), 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePingPoll(PingPoll pingPoll) {
        Object object = PollPlugin.SLOCK;
        synchronized (object) {
            long moId = pingPoll.getMoId();
            String moIP = pingPoll.getMoIP();
            String moName = pingPoll.getMoName();
            PingPoll oldPoll = this.getPingPoll(moId);
            if (null != oldPoll && !oldPoll.getMoIP().equals(moIP)) {
                String oldIP = oldPoll.getMoIP();
                oldPoll.setMoIP(moIP);
                ThreadPoolManager.addTask(this, false);
                this.logger.info((Object)("update a polltask success, moId: " + moId + ", moName: " + moName + ", moIP: " + moIP + ", oldIP: " + oldIP), 1L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePingPoll(long moId) {
        Object object = PollPlugin.SLOCK;
        synchronized (object) {
            boolean flag = false;
            Iterator<PingPoll> itor = this.pingPollList.iterator();
            while (itor.hasNext()) {
                PingPoll poll = itor.next();
                if (poll.getMoId() != moId) continue;
                itor.remove();
                flag = true;
                this.logger.info((Object)("delete a polltask success, moId: " + moId + ", moName: " + poll.getMoName()), 1L);
            }
            if (flag) {
                ThreadPoolManager.addTask(this, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PingPoll getPingPoll(long moId) {
        Object object = PollPlugin.SLOCK;
        synchronized (object) {
            for (PingPoll poll : this.pingPollList) {
                if (moId != poll.getMoId()) continue;
                return poll;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = PollPlugin.SLOCK;
        synchronized (object) {
            return this.pingPollList.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSpace() {
        Object object = PollPlugin.SLOCK;
        synchronized (object) {
            return this.pingPollList.size() < PollPlugin.getInstance().getBatchCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.lock;
        synchronized (object) {
            try {
                if ((System.currentTimeMillis() - this.lastExcuteTime) / 1000L >= PollPlugin.getInstance().getInterval()) {
                    this.lastExcuteTime = System.currentTimeMillis();
                    this.doPingTask();
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("Throwable occured when ping " + this.getIpList() + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
        }
    }

    private void doPingTask() {
        try {
            if (!this.pingPollList.isEmpty()) {
                ArrayList<String> ipList = new ArrayList<String>();
                ArrayList<PingPoll> tmpList = new ArrayList<PingPoll>();
                for (PingPoll pingPoll : this.pingPollList) {
                    tmpList.add(pingPoll);
                    ipList.add(pingPoll.getMoIP());
                }
                Boolean[] results = PollPlugin.getInstance().getPingService().batchPing(ipList, PollPlugin.getInstance().getRetries(), PollPlugin.getInstance().getTimeout());
                this.dealWithPingPollResult(results, tmpList);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Exception occured when ping " + this.getIpList() + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
    }

    private void dealWithPingPollResult(Boolean[] results, List<PingPoll> tmpList) {
        for (int i = 0; i < results.length; ++i) {
            PingPoll pingPoll = tmpList.get(i);
            if (results[i].booleanValue()) {
                pingPoll.sendOnLineMsg();
                continue;
            }
            pingPoll.sendOffLineMsg();
        }
    }

    private String getIpList() {
        StringBuffer buf = new StringBuffer();
        for (PingPoll pingPoll : this.pingPollList) {
            buf.append(pingPoll.getMoIP());
            buf.append(',');
        }
        return buf.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        if (!(obj instanceof PollTask)) {
            return false;
        }
        PollTask other = (PollTask)obj;
        return other.getTimeStamp() == this.getTimeStamp();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(super.getTimeStamp() ^ super.getTimeStamp() >>> 32);
        return result;
    }
}

