/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.mediation.synchronize;

import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.Node;
import com.huawei.lego.cbb.resource.sdk.service.IResourceService;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.base.thread.CommonThread;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.domain.context.ModelContext;
import com.huawei.lego.core.domain.context.ModelServiceMapping;
import com.huawei.lego.core.domain.context.ProductContext;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.domain.IDomainContainer;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.mediation.synchronize.AbstractSynchronizer;
import com.huawei.lego.core.sdk.mediation.synchronize.ISynchronizer;
import com.huawei.lego.core.sdk.mediation.synchronize.model.XmlSynchronizeContext;
import com.huawei.lego.core.sdk.mediation.synchronize.snmp.AbstractSnmpSynchronizer;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.discover.sdk.service.IDiscoveryService;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.springframework.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SynchronizeManager {
    private static final Log LOGGER = LogFactory.getInstance(SynchronizeManager.class);
    private static final int VALUE_1000 = 1000;
    private static final int VALUE_12000 = 12000;
    private static final int VALUE_10 = 10;
    private static final int VALUE_60 = 60;
    private Map<String, XmlSynchronizeContext> mappings;
    private XmlSynchronizeContext xmlSynchronizeContext;
    private ModelXMLHandler xmlHandler;
    private IMessageCenter messageCenter;

    public IMessageCenter getMessageCenter() {
        return this.messageCenter;
    }

    public void setMessageCenter(IMessageCenter messageCenter) {
        this.messageCenter = messageCenter;
    }

    public Map<String, XmlSynchronizeContext> getMappings() {
        return this.mappings;
    }

    public boolean initializer(IDomainContainer container) {
        this.xmlHandler = new ModelXMLHandler();
        this.mappings = new HashMap<String, XmlSynchronizeContext>();
        return this.initializerFromDomain(container);
    }

    private boolean initializerFromDomain(IDomainContainer container) {
        Map productMapping = container.getProductMappings();
        for (Map.Entry entry : productMapping.entrySet()) {
            String productId = (String)entry.getKey();
            ProductContext productContext = (ProductContext)entry.getValue();
            LOGGER.info((Object)("productId is : " + productId), 1L);
            LOGGER.info((Object)("productContext is : " + productContext), 1L);
            Map<String, ModelServiceMapping> modelServices = productContext.getpModelMappings();
            if (null != modelServices && !modelServices.isEmpty()) {
                LOGGER.info((Object)("modelServices is : " + modelServices), 1L);
                this.dealIndexForModelServices(modelServices, productId, productContext);
                continue;
            }
            LOGGER.info((Object)"modelServices is : null or empty", 1L);
        }
        return true;
    }

    private void dealIndexForModelServices(Map<String, ModelServiceMapping> modelServices, String productId, ProductContext productContext) {
        for (Map.Entry<String, ModelServiceMapping> modelServiceEntry : modelServices.entrySet()) {
            ModelContext modelCtx;
            ModelServiceMapping modelService = modelServiceEntry.getValue();
            if (null == modelService || null == (modelCtx = modelService.getModelCtx())) continue;
            String index = modelCtx.getIndex();
            this.dealIndex(index, modelCtx, productId, productContext);
        }
    }

    private void dealIndex(String index, ModelContext modelCtx, String productId, ProductContext productContext) {
        if ("1".equals(index)) {
            LOGGER.info((Object)"@@@@@@@@@@@@@@@@@@@@@@@@", 1L);
            this.xmlSynchronizeContext = new XmlSynchronizeContext();
            this.xmlSynchronizeContext.setProductId(productId);
            this.xmlSynchronizeContext.setModelId(modelCtx.getId());
            this.xmlSynchronizeContext.setType(modelCtx.getMoType());
            this.xmlSynchronizeContext.setSubType(modelCtx.getSubType());
            this.xmlSynchronizeContext.setMo(modelCtx.getMoClass());
            this.xmlSynchronizeContext.setTopMo(true);
            this.xmlSynchronizeContext.setReferredOid(modelCtx.getReferredOid());
            this.xmlSynchronizeContext.setReferingOid(modelCtx.getReferingOid());
            this.xmlSynchronizeContext.setIsPolling("true".equalsIgnoreCase(modelCtx.getIsPolling()));
            String topMoClazzName = this.xmlSynchronizeContext.getMoClass().getName();
            boolean isPolling = this.xmlSynchronizeContext.isPolling();
            try {
                ClassLoader cl = this.getClass().getClassLoader();
                if (cl != null) {
                    URL url = null;
                    url = modelCtx.getDefinition().startsWith("/") ? cl.getResource(modelCtx.getDefinition().substring(1)) : cl.getResource(modelCtx.getDefinition());
                    if (null != url) {
                        this.xmlHandler.parser(url.openStream());
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"read model definition error!", (Throwable)e, 1L);
            }
            Map sysOidXmlSynchronizeContextMap = this.xmlSynchronizeContext.getSysOidXmlSynchronizeContextMap();
            if (null != sysOidXmlSynchronizeContextMap) {
                LOGGER.info((Object)("@@@@@@@@@@@@@ sysOidXmlSynchronizeContextMap is : " + sysOidXmlSynchronizeContextMap), 1L);
                this.mappings.putAll(sysOidXmlSynchronizeContextMap);
            } else {
                LOGGER.info((Object)"@@@@@@@@@@@@@ sysOidXmlSynchronizeContextMap is : null", 1L);
            }
            List<ModelContext> subModels = modelCtx.getSubModel();
            if (!subModels.isEmpty()) {
                XmlSynchronizeContext parent = this.xmlSynchronizeContext;
                for (ModelContext subModel : subModels) {
                    this.addModelChild(productId, subModel, parent);
                }
            }
            if (isPolling) {
                this.devicePolling(productContext.getPollingInterval(), topMoClazzName, productId);
            }
        }
    }

    private void devicePolling(String pollingInterval, String topMoClazzName, String productId) {
        LOGGER.info((Object)("pollingInterval is : " + pollingInterval + ", productId is : " + productId), 1L);
        if (StringUtils.hasText((String)pollingInterval)) {
            long interval = -1L;
            try {
                interval = Long.parseLong(pollingInterval);
                if (interval <= 0L) {
                    throw new NumberFormatException();
                }
                interval *= 1000L;
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)("exception when parse pollingInterval, pollingInterval is : " + pollingInterval + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
            if (interval != -1L) {
                DevicePollingThread devicePollingThread = new DevicePollingThread(interval, topMoClazzName);
                devicePollingThread.setThreadName("DevicePollingThread_" + productId);
                ExecutionService.submitTask(devicePollingThread);
            }
        }
    }

    private void addModelChild(String productId, ModelContext modelCtx, XmlSynchronizeContext parent) {
        XmlSynchronizeContext child = new XmlSynchronizeContext();
        child.setProductId(productId);
        child.setModelId(modelCtx.getId());
        child.setType(modelCtx.getMoType());
        child.setSubType(modelCtx.getSubType());
        child.setMo(modelCtx.getMoClass());
        child.setReferredOid(modelCtx.getReferredOid());
        child.setReferingOid(modelCtx.getReferingOid());
        child.setIsPolling("true".equalsIgnoreCase(modelCtx.getIsPolling()));
        try {
            URL url;
            this.xmlSynchronizeContext = child;
            ClassLoader cl = this.getClass().getClassLoader();
            if (cl != null && null != (url = cl.getResource(modelCtx.getDefinition()))) {
                this.xmlHandler.parser(url.openStream());
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("read model definition error!" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        List<ModelContext> subModels = modelCtx.getSubModel();
        if (!subModels.isEmpty()) {
            for (ModelContext subModel : subModels) {
                this.addModelChild(productId, subModel, child);
            }
        }
        parent.addChild(child);
    }

    class ModelXMLHandler
    extends DefaultHandler {
        ModelXMLHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("model".equals(qName)) {
                SynchronizeManager.this.xmlSynchronizeContext.setSysOids(attributes.getValue("sysoid"));
            } else if ("fields".equals(qName)) {
                SynchronizeManager.this.xmlSynchronizeContext.setSynchronizer(attributes.getValue("handler"));
                if (SynchronizeManager.this.xmlSynchronizeContext.getSynchronizer() instanceof AbstractSynchronizer) {
                    ((AbstractSynchronizer)SynchronizeManager.this.xmlSynchronizeContext.getSynchronizer()).setNeSyncMapping(SynchronizeManager.this.xmlSynchronizeContext);
                }
            } else if ("attribute".equals(qName)) {
                Map sysOidXmlSynchronizeContextMap = SynchronizeManager.this.xmlSynchronizeContext.getSysOidXmlSynchronizeContextMap();
                this.startElementAttribute(attributes, sysOidXmlSynchronizeContextMap);
            } else {
                ISynchronizer syncHander = SynchronizeManager.this.xmlSynchronizeContext.getSynchronizer();
                if (syncHander instanceof AbstractSnmpSynchronizer) {
                    ((AbstractSnmpSynchronizer)syncHander).parser(qName, attributes);
                }
            }
        }

        private void startElementAttribute(Attributes attributes, Map<String, XmlSynchronizeContext> sysOidXmlSynchronizeContextMap) {
            String sysoid;
            if (sysOidXmlSynchronizeContextMap == null) {
                sysOidXmlSynchronizeContextMap = new HashMap<String, XmlSynchronizeContext>();
                SynchronizeManager.this.xmlSynchronizeContext.setSysOidXmlSynchronizeContextMap(sysOidXmlSynchronizeContextMap);
            }
            if ((sysoid = attributes.getValue("sysoid")) != null && !sysoid.trim().equals("")) {
                sysOidXmlSynchronizeContextMap.put(sysoid.trim(), SynchronizeManager.this.xmlSynchronizeContext);
            }
        }

        public void parser(InputStream is) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            try {
                CommonUtil.setSecurityFeatures((SAXParserFactory)factory);
                SAXParser parser = factory.newSAXParser();
                parser.parse(is, (DefaultHandler)this);
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                LOGGER.error((Object)"parse faile!", (Throwable)e, 1L);
            }
        }
    }

    class DevicePollingThread
    extends CommonThread {
        private long pollingInterval;
        private IResourceService resourceService;
        private IDiscoveryService discoveryService;
        private String topMoClazzName;

        public DevicePollingThread(long pollingInterval, String topMoClazzName) {
            this.pollingInterval = pollingInterval;
            this.topMoClazzName = topMoClazzName;
        }

        @Override
        public void execute() {
            CommonUtil.sleep((long)600000L);
            boolean shouldContinue = true;
            while (shouldContinue) {
                shouldContinue = this.dealMoList();
            }
        }

        private boolean dealMoList() {
            try {
                CommonUtil.sleep((long)this.pollingInterval);
                ServiceContext context = ServiceContext.getInstance();
                if (this.resourceService == null) {
                    this.resourceService = (IResourceService)context.lookup("ResourceApplication/ResourceServiceImpl");
                }
                if (this.resourceService == null) {
                    LOGGER.error((Object)"resourceService is : null", 1L);
                    return false;
                }
                if (this.discoveryService == null) {
                    this.discoveryService = (IDiscoveryService)context.lookup("discover/DiscoveryServiceImpl");
                }
                if (this.discoveryService == null) {
                    LOGGER.error((Object)"discoveryService is : null", 1L);
                    return false;
                }
                List moList = this.resourceService.getMoByType(this.topMoClazzName);
                if (moList == null) {
                    return true;
                }
                this.dealMoList(moList);
            }
            catch (Exception e) {
                LOGGER.error((Object)("exception when polling device" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
            return true;
        }

        private void dealMoList(List<ManagedObject> moList) throws InterruptedException {
            for (ManagedObject mo : moList) {
                if (!(mo instanceof Node)) continue;
                Node node = (Node)mo;
                HashMap<String, Object> messageBody = new HashMap<String, Object>();
                messageBody.put("snmpDiscoveredNode", node);
                messageBody.put("isDevicePolling", "true");
                LOGGER.info((Object)"messageBody from timely", 1L);
                if (this.dealTmpMo(mo, messageBody)) continue;
                CommonUtil.sleep((long)12000L);
            }
        }

        private boolean dealTmpMo(ManagedObject mo, Map<String, Object> messageBody) {
            boolean isContinue = false;
            if (this.discoveryService.isDeviceCanRefresh(mo.getMoId())) {
                ManagedObject tempMo = this.resourceService.getMoByUuid(mo.getUuid(), null);
                if (tempMo != null) {
                    MessageUnit mu = new MessageUnit();
                    mu.setCmdcode(101L);
                    mu.setObj(messageBody);
                    mu.setMt(MessageTopic.COMMAND);
                    mu.setSourceAppName(this.getClass().getName());
                    SynchronizeManager.this.messageCenter.sendMessage(mu);
                } else {
                    LOGGER.info((Object)("the device does not exist, uuid is : " + mo.getUuid() + ", moid is : " + mo.getMoId()), 1L);
                    isContinue = true;
                }
            } else {
                LOGGER.info((Object)("the device is deleting, uuid is : " + mo.getUuid() + ", moid is : " + mo.getMoId()), 1L);
                isContinue = true;
            }
            return isContinue;
        }
    }
}

