/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.mediation.synchronize;

import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.backtask.sdk.service.IBackTaskService;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.Node;
import com.huawei.lego.cbb.resource.sdk.service.ICommonService;
import com.huawei.lego.cbb.resource.sdk.service.IDeviceTypeMgr;
import com.huawei.lego.cbb.resource.sdk.service.IResourceService;
import com.huawei.lego.com.south.sdk.model.Protocol;
import com.huawei.lego.com.south.sdk.model.SnmpPara;
import com.huawei.lego.com.south.sdk.model.TelnetPara;
import com.huawei.lego.core.domain.impl.CacheServiceProvider;
import com.huawei.lego.core.mediation.IPlugin;
import com.huawei.lego.core.mediation.model.SynchronizeMOResult;
import com.huawei.lego.core.mediation.synchronize.SynchronizeManager;
import com.huawei.lego.core.mediation.synchronize.SynchronizeWorker;
import com.huawei.lego.core.sdk.base.ICacheService;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.base.event.ServiceStatusChangedListener;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.common.ServiceProvider;
import com.huawei.lego.core.sdk.domain.IDomainContainer;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.mediation.synchronize.model.XmlSynchronizeContext;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryResult;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class SynchronizePlugin
implements IPlugin,
ServiceStatusChangedListener {
    private static Log logger = LogFactory.getInstance(SynchronizePlugin.class);
    private static IResourceService sResourceService = null;
    private static final int MAX_RETRY = 50;
    private static final int SLEEP_TIME = 500;
    private static final int VALUE_3000 = 3000;
    private static final String DOMAIN_NAME = "DomainApplicaton/DomainContainer";
    private IDomainContainer domainContainer;
    private SynchronizeManager manager;
    private IDeviceTypeMgr deviceTypeManager;

    public IDeviceTypeMgr getDeviceTypeManager() {
        return this.deviceTypeManager;
    }

    public void setDeviceTypeManager(IDeviceTypeMgr deviceTypeManager) {
        this.deviceTypeManager = deviceTypeManager;
    }

    public void setManager(SynchronizeManager manager) {
        this.manager = manager;
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() != Status.STATUS_STARTED) {
            return;
        }
        if (event.getEventTarget() instanceof IDomainContainer) {
            this.initDomainModel();
        }
        if (event.getEventTarget() instanceof ICommonService) {
            logger.info((Object)"will setStatusOfExceptionTerminatedDiscoveryPolicy...", 1L);
            this.setStatusOfExceptionTerminatedDiscoveryPolicy();
        }
    }

    private void setStatusOfExceptionTerminatedDiscoveryPolicy() {
        String sql = "update T_discoverypolicy set exception_terminated = true, finished = true where finished = false";
        ServiceContext context = ServiceContext.getInstance();
        try {
            CommonUtil.sleep((long)3000L);
            ICommonService commonService = (ICommonService)context.lookup("ResourceApplication/CommonServiceImpl");
            commonService.updateBySql(sql);
        }
        catch (Throwable e) {
            logger.error((Object)("rmi service ResourceApplication/CommonServiceImpl is not available currently" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
    }

    @Override
    public void init() {
        logger.trace((Object)"init");
    }

    private void initDomainModel() {
        logger.info((Object)"@@@@@@@@@@@@@@@@@@@@@@@\uff1atest step1", 1L);
        boolean success = false;
        for (int i = 0; i < 50; ++i) {
            CommonUtil.sleep((long)500L);
            try {
                this.domainContainer = (IDomainContainer)ServiceContext.getInstance().lookup(DOMAIN_NAME);
                if (this.domainContainer == null) {
                    logger.info((Object)("get domain container not successed, will retry, i = " + i), 1L);
                    continue;
                }
                success = true;
                break;
            }
            catch (Exception e) {
                logger.error((Object)("get domain container not successed, trying times : " + i + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
        }
        if (!success) {
            logger.error((Object)"get Domain/DomainContainer service error! Can't start ne sync manager.", 1L);
            return;
        }
        logger.info((Object)"successed to init domain model", 1L);
        logger.info((Object)("@@@@@@@@@@@@@@@@@@@@@@@\uff1acontent of container is :" + this.domainContainer.getProductMappings()), 1L);
        this.initManager();
    }

    private void initManager() {
        if (this.manager.initializer(this.domainContainer)) {
            logger.info((Object)"NE Sync Plugin init ok!", 1L);
        } else {
            logger.error((Object)"NE Sync Plugin init error! Can't start ne sync.", 1L);
        }
    }

    @Override
    public void destroy() {
        logger.info((Object)"NE Sync Plugin destroy ok!", 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Map<String, Object> messageBody) {
        DiscoveryResult discoveryResult = new DiscoveryResult();
        SynchronizeMOResult synchronizeMOResult = new SynchronizeMOResult();
        try {
            logger.info((Object)"message is received", 1L);
            Node discoveredNode = (Node)messageBody.get("snmpDiscoveredNode");
            if (discoveredNode == null) {
                discoveredNode = (Node)messageBody.get("icmpDiscoveredNode");
            }
            if (null != discoveredNode) {
                logger.debug((Object)("manager.getMappings() is : " + this.manager.getMappings()), 1L);
                logger.debug((Object)("discoveredNode.getSysOid() is : " + discoveredNode.getSysOid()), 1L);
                XmlSynchronizeContext xmlSynchronizeContext = this.manager.getMappings().get(discoveredNode.getSysOid());
                logger.debug((Object)("xmlSynchronizeContext is : " + xmlSynchronizeContext), 1L);
                this.dealContect(xmlSynchronizeContext, messageBody, discoveryResult, discoveredNode, synchronizeMOResult);
            } else {
                logger.error((Object)"discoveredNode is null!!!", 1L);
            }
        }
        catch (Throwable e) {
            logger.error((Object)("exception when in SynchronizePlugin" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            DiscoveryPolicy policy = (DiscoveryPolicy)messageBody.get("discoveryPolicy");
            this.extractComplexity(messageBody, discoveryResult, e, policy);
        }
        finally {
            try {
                this.completeDiscoverTask(messageBody, discoveryResult, synchronizeMOResult);
            }
            catch (Exception e) {
                logger.error((Object)("error complete task, exception: " + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
        }
    }

    private void completeDiscoverTask(Map<String, Object> messageBody, DiscoveryResult discoveryResult, SynchronizeMOResult synchronizeMOResult) {
        DiscoveryPolicy policy = (DiscoveryPolicy)messageBody.get("discoveryPolicy");
        logger.info((Object)"a task is completedddddd", 1L);
        if (policy != null) {
            String uuidForPerDiscovery = policy.getUuidForPerDiscovery();
            if (null == uuidForPerDiscovery && !discoveryResult.getSuccess().booleanValue()) {
                ServiceProvider.getDiscoveryService().updateDiscoveryResultAndPolicy(discoveryResult, true);
            } else {
                ICommonService commonService = ServiceProvider.getCommonService();
                String sql = "select dp.discovery_policy_id from T_discoverypolicy dp where dp.uuid_for_per_discovery = '" + uuidForPerDiscovery + "'";
                List list = commonService.findBySql(sql);
                this.extractNullcheck(discoveryResult, list);
            }
            logger.info((Object)("discoveryResult.getSuccess() is: " + discoveryResult.getSuccess() + ";synchronizeMOResult.getCount()= " + synchronizeMOResult.getCount()), 1L);
            this.increaseCount(discoveryResult, synchronizeMOResult, policy);
            this.updateBackTaskProgress(policy);
        } else {
            logger.warn((Object)"pppppppppolicy is null", 1L);
        }
    }

    private void updateBackTaskProgress(DiscoveryPolicy policy) {
        Object object = policy.getExtendAttributeMap().get("discoveryTask");
        BackTask backTask = (BackTask)object;
        if (null == backTask) {
            logger.error((Object)"backtask is null.");
            return;
        }
        IBackTaskService backTaskService = this.getBackTaskService();
        backTaskService.updateTask(backTask.getTaskId().longValue(), 99);
    }

    private IBackTaskService getBackTaskService() {
        ServiceContext context = ServiceContext.getInstance();
        IBackTaskService backTaskService = (IBackTaskService)context.lookup("task/backTask");
        logger.trace((Object)"get BackTaskService");
        return backTaskService;
    }

    private void increaseCount(DiscoveryResult discoveryResult, SynchronizeMOResult synchronizeMOResult, DiscoveryPolicy policy) {
        if (discoveryResult.getSuccess().booleanValue()) {
            logger.trace((Object)("increaseCount:DiscoveryResult is " + discoveryResult.getSuccess()));
            if (synchronizeMOResult.getCount() > 0) {
                SynchronizePlugin.increaseDiscoveryCount(policy, synchronizeMOResult.getCount());
            } else {
                SynchronizePlugin.increaseDiscoveryCount(policy);
            }
        } else if (synchronizeMOResult.getCount() > 0) {
            SynchronizePlugin.increaseDiscoveryCount(policy, synchronizeMOResult.getCount());
        }
    }

    private void extractNullcheck(DiscoveryResult discoveryResult, List<?> list) {
        if (list != null && !list.isEmpty()) {
            logger.trace((Object)"extractNullcheck:list is not null");
            ServiceProvider.getDiscoveryService().updateDiscoveryResultAndPolicy(discoveryResult, true);
        }
    }

    private void extractComplexity(Map<String, Object> messageBody, DiscoveryResult discoveryResult, Throwable e, DiscoveryPolicy policy) {
        if (policy != null) {
            discoveryResult.setDiscoveryPolicy(policy);
            if (e instanceof LegoCheckedException) {
                LegoCheckedException legoException = (LegoCheckedException)e;
                discoveryResult.setErrorCode(Long.valueOf(legoException.getErrorCode()));
                if (null != legoException.getParameters() && 0 != legoException.getParameters().length) {
                    String[] errorparam = legoException.getParameters();
                    discoveryResult.setErrorParam(this.dealErrorParam(errorparam));
                }
            } else if (e instanceof LegoUncheckedException) {
                discoveryResult.setErrorCode(Long.valueOf(((LegoUncheckedException)e).getErrorCode()));
            } else {
                discoveryResult.setErrorCode(Long.valueOf(1053L));
            }
            discoveryResult.setFinishTime(new Timestamp(System.currentTimeMillis()));
            Node discoveredNode = (Node)messageBody.get("snmpDiscoveredNode");
            if (discoveredNode == null) {
                discoveredNode = (Node)messageBody.get("icmpDiscoveredNode");
            }
            if (discoveredNode == null) {
                logger.error((Object)"discoveredNode is null!!!!!!", 1L);
            }
            if (null != discoveredNode) {
                discoveryResult.setIpAddress(discoveredNode.getIpAddress());
            }
            discoveryResult.setSuccess(Boolean.valueOf(false));
        }
    }

    private void dealContect(XmlSynchronizeContext xmlSynchronizeContext, Map<String, Object> messageBody, DiscoveryResult discoveryResult, Node discoveredNode, SynchronizeMOResult synchronizeMOResult) {
        if (xmlSynchronizeContext == null) {
            this.xmlSynchronizeContextNull(messageBody, discoveryResult, discoveredNode);
        } else {
            String key;
            ICacheService<String, Object> cacheService;
            Long finishedIpCount;
            DiscoveryPolicy policy = (DiscoveryPolicy)messageBody.get("discoveryPolicy");
            if (policy != null && (finishedIpCount = (Long)(cacheService = CacheServiceProvider.getInstance().getCacheService()).get((Object)(key = "discoveryPolicyId_" + policy.getDiscoveryPolicyId()))) == null) {
                logger.info((Object)("discovery policy stopped and will not synchronize data, policy is : " + policy), 1L);
                return;
            }
            String refreshOperationUuid = (String)messageBody.get("refreshOperationUuid");
            logger.info((Object)("refreshOperationUuid is : " + refreshOperationUuid), 1L);
            SynchronizeWorker worker = new SynchronizeWorker(xmlSynchronizeContext, discoveredNode, this.domainContainer, policy, refreshOperationUuid);
            logger.info((Object)"a task is added", 1L);
            if (policy != null && policy.getManualStopped().booleanValue()) {
                logger.info((Object)("the policy has been stopped!!! node ip is : " + discoveredNode.getIpAddress() + ", policy is : " + policy), 1L);
                throw new LegoUncheckedException(1058L);
            }
            this.extractMethod(discoveryResult, synchronizeMOResult, discoveredNode, xmlSynchronizeContext, policy, worker);
        }
    }

    private String dealErrorParam(String[] errorparam) {
        StringBuffer sbf = new StringBuffer();
        for (int i = 0; i < errorparam.length - 1; ++i) {
            sbf.append(errorparam[i]);
            sbf.append(",");
        }
        sbf.append(errorparam[errorparam.length - 1]);
        logger.trace((Object)"dealErrorParam");
        return sbf.toString();
    }

    private void extractMethod(DiscoveryResult discoveryResult, SynchronizeMOResult synchronizeMOResult, Node discoveredNode, XmlSynchronizeContext xmlSynchronizeContext, DiscoveryPolicy policy, SynchronizeWorker worker) {
        worker.doSynchronizeWork(synchronizeMOResult);
        logger.debug((Object)("a task is finished, task is :\u3000" + worker), 1L);
        discoveryResult.setDiscoveryPolicy(policy);
        discoveryResult.setFinishTime(new Timestamp(System.currentTimeMillis()));
        discoveryResult.setIpAddress(discoveredNode.getIpAddress());
        if (policy != null && policy.getExtendProductAttributeMap() != null && policy.getExtendProductAttributeMap().containsKey("vendar")) {
            discoveryResult.setDeviceMainTypeI18n(policy.getDeviceType());
            discoveryResult.setDeviceSubTypeI18n(policy.getDeviceSubType());
        } else {
            discoveryResult.setDeviceMainTypeI18n(xmlSynchronizeContext.getType());
            discoveryResult.setDeviceSubTypeI18n(xmlSynchronizeContext.getSubType());
        }
        discoveryResult.setSuccess(Boolean.valueOf(true));
    }

    private void xmlSynchronizeContextNull(Map<String, Object> messageBody, DiscoveryResult discoveryResult, Node discoveredNode) {
        logger.warn((Object)("!!!!!!!!xmlSynchronizeContext is : null, sys oid is : " + discoveredNode.getSysOid()), 1L);
        DiscoveryPolicy policy = (DiscoveryPolicy)messageBody.get("discoveryPolicy");
        if (policy != null) {
            Node node = new Node();
            node.setSysOid(discoveredNode.getIpAddress());
            node.setUuid(discoveredNode.getIpAddress());
            node.setName(discoveredNode.getIpAddress());
            node.setDiscoveredTime(new Timestamp(System.currentTimeMillis()));
            node.setIpAddress(discoveredNode.getIpAddress());
            node.setMainType(policy.getDeviceType());
            String subType = policy.getDeviceSubType();
            if (subType == null || subType.equals("")) {
                node.setSubType(policy.getDeviceType());
            } else {
                node.setSubType(subType);
            }
            node.setLocation(policy.getLocation());
            node.setIsTopMo(Boolean.valueOf(true));
            SnmpPara snmpPara = policy.getSnmpPara();
            snmpPara.setTemplateName(UUID.randomUUID().toString());
            snmpPara.setDiscoveryPolicy(null);
            snmpPara.setId(null);
            snmpPara.setIsTemplate(Boolean.valueOf(false));
            snmpPara.setIsManagementProtocol(Boolean.valueOf(true));
            snmpPara.setNode(node);
            node.addManagementProtocol(SnmpPara.class.getName(), (Protocol)snmpPara);
            TelnetPara telnetPara = policy.getTelnetPara();
            if (telnetPara != null) {
                telnetPara.setTemplateName(UUID.randomUUID().toString());
                telnetPara.setDiscoveryPolicy(null);
                telnetPara.setId(null);
                telnetPara.setIsTemplate(Boolean.valueOf(false));
                telnetPara.setIsManagementProtocol(Boolean.valueOf(true));
                telnetPara.setNode(node);
                node.addManagementProtocol(TelnetPara.class.getName(), (Protocol)telnetPara);
            }
            this.handleSnmp(discoveryResult, discoveredNode, policy, node);
        }
    }

    private void handleSnmp(DiscoveryResult discoveryResult, Node discoveredNode, DiscoveryPolicy policy, Node node) {
        if (policy.getDiscoveryNonSnmpDevice().booleanValue()) {
            node.setMainType("lego.dic.discoverypolicy.thirdPartyDevice");
            node.setSubType("lego.dic.discoverypolicy.thirdPartyDevice");
            node.setTopoElementId(policy.getTopoElementId());
            ServiceProvider.getResourceService().addMoAndSubMo((ManagedObject)node);
            discoveryResult.setDiscoveryPolicy(policy);
            discoveryResult.setFinishTime(new Timestamp(System.currentTimeMillis()));
            discoveryResult.setIpAddress(discoveredNode.getIpAddress());
            discoveryResult.setSuccess(Boolean.valueOf(true));
            discoveryResult.setDeviceMainTypeI18n("lego.dic.discoverypolicy.thirdPartyDevice");
            discoveryResult.setDeviceSubTypeI18n("lego.dic.discoverypolicy.thirdPartyDevice");
        } else {
            discoveryResult.setDiscoveryPolicy(policy);
            discoveryResult.setFinishTime(new Timestamp(System.currentTimeMillis()));
            discoveryResult.setIpAddress(discoveredNode.getIpAddress());
            discoveryResult.setSuccess(Boolean.valueOf(false));
            discoveryResult.setErrorCode(Long.valueOf(1057L));
        }
    }

    private static synchronized void increaseDiscoveryCount(DiscoveryPolicy policy) {
        if (sResourceService == null) {
            sResourceService = (IResourceService)ServiceContext.getInstance().lookup("ResourceApplication/ResourceServiceImpl");
        }
        if (sResourceService == null) {
            logger.error((Object)"can not get resource service, service name is : ResourceApplication/ResourceServiceImpl", 1L);
        } else {
            StringBuilder sql = new StringBuilder();
            sql.append("update T_discoverypolicy set discovered_device_count = discovered_device_count + 1 ");
            sql.append(" where uuid_for_per_discovery = ?");
            Object[] param = new Object[]{policy.getUuidForPerDiscovery()};
            sResourceService.updateBySql(sql.toString(), param);
        }
    }

    private static synchronized void increaseDiscoveryCount(DiscoveryPolicy policy, int increment) {
        if (sResourceService == null) {
            sResourceService = (IResourceService)ServiceContext.getInstance().lookup("ResourceApplication/ResourceServiceImpl");
        }
        if (sResourceService == null) {
            logger.error((Object)"can not get resource service, service name is : ResourceApplication/ResourceServiceImpl", 1L);
        } else {
            StringBuilder sql = new StringBuilder();
            sql.append("update T_discoverypolicy set discovered_device_count = discovered_device_count + " + increment);
            sql.append(" where uuid_for_per_discovery = ?");
            Object[] param = new Object[]{policy.getUuidForPerDiscovery()};
            sResourceService.updateBySql(sql.toString(), param);
        }
    }
}

