/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.mediation.synchronize;

import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.Node;
import com.huawei.lego.core.mediation.model.SynchronizeMOResult;
import com.huawei.lego.core.sdk.domain.IDomainContainer;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.mediation.synchronize.ISynchronizer;
import com.huawei.lego.core.sdk.mediation.synchronize.model.MoListOrMap;
import com.huawei.lego.core.sdk.mediation.synchronize.model.SynchronizeParameter;
import com.huawei.lego.core.sdk.mediation.synchronize.model.XmlSynchronizeContext;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import java.util.List;

public class SynchronizeWorker {
    private static final Log LOGGER = LogFactory.getInstance(SynchronizeWorker.class);
    private IDomainContainer container = null;
    private XmlSynchronizeContext xmlSynchronizeContext = null;
    private Node discoveredNode = null;
    private ManagedObject topMo = null;
    private DiscoveryPolicy discoveryPolicy = null;
    private String refreshOperationUuid = null;

    public SynchronizeWorker(XmlSynchronizeContext xmlSynchronizeContext, Node discoveredNode, IDomainContainer container, DiscoveryPolicy discoveryPolicy, String refreshOperationUuid) {
        this.xmlSynchronizeContext = xmlSynchronizeContext;
        this.discoveredNode = discoveredNode;
        this.container = container;
        this.discoveryPolicy = discoveryPolicy;
        this.refreshOperationUuid = refreshOperationUuid;
    }

    public void doSynchronizeWork(SynchronizeMOResult synchronizeMOResult) {
        LOGGER.info((Object)"a task is begin to run");
        try {
            this.process(this.xmlSynchronizeContext, this.discoveredNode, null, synchronizeMOResult);
        }
        catch (LegoUncheckedException ex) {
            LOGGER.error((Object)"exception when process synchronizing", (Throwable)ex);
            throw new LegoCheckedException(ex.getErrorCode(), (Throwable)ex);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"exception when process synchronizing", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)("exception when process synchronizing" + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoUncheckedException(1053L, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ManagedObject process(XmlSynchronizeContext xmlSynchronizeCtx, Node discoveredNod, MoListOrMap parentMoListOrMap, SynchronizeMOResult synchronizeMOResult) {
        LOGGER.info((Object)("xxxxxxxxxxmlSynchronizeCtx is : " + xmlSynchronizeCtx + ", parentMoListOrMap is : " + parentMoListOrMap));
        ISynchronizer synchronizer = xmlSynchronizeCtx.getSynchronizer();
        String[] disParam = new String[]{discoveredNod.getIpAddress(), discoveredNod.getNetMask()};
        SynchronizeParameter synchronizeParameter = new SynchronizeParameter(disParam, discoveredNod.getManagementProtocolMap(), new String[]{discoveredNod.getSysOid(), discoveredNod.getSysName(), discoveredNod.getSysDescr()}, xmlSynchronizeCtx.getHalfConstructMo(), this.discoveryPolicy, discoveredNod.getLocation());
        if (this.checkSyncCTX(xmlSynchronizeCtx)) {
            MoListOrMap moListOrMap = null;
            try {
                moListOrMap = synchronizer.synchronizeDataAndConstructMo(synchronizeParameter, parentMoListOrMap);
            }
            finally {
                if (synchronizer.getSyncMOCount() > 0) {
                    synchronizeMOResult.setCount(synchronizer.getSyncMOCount());
                }
            }
            LOGGER.info((Object)("111 synchronize result in process method is : " + moListOrMap + ", synchronizer is : " + synchronizer));
            if (this.checkMoMapEmpty(moListOrMap)) {
                LOGGER.warn((Object)("the return topMo of synchronizeDataAndConstructMo is null, mapping is : " + xmlSynchronizeCtx));
                return null;
            }
            this.extracted(xmlSynchronizeCtx, moListOrMap);
            LOGGER.info((Object)"will process none top mo...", 1L);
            this.processNoneTopMo(xmlSynchronizeCtx, discoveredNod, moListOrMap);
            return this.topMo;
        }
        MoListOrMap moListOrMap = synchronizer.synchronizeDataAndConstructMo(synchronizeParameter, parentMoListOrMap);
        LOGGER.info((Object)("222 synchronize result in process method is : " + moListOrMap + ", synchronizer is : " + synchronizer));
        if (this.checkMoMapEmpty(moListOrMap)) {
            LOGGER.warn((Object)("return value of synchronizeDataAndConstructMo is empty, mapping is: " + xmlSynchronizeCtx));
            return null;
        }
        List childMappings = xmlSynchronizeCtx.getChildren();
        if (!childMappings.isEmpty()) {
            for (XmlSynchronizeContext childMapping : childMappings) {
                this.processSubMo(childMapping, moListOrMap);
            }
        }
        return null;
    }

    private boolean checkMoMapEmpty(MoListOrMap moListOrMap) {
        return moListOrMap == null || moListOrMap.isEmpty();
    }

    private boolean checkSyncCTX(XmlSynchronizeContext xmlSynchronizeCtx) {
        return null == xmlSynchronizeCtx.getReferredOid() || xmlSynchronizeCtx.getReferredOid().trim().equals("");
    }

    private void extracted(XmlSynchronizeContext xmlSynchronizeCtx, MoListOrMap moListOrMap) {
        if (xmlSynchronizeCtx.isTopMo()) {
            this.topMo = moListOrMap.getMo();
            this.topMo.setIsTopMo(Boolean.valueOf(true));
            if (this.topMo instanceof Node && this.discoveryPolicy != null) {
                ((Node)this.topMo).setManagementProtocolMap(this.discoveryPolicy.getManagementProtocolMap());
            }
        }
    }

    private void processNoneTopMo(XmlSynchronizeContext xmlSynchronizeCtx, Node discoveredNod, MoListOrMap moListOrMap) {
        LOGGER.info((Object)("inside processNoneTopMo method, xmlSynchronizeCtx is : " + xmlSynchronizeCtx + ", discoveredNod is : " + discoveredNod + ", moListOrMap is : " + moListOrMap), 1L);
        List childMappings = xmlSynchronizeCtx.getChildren();
        LOGGER.info((Object)("childMappings is : " + childMappings), 1L);
        if (!childMappings.isEmpty()) {
            for (XmlSynchronizeContext childMapping : childMappings) {
                LOGGER.info((Object)("childMapping is : " + childMapping), 1L);
                if (xmlSynchronizeCtx.isTopMo()) {
                    LOGGER.info((Object)"will process sub mo of top mo", 1L);
                    this.process(childMapping, discoveredNod, moListOrMap, null);
                    continue;
                }
                LOGGER.info((Object)"will process sub mo of sub mo", 1L);
                this.processSubMo(childMapping, moListOrMap);
            }
            LOGGER.info((Object)("final moListOrMap is : " + moListOrMap), 1L);
        }
    }

    private void processSubMo(XmlSynchronizeContext xmlSynchronizeCtx, MoListOrMap parentMoListOrMap) {
        block6: {
            SynchronizeParameter synchronizeParameter;
            ISynchronizer handler;
            block5: {
                handler = xmlSynchronizeCtx.getSynchronizer();
                String[] disParam = new String[]{this.discoveredNode.getIpAddress(), this.discoveredNode.getNetMask()};
                synchronizeParameter = new SynchronizeParameter(disParam, this.discoveredNode.getManagementProtocolMap(), new String[]{this.discoveredNode.getSysOid(), this.discoveredNode.getSysName(), this.discoveredNode.getSysDescr()}, xmlSynchronizeCtx.getHalfConstructMo(), this.discoveryPolicy, this.discoveredNode.getLocation());
                if (!this.checkSyncCTX(xmlSynchronizeCtx)) break block5;
                MoListOrMap moListOrMap = handler.synchronizeDataAndConstructMo(synchronizeParameter, parentMoListOrMap);
                LOGGER.info((Object)("333 synchronize result in processSubMo method is : " + moListOrMap + ", synchronizer is : " + handler), 1L);
                if (this.checkMoMapEmpty(moListOrMap)) {
                    LOGGER.warn((Object)("return value of synchronizeDataAndConstructMo is empty, mapping is : " + xmlSynchronizeCtx), 1L);
                    return;
                }
                List childMappings = xmlSynchronizeCtx.getChildren();
                if (childMappings.isEmpty()) break block6;
                for (XmlSynchronizeContext childMapping : childMappings) {
                    this.processSubMo(childMapping, moListOrMap);
                }
                break block6;
            }
            MoListOrMap moListOrMap = handler.synchronizeDataAndConstructMo(synchronizeParameter, parentMoListOrMap);
            LOGGER.info((Object)("444 synchronize result in processSubMo method is : " + moListOrMap + ", synchronizer is : " + handler), 1L);
            if (this.checkMoMapEmpty(moListOrMap)) {
                LOGGER.warn((Object)("return value of synchronizeDataAndConstructMo is empty, mapping is : " + xmlSynchronizeCtx), 1L);
                return;
            }
            List childMappings = xmlSynchronizeCtx.getChildren();
            if (!childMappings.isEmpty()) {
                for (XmlSynchronizeContext childMapping : childMappings) {
                    this.processSubMo(childMapping, moListOrMap);
                }
            }
        }
    }

    public String toString() {
        return "SynchronizeTask [container=" + this.container + ", discoveredNode=" + this.discoveredNode + ", discoveryPolicy=" + this.discoveryPolicy + ", topMo=" + this.topMo + ", xmlSynchronizeContext=" + this.xmlSynchronizeContext + ", refreshOperationUuid=" + this.refreshOperationUuid + "]";
    }
}

