/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.system.syslog.service;

import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.base.persistance.dao.ICommonDao;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.comm.Paging;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoExceptionTranslator;
import com.huawei.lego.core.sdk.file.util.FileFactory;
import com.huawei.lego.core.sdk.file.util.FileUtil;
import com.huawei.lego.core.sdk.file.util.FileZip;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoProperties;
import com.huawei.lego.core.sdk.util.TimeUtil;
import com.huawei.lego.core.sdk.util.TryCatchThrowable;
import com.huawei.lego.core.system.syslog.proxy.OperateLogProxy;
import com.huawei.lego.core.system.syslog.sdk.model.OptLogDetailMo;
import com.huawei.lego.core.system.syslog.sdk.model.OptLogMo;
import com.huawei.lego.core.system.syslog.sdk.model.OptLogQCondition;
import com.huawei.lego.core.system.syslog.sdk.model.SysOptLog;
import com.huawei.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.huawei.lego.core.system.syslog.service.AbstractSysOptLog;
import com.huawei.lego.core.system.syslog.service.ConstructHsql;
import com.huawei.lego.core.system.syslog.service.IOperatelogService;
import com.huawei.lego.core.system.syslog.service.ISysOptStorage;
import com.huawei.lego.core.system.syslog.service.TranslateObject;
import java.io.File;
import java.io.IOException;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

@Service(Name="sysLogService", Desc="", Interface=ISysOptLog.class)
public class SysOptLogImpl
extends AbstractSysOptLog
implements SystemStatusChangedListener {
    private static final int VALUE_200 = 200;
    private static final int MAXNUM = 5000;
    private static final int SLEEPTIME = 100;
    private static final int QUEUE_SIZE = 2000;
    private static final long THREAD_PUASE = 2000L;
    private final BlockingQueue<SysOptLog> logQueue = new LinkedBlockingQueue<SysOptLog>(2000);
    private final OperateLogProxy optLogProxy = OperateLogProxy.getInstance();
    private ICommonDao commDao;
    private ISysOptStorage sysOptStorage;
    private Thread reportThread;
    private Log logger = LogFactory.getInstance(SysOptLogImpl.class);

    public ICommonDao getCommDao() {
        return this.commDao;
    }

    public void setCommDao(ICommonDao commDao) {
        this.commDao = commDao;
    }

    public void writeOptLog(SysOptLog oOptLog) {
        OptLogMo oOptLogMo = TranslateObject.translateSysOptLogBo(oOptLog);
        oOptLogMo.setHasDetail(0);
        oOptLogMo.setGmt(TimeUtil.getDefaultTimeZone());
        this.getOptLogDao().writeOptLog(oOptLogMo);
        oOptLog.setId(oOptLogMo.getId().longValue());
        this.logQueue.add(oOptLog);
    }

    public void writeOptLog(SysOptLog oOptLog, byte[] logDetail) {
        OptLogMo oOptLogMo = TranslateObject.translateSysOptLogBo(oOptLog);
        if (logDetail != null) {
            oOptLogMo.setHasDetail(1);
            this.getOptLogDao().writeOptLog(oOptLogMo, logDetail);
        } else {
            oOptLogMo.setHasDetail(0);
            this.getOptLogDao().writeOptLog(oOptLogMo);
        }
        this.logQueue.add(oOptLog);
    }

    public Paging querySysOptLog(OptLogQCondition oQueryCondition, int iStart, int iLength) {
        String sQueryCondition = "";
        StringBuffer sBufQObj = new StringBuffer("FROM OptLogMo ");
        HashMap<Integer, String> params = new HashMap<Integer, String>();
        sQueryCondition = ConstructHsql.constructOptLogQueryHsql(oQueryCondition, params);
        String sSelHql = ConstructHsql.constructSelHql(oQueryCondition, sQueryCondition);
        sBufQObj.append(sSelHql);
        Paging roPaging = new Paging();
        ArrayList<OptLogMo> lstOptLogMo = new ArrayList();
        try {
            lstOptLogMo = this.commDao.findPage(sBufQObj.toString(), iStart, iLength, params);
        }
        catch (Exception e) {
            this.logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
        StringBuffer sBufTotle = new StringBuffer("select count(*) from OptLogMo ");
        sBufTotle.append(sQueryCondition);
        this.logger.info((Object)sBufTotle.toString(), 1L);
        try {
            roPaging.setiCount((int)this.commDao.getTotalCount(sBufTotle.toString(), params));
        }
        catch (Exception e) {
            this.logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
        roPaging.setData(TranslateObject.translateLstSysOptLogMo(lstOptLogMo));
        return roPaging;
    }

    public Paging querySysOptLog(OptLogQCondition oQueryCondition) {
        String sQueryCondition = "";
        StringBuffer sBufQObj = new StringBuffer("FROM OptLogMo ");
        HashMap<Integer, String> params = new HashMap<Integer, String>();
        sQueryCondition = ConstructHsql.constructOptLogQueryHsql(oQueryCondition, params);
        sBufQObj.append(sQueryCondition);
        Paging roPaging = new Paging();
        List<OptLogMo> lstOptLogMo = this.commDao.findByHql(sBufQObj.toString(), params);
        roPaging.setData(TranslateObject.translateLstSysOptLogMo(lstOptLogMo));
        return roPaging;
    }

    public byte[] queryLogDetail(long logId) {
        Blob logDetail;
        byte[] logDetailByte = new byte[]{};
        String sHql = "FROM OptLogDetailMo where logId = " + logId;
        List<?> logDetailList = this.commDao.findByHql(sHql);
        if (logDetailList != null && !logDetailList.isEmpty() && (logDetail = ((OptLogDetailMo)logDetailList.get(0)).getOpLogDetail()) != null) {
            try {
                logDetailByte = logDetail.getBytes(1L, (int)logDetail.length());
            }
            catch (SQLException e) {
                this.logger.error((Object)("SQLException error" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
        }
        return logDetailByte;
    }

    public void deleteSysOptLog(List<OptLogMo> lstOptLogMo) {
        this.commDao.deleteAll(lstOptLogMo);
    }

    public Paging querySysOptLogByStorage(String hql, int iStart, int iLength) {
        String sQueryCondition = "";
        Paging roPaging = new Paging();
        List<Object> lstOptLogMo = new ArrayList();
        try {
            lstOptLogMo = this.commDao.findPage(hql, iStart, iLength);
        }
        catch (Exception e) {
            this.logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
        StringBuffer sBufTotle = new StringBuffer("select count(*) from OptLogMo ");
        sBufTotle.append(sQueryCondition);
        roPaging.setData(lstOptLogMo);
        int iCount = Integer.parseInt(String.valueOf(this.commDao.getBaseHibernateTemplate().find(sBufTotle.toString(), new Object[0]).listIterator().next()));
        roPaging.setiCount(iCount);
        return roPaging;
    }

    public List<String> getLogidByUser(User user) {
        StringBuffer hql = new StringBuffer();
        hql.append("Select t.id FROM OptLogMo t where t.opUser ");
        hql.append(" = ? and t.isOld != 'true'");
        ArrayList<String> list = new ArrayList<String>();
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, user.getUserName());
        Iterator<?> iter = this.commDao.findByHql(hql.toString(), param).iterator();
        while (iter.hasNext()) {
            list.add(iter.next().toString());
        }
        return list;
    }

    public List<SysOptLog> exportSelectedOpLog(String ids) {
        StringBuilder sHql = new StringBuilder("FROM OptLogMo where id in (");
        String[] idArr = ids.split(",");
        HashMap<Integer, String> params = new HashMap<Integer, String>();
        int index = 0;
        for (String id : idArr) {
            if (index != 0) {
                sHql.append(",");
            }
            sHql.append("?");
            params.put(index, id);
            ++index;
        }
        sHql.append(")");
        try {
            List<OptLogMo> oplogs = this.commDao.findByHql(sHql.toString(), params);
            HashMap<String, OptLogMo> optMap = new HashMap<String, OptLogMo>();
            for (OptLogMo optLog : oplogs) {
                optMap.put(optLog.getId().toString(), optLog);
            }
            String[] idArray = ids.split(",");
            oplogs.clear();
            for (String id : idArray) {
                oplogs.add((OptLogMo)optMap.get(id));
            }
            return TranslateObject.translateLstSysOptLogMo(oplogs);
        }
        catch (Exception e) {
            this.logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    public Map<Long, byte[]> exportSelectedOpLogDetail(String ids) {
        HashMap<Long, byte[]> detailMap = new HashMap<Long, byte[]>();
        StringBuilder sHql = new StringBuilder("FROM OptLogDetailMo where logId in (");
        String[] idArr = ids.split(",");
        HashMap<Integer, String> params = new HashMap<Integer, String>();
        int index = 0;
        for (String id : idArr) {
            if (index != 0) {
                sHql.append(",");
            }
            sHql.append("?");
            params.put(index, id);
            ++index;
        }
        sHql.append(")");
        try {
            List<?> oplogDetails = this.commDao.findByHql(sHql.toString(), params);
            for (OptLogDetailMo opLogDetail : oplogDetails) {
                detailMap.put(opLogDetail.getLogId(), opLogDetail.getOpLogDetail().getBytes(1L, (int)opLogDetail.getOpLogDetail().length()));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
        return detailMap;
    }

    private int getCountByHql(long endTime) {
        String strHQL = "select count(*) from OptLogMo where opTime < ?";
        int totalCount = Integer.parseInt(String.valueOf(this.commDao.getBaseHibernateTemplate().find(strHQL, (Object[])new Long[]{endTime}).listIterator().next()));
        return totalCount;
    }

    public String transferLog(String fileType, long endTime, String lang, String filePath) {
        String dateTime;
        this.logger.info((Object)"System transferLog begin", 1L);
        StringBuffer sBufQObj = new StringBuffer("FROM OptLogMo where opTime < " + endTime);
        Paging paging = null;
        int totalNum = this.getCountByHql(endTime);
        int count = totalNum / 5000;
        if (0 != totalNum % 5000) {
            ++count;
        }
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss-ms");
        String tempfileName = dateTime = dateFormat.format(date);
        String currentPath = LegoProperties.getStorageFilePath();
        this.createDirectory(currentPath + File.separator + "datastorage");
        currentPath = currentPath + filePath;
        this.createDirectory(currentPath);
        File tempFileDir = new File(currentPath + File.separator + tempfileName);
        this.logger.info((Object)("start create director, directory: " + tempfileName + File.separator + "detail"));
        this.createDirectory(currentPath + File.separator + tempfileName + File.separator + "detail");
        if (totalNum > 5000) {
            this.transLogMultipleFile(count, sBufQObj, fileType, lang, tempFileDir, tempfileName);
        } else {
            paging = this.querySysOptLogByStorage(sBufQObj.toString(), 0, 5000);
            List list = paging.getData();
            if (null != this.sysOptStorage) {
                this.saveLogDetail(fileType, tempFileDir, list);
                try {
                    this.sysOptStorage.logExport(list, fileType, lang, tempFileDir, tempfileName, 1);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Throwable error" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
                }
            }
        }
        try {
            FileZip.zip((String)(currentPath + File.separator + tempfileName), (String)(currentPath + File.separator + tempfileName + ".zip"), (String)tempfileName);
            FileZip.deleteFile((File)tempFileDir);
            this.logger.info((Object)"System transferLog success", 1L);
        }
        catch (Exception e) {
            this.logger.error((Object)("zip file error" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        this.deleteLog(endTime);
        return tempfileName + ".zip";
    }

    private boolean deleteLog(long endTime) {
        boolean result = false;
        try {
            String hql = "select o.id from OptLogMo o where o.opTime <" + endTime;
            List<?> optLogIdList = this.commDao.findByHql(hql);
            int listSize = optLogIdList.size();
            int pageSize = listSize % 200 == 0 ? listSize / 200 : listSize / 200 + 1;
            for (int i = 0; i < pageSize; ++i) {
                StringBuffer optLogIds = new StringBuffer();
                optLogIds.append(0);
                for (int j = i * 200; j < Math.min((i + 1) * 200, listSize); ++j) {
                    optLogIds.append(',');
                    optLogIds.append(optLogIdList.get(j));
                }
                hql = "delete from OptLogDetailMo o where o.logId in (" + optLogIds.toString() + ")";
                this.commDao.updateByHql(hql);
            }
            hql = "delete from OptLogMo where opTime <" + endTime;
            this.commDao.updateByHql(hql);
            result = true;
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    private void transLogMultipleFile(int count, StringBuffer sBufQObj, String fileType, String lang, File tempFileDir, String tempfileName) {
        Paging paging = null;
        for (int i = 0; i < count; ++i) {
            CommonUtil.sleep((long)100L);
            paging = this.querySysOptLogByStorage(sBufQObj.toString(), i * 5000 + 1, 5000);
            List list = paging.getData();
            if (null == this.sysOptStorage) continue;
            this.saveLogDetail(fileType, tempFileDir, list);
            try {
                this.sysOptStorage.logExport(list, fileType, lang, tempFileDir, tempfileName, i);
                continue;
            }
            catch (Exception e) {
                this.logger.error((Object)("Throwable error" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
        }
    }

    private void saveLogDetail(String fileType, File tempFileDir, List<OptLogMo> list) {
        FileUtil fileUtil = null;
        fileUtil = FileFactory.getFileUtil((String)fileType);
        if (null == fileUtil) {
            this.logger.error((Object)"write detail file error: null fileUtil", 1L);
            return;
        }
        String canonicalPath = "";
        try {
            canonicalPath = tempFileDir.getCanonicalPath();
        }
        catch (IOException e1) {
            this.logger.error((Object)"saveLogDetail tempFileDir.getCanonicalPath() error!", 1L);
        }
        String detailPath = canonicalPath + File.separator + "detail" + File.separator;
        try {
            for (OptLogMo optLog : list) {
                byte[] logDetail;
                if (optLog.getHasDetail() != 1 || (logDetail = this.queryLogDetail(optLog.getId())) == null) continue;
                FileUtil.writeDetailFile((String)(detailPath + optLog.getId() + ".txt"), (byte[])logDetail);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("write detail file error" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
    }

    private void createDirectory(String filePath) {
        File path = new File(filePath);
        try {
            boolean result;
            if (!path.isDirectory() && !(result = path.mkdirs())) {
                this.logger.error((Object)("createDirectory error: " + path.getName()), 1L);
            }
        }
        catch (SecurityException se) {
            this.logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)se), 1L);
        }
    }

    public void setSysOptStorage(ISysOptStorage sysOptStorage) {
        this.sysOptStorage = sysOptStorage;
    }

    public List<OptLogMo> getSerialNumIsEmpty() {
        StringBuffer sBufQObj = new StringBuffer("FROM OptLogMo ");
        StringBuffer hsqlBuf = new StringBuffer(" as d ");
        hsqlBuf.append("WHERE d.serialNumber = null");
        sBufQObj.append(hsqlBuf);
        List<Object> lstOptLogMo = new ArrayList<OptLogMo>();
        try {
            this.logger.info((Object)sBufQObj.toString(), 1L);
            lstOptLogMo = this.commDao.findByHql(sBufQObj.toString());
        }
        catch (Exception e) {
            this.logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
        return lstOptLogMo;
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        this.logger.info((Object)"start report log ...");
        if (null != this.reportThread) {
            return;
        }
        this.reportThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    TryCatchThrowable tempTry;
                    if (null == (tempTry = SysOptLogImpl.this.getTryCatchThrowable())) {
                        continue;
                    }
                    tempTry.run();
                }
            }
        }, "reportLog");
        this.reportThread.start();
    }

    private TryCatchThrowable getTryCatchThrowable() {
        TryCatchThrowable tempTry = new TryCatchThrowable(){

            protected void doTry() {
                SysOptLog log;
                if (SysOptLogImpl.this.logQueue.isEmpty()) {
                    CommonUtil.sleep((long)2000L);
                    return;
                }
                try {
                    log = (SysOptLog)SysOptLogImpl.this.logQueue.take();
                }
                catch (InterruptedException e) {
                    throw new LegoCheckedException(102L, (Throwable)e);
                }
                IOperatelogService logService = SysOptLogImpl.this.optLogProxy.getLogReportService(log.getLogType());
                if (null != logService) {
                    logService.notifyLog(log);
                }
            }

            protected void doCatch(Throwable e) {
                SysOptLogImpl.this.logger.error((Object)("repeat report error ." + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        };
        return tempTry;
    }
}

