/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.system.sysmonitor.service.compmoniservice;

import com.huawei.lego.core.sdk.base.IAppManager;
import com.huawei.lego.core.sdk.base.model.AppInfo;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoProperties;
import com.huawei.lego.core.system.sysmonitor.sdk.model.Bundle;
import com.huawei.lego.core.system.sysmonitor.service.compmoniservice.ICompMonitor;
import com.huawei.lego.core.system.sysmonitor.service.compmoniservice.TranslateObject;
import java.util.ArrayList;
import java.util.List;

public class CompMonitorImpl
implements ICompMonitor {
    public static final String KEY_HIDE_SERVICES = "hide_services";
    private IAppManager appManager;
    private Log log = LogFactory.getInstance(CompMonitorImpl.class);
    private String[] filterApp = null;

    public CompMonitorImpl() {
        String hideServices = LegoProperties.getProperty((String)KEY_HIDE_SERVICES, (String)"DomainApplicaton,webnms,mediation,discover");
        this.filterApp = hideServices.split(",");
    }

    @Override
    public void stopBundle(List<String> lstBundle) {
        for (String sBundle : lstBundle) {
            this.appManager.stop(sBundle);
        }
    }

    public IAppManager getAppManager() {
        return this.appManager;
    }

    public void setAppManager(IAppManager appManager) {
        this.appManager = appManager;
    }

    @Override
    public void startBundle(List<String> lstBundle) {
        for (String sBundle : lstBundle) {
            this.appManager.start(sBundle);
        }
    }

    private boolean findFilterAppName(AppInfo ai) {
        for (String s : this.filterApp) {
            if (!s.equals(ai.getAppName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Bundle> getBundles() {
        ArrayList<AppInfo> returnAppInfo = new ArrayList<AppInfo>();
        List tmpAppInfo = this.appManager.getAppList();
        try {
            for (AppInfo ai : tmpAppInfo) {
                if (this.findFilterAppName(ai)) continue;
                returnAppInfo.add(ai);
            }
        }
        catch (Exception e) {
            this.log.warn((Object)ExceptionUtil.getErrorMessage((Throwable)e), 0L);
        }
        return TranslateObject.translateAppInfoToBundle(returnAppInfo);
    }
}

