/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.system.sysmonitor.service.dealwithevent;

import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.system.sysmonitor.sdk.model.DataBaseInfo;
import com.huawei.lego.core.system.sysmonitor.sdk.model.DiskResouceUse;
import com.huawei.lego.core.system.sysmonitor.sdk.model.HostServerMonitorInfo;
import com.huawei.lego.core.system.sysmonitor.sdk.model.ResourceUse;
import com.huawei.lego.core.system.sysmonitor.sdk.model.SysmTreshold;
import com.huawei.lego.core.system.sysmonitor.sdk.model.SysmTresholdType;
import com.huawei.lego.core.system.sysmonitor.service.dealwithevent.AlarmCount;
import com.huawei.lego.core.system.sysmonitor.service.dealwithevent.IDealWithAlarm;
import com.huawei.lego.core.system.sysmonitor.service.treshold.ISysmTresholdService;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import com.huawei.lego.nem.fault.sdk.service.IFaultGenerateService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DealWithAlarm
implements IDealWithAlarm {
    private static final int SLLEEP_TIME = 1000;
    private static final int LOOP_COUNT = 100;
    private static final int COUNT = 15;
    private static final int VALUE_3 = 3;
    private static final int VALUE_2 = 2;
    private static List<DiskResouceUse> diskResouceList = new ArrayList<DiskResouceUse>();
    private Map<String, AlarmCount> countMap = new HashMap<String, AlarmCount>();
    private Map<String, Boolean> firstStartFlag = new HashMap<String, Boolean>();
    private ISysmTresholdService sysTresholdService;
    private IFaultGenerateService faultService = null;
    private Log logger = LogFactory.getInstance(DealWithAlarm.class);

    @Override
    public void generateEvent(List<DataBaseInfo> currentDataBaseInfo) {
        if (null == currentDataBaseInfo) {
            this.logger.trace((Object)"generateEvent:currentDataBaseInfo is null");
            return;
        }
    }

    public void generateDiskEvent(List<DiskResouceUse> diskList) {
        if (null == diskList) {
            return;
        }
        for (DiskResouceUse temp : diskList) {
            DiskResouceUse diskResouceUseInfo = null;
            for (DiskResouceUse diskResouceUse : diskResouceList) {
                if (!diskResouceUse.getDiskName().equals(temp.getDiskName())) continue;
                diskResouceUseInfo = diskResouceUse;
                break;
            }
            if (null != diskResouceUseInfo) {
                diskResouceList.remove(diskResouceUseInfo);
            }
            this.generateEvent(temp.getDiskName(), temp.getPercent(), SysmTresholdType.disk);
        }
        for (DiskResouceUse diskResouceUse : diskResouceList) {
            SysmTreshold treshold = new SysmTreshold();
            treshold.setId(Long.valueOf(SysmTresholdType.disk.getValue()));
            treshold.setPercent(this.getPercent(diskResouceUse.getPercent()));
            this.generateEvent(diskResouceUse.getDiskName(), false, treshold, 0L);
        }
        diskResouceList.clear();
        diskResouceList.addAll(diskList);
    }

    @Override
    public void generateEvent(HostServerMonitorInfo serverMonitorInfo) {
        if (null == serverMonitorInfo) {
            this.logger.trace((Object)"generateEvent:serverMonitorInfo is null");
            return;
        }
        ResourceUse cpuUse = serverMonitorInfo.getCpuInfo();
        ResourceUse memUse = serverMonitorInfo.getMemoryInfo();
        this.generateEvent("CPU", cpuUse.getPercent(), SysmTresholdType.cpu);
        this.generateEvent("MEM", memUse.getPercent(), SysmTresholdType.mem);
        List diskList = serverMonitorInfo.getDiskInfo();
        this.generateDiskEvent(diskList);
    }

    public void generateEvent(String resName, String percent, SysmTresholdType type) {
        SysmTreshold treshold = null;
        if (null != this.sysTresholdService) {
            treshold = this.sysTresholdService.getSysmTreshold(type.getValue());
        }
        if (null == treshold) {
            return;
        }
        long lpercent = this.getPercent(percent);
        if (lpercent < 0L) {
            return;
        }
        if (lpercent > treshold.getPercent()) {
            this.dealWithMoreTreshold(resName, treshold, lpercent);
        } else {
            this.dealWithLessTreshold(resName, treshold, lpercent);
        }
    }

    private void dealWithMoreTreshold(String resName, SysmTreshold treshold, long lpercent) {
        if (!this.countMap.containsKey(resName)) {
            AlarmCount alarmCount = new AlarmCount();
            alarmCount.setResName(resName);
            alarmCount.setCount(1);
            this.countMap.put(resName, alarmCount);
            if (!"CPU".equals(resName) && !"MEM".equals(resName)) {
                this.generateEvent(resName, true, treshold, lpercent);
            }
        } else {
            AlarmCount alarmCount = this.countMap.get(resName);
            int count = alarmCount.getCount();
            if ("CPU".equals(resName) || "MEM".equals(resName)) {
                if (++count == 15) {
                    alarmCount.setCount(16);
                    this.countMap.put(resName, alarmCount);
                    alarmCount.setGenerateAlarm(Boolean.TRUE);
                    this.generateEvent(resName, true, treshold, lpercent);
                } else {
                    alarmCount.setCount(count);
                    this.countMap.put(resName, alarmCount);
                }
            }
        }
    }

    private void dealWithLessTreshold(String resName, SysmTreshold treshold, long lpercent) {
        if (this.countMap.containsKey(resName)) {
            AlarmCount alarmCount = this.countMap.get(resName);
            if ("CPU".equals(resName) || "MEM".equals(resName)) {
                if (alarmCount.isGenerateAlarm()) {
                    this.generateEvent(resName, false, treshold, lpercent);
                }
            } else {
                this.countMap.remove(resName);
                this.generateEvent(resName, false, treshold, lpercent);
            }
            this.countMap.remove(resName);
        } else if (this.firstStartFlag.isEmpty() || !this.firstStartFlag.containsKey(resName)) {
            this.generateEvent(resName, false, treshold, lpercent);
            this.firstStartFlag.put(resName, Boolean.TRUE);
        }
    }

    public void generateEvent(String resNme, boolean isAlarm, SysmTreshold treshold, long crrentPercent) {
        if (null == treshold) {
            return;
        }
        String[] alarmParam = null;
        String alarmId = "";
        if (treshold.getId().longValue() == SysmTresholdType.cpu.getValue()) {
            alarmParam = new String[]{String.valueOf(treshold.getPercent()), String.valueOf(crrentPercent)};
            alarmId = "0x000803220001";
        } else if (treshold.getId().longValue() == SysmTresholdType.db.getValue()) {
            alarmParam = new String[]{resNme, String.valueOf(treshold.getPercent()), String.valueOf(crrentPercent)};
            alarmId = "0x000803220003";
        } else if (treshold.getId().longValue() == SysmTresholdType.disk.getValue()) {
            alarmParam = new String[]{resNme, String.valueOf(treshold.getPercent()), String.valueOf(crrentPercent)};
            alarmId = "0x000803220004";
        } else if (treshold.getId().longValue() == SysmTresholdType.mem.getValue()) {
            alarmParam = new String[]{String.valueOf(treshold.getPercent()), String.valueOf(crrentPercent)};
            alarmId = "0x000803220002";
        }
        IFaultGenerateService alarmService = this.getFaultGenerateService();
        if (null == alarmService) {
            return;
        }
        LegoAlarm alarm = new LegoAlarm();
        alarm.setAlarmId(alarmId);
        alarm.setAlarmTime(System.currentTimeMillis());
        alarm.setAlarmParam(alarmParam);
        alarm.setSourceType(FaultEnum.AlarmResourceType.UNDEFINED.getValue());
        try {
            if (!isAlarm) {
                alarm.setClearStatus(FaultEnum.ClearState.CLEARED);
                alarm.setClearUser("system");
                alarm.setClearTime(new Date().getTime());
                alarmService.generateLegoRestoreAlarm(alarm);
            } else {
                alarmService.generateLegoAlarm(alarm);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("alarmService    generate  LegoRestoreAlarm error" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
    }

    private long getPercent(String oldPercent) {
        Double lPercent = -1.0;
        String percent = oldPercent.replaceAll("%", "").trim();
        if (!"".equals(percent) && !"N/A".equals(percent)) {
            this.logger.trace((Object)"getPercent:percent is not null");
            lPercent = NumberUtil.convertToDouble((Object)percent);
        }
        return lPercent.longValue();
    }

    private IFaultGenerateService getFaultGenerateService() {
        for (int i = 0; null == this.faultService && i < 100; ++i) {
            try {
                this.faultService = (IFaultGenerateService)ServiceContext.getInstance().lookup("fault/faultGenerateService");
                CommonUtil.sleep((long)1000L);
                continue;
            }
            catch (Exception e) {
                this.logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
            }
        }
        return this.faultService;
    }

    public ISysmTresholdService getSysTresholdService() {
        return this.sysTresholdService;
    }

    public void setSysTresholdService(ISysmTresholdService sysTresholdService) {
        this.sysTresholdService = sysTresholdService;
    }
}

