/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.system.sysmonitor.service.hostserver;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.system.sysmonitor.service.hostserver.ISystemTool;
import com.huawei.lego.core.system.sysmonitor.service.hostserver.LinuxSystemTool;
import com.huawei.lego.core.system.sysmonitor.service.hostserver.WindowsSystemTool;
import java.util.Locale;

public final class SystemToolFactory {
    private static ISystemTool systemTool = null;
    private static Log logger = LogFactory.getInstance(SystemToolFactory.class);

    private SystemToolFactory() {
    }

    public static synchronized ISystemTool getSystemTool() {
        if (systemTool != null) {
            return systemTool;
        }
        String osname = System.getProperty("os.name");
        if (null != osname) {
            String os = osname.toLowerCase(Locale.ENGLISH);
            if (os.contains("win")) {
                try {
                    systemTool = new WindowsSystemTool();
                }
                catch (Exception e) {
                    logger.info((Object)("init resource tool failed" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
                }
            }
            if (os.contains("linux")) {
                systemTool = new LinuxSystemTool();
            }
        }
        return systemTool;
    }
}

