/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.system.sysmonitor.service.hostserver;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.MathUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.PathUtil;
import com.huawei.lego.core.system.sysmonitor.sdk.model.DiskResouceUse;
import com.huawei.lego.core.system.sysmonitor.service.hostserver.ISystemTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class WindowsSystemTool
implements ISystemTool {
    private static final String CPU_USE_PERCENT = "CPU";
    private static final String MEM_TOTALMEM = "TOTALMEM";
    private static final String MEM_AVAILMEM = "AVAILMEM";
    private static final long GB = 0x40000000L;
    private static final double DBHUNDRED = 100.0;
    private static final double LHUNDRED = 100.0;
    private Log logger = LogFactory.getInstance(WindowsSystemTool.class);
    private String cmd = "";

    public WindowsSystemTool() {
        File file = new File(".");
        String path = "";
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException e) {
            this.logger.error((Object)"WindowsSystemTool getCanonicalPath() error!", 102L);
        }
        String currentPath = path + File.separator;
        this.cmd = currentPath + "tools" + File.separator + "resource.exe ";
    }

    @Override
    public double getCpuInfo() {
        long percent = 0L;
        try {
            percent = this.getCPUAndMenInfo(CPU_USE_PERCENT);
        }
        catch (Exception e) {
            this.logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
        return percent;
    }

    @Override
    public long getPercentMemInfo() {
        long total = this.getTotalMemInfo();
        long avail = this.getAvailMemInfo();
        long use = total - avail;
        double percent = (double)use * 100.0 / 100.0;
        return (long)percent;
    }

    @Override
    public long getAvailMemInfo() {
        return this.getCPUAndMenInfo(MEM_AVAILMEM);
    }

    @Override
    public long getTotalMemInfo() {
        return this.getCPUAndMenInfo(MEM_TOTALMEM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized long getCPUAndMenInfo(String para) {
        para = this.cmd + para;
        Process pp = null;
        BufferedReader input = null;
        try {
            pp = Runtime.getRuntime().exec(para);
            InputStreamReader ir = new InputStreamReader(pp.getInputStream(), "UTF-8");
            input = new LineNumberReader(ir);
            String nextStr = this.getLineFromFile((LineNumberReader)input);
            if (!nextStr.equals("")) {
                long l = NumberUtil.convertToLong((Object)nextStr);
                return l;
            }
        }
        catch (IOException e) {
            this.logger.error((Object)e.getMessage(), 1L);
        }
        finally {
            if (null != input) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)e.getMessage(), 1L);
                }
            }
            if (null != pp) {
                try {
                    pp.destroy();
                }
                catch (Exception e) {
                    this.logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
                }
            }
        }
        return 1L;
    }

    @Override
    public synchronized List<DiskResouceUse> getDisk() {
        File[] roots = File.listRoots();
        ArrayList<DiskResouceUse> list = new ArrayList<DiskResouceUse>();
        List<String> relatedPath = this.getRelatedPath();
        if (roots == null) {
            return list;
        }
        for (File file : roots) {
            if (!relatedPath.contains(file.getPath())) continue;
            DiskResouceUse disktemp = new DiskResouceUse();
            disktemp.setDiskName(file.getPath());
            double totalSpace = file.getTotalSpace();
            double usableSpace = file.getUsableSpace();
            if (!(totalSpace > 0.0) || !file.canWrite() || !(usableSpace > 0.0)) continue;
            double total = MathUtil.getDoubleValue((double)(totalSpace / 1.073741824E9));
            disktemp.setTotal(total + " G");
            double useableGB = MathUtil.getDoubleValue((double)(usableSpace / 1.073741824E9));
            double used = MathUtil.getDoubleValue((double)(total - useableGB));
            disktemp.setUsed(used + " G");
            disktemp.setUnit("GB");
            disktemp.setAvail(useableGB + " G");
            double percent = MathUtil.getDoubleValue((double)((total - useableGB) / total)) * 100.0;
            disktemp.setPercent(percent + "%");
            list.add(disktemp);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String[] getAllInfo(String para) {
        para = this.cmd + para;
        Process pp = null;
        BufferedReader input = null;
        try {
            pp = Runtime.getRuntime().exec(para);
            InputStreamReader ir = new InputStreamReader(pp.getInputStream(), "UTF-8");
            input = new LineNumberReader(ir);
            String nextStr = this.getLineFromFile((LineNumberReader)input);
            if (!nextStr.equals("")) {
                String[] stringArray = nextStr.split("-");
                return stringArray;
            }
        }
        catch (IOException e) {
            this.logger.error((Object)e.getMessage(), 1L);
        }
        finally {
            if (null != input) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)e.getMessage(), 1L);
                }
            }
            if (null != pp) {
                try {
                    pp.destroy();
                }
                catch (Exception e) {
                    this.logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
                }
            }
        }
        return new String[0];
    }

    private String getLineFromFile(LineNumberReader lineReader) throws IOException {
        StringBuffer strBuf = new StringBuffer();
        try {
            int tempChar;
            while ((tempChar = lineReader.read()) != -1 && (char)tempChar != '\n' && (char)tempChar != '\r') {
                strBuf.append((char)tempChar);
            }
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        return strBuf.toString().trim();
    }

    private List<String> getRelatedPath() {
        String[] dbInstallRootPath;
        ArrayList<String> relatedPathList = new ArrayList<String>();
        String runtimePath = PathUtil.getRuntimePath();
        String rdInstalledXmlPath = runtimePath + "\\bin\\RDInstalled.xml";
        String systemXmlPath = runtimePath + "\\bin\\config\\system.xml";
        String rdInstallPath = this.getRDInstallPath(rdInstalledXmlPath);
        String dbInstallPath = this.getDBInstallPath(systemXmlPath);
        String[] rdInstallRootPath = rdInstallPath.split(":");
        if (rdInstallRootPath[0].equals((dbInstallRootPath = dbInstallPath.split(":"))[0])) {
            relatedPathList.add(rdInstallRootPath[0] + ":\\");
        } else {
            relatedPathList.add(rdInstallRootPath[0] + ":\\");
            relatedPathList.add(dbInstallRootPath[0] + ":\\");
        }
        return relatedPathList;
    }

    private String getRDInstallPath(String installFilePath) {
        installFilePath = installFilePath.trim();
        SAXReader reader = new SAXReader();
        String installPath = "";
        File file = new File(installFilePath);
        try {
            CommonUtil.setSecurityFeatures((SAXReader)reader);
            Document document = reader.read(file);
            Element root = document.getRootElement();
            Element properties = root.element("installpath");
            installPath = properties.attribute("path").getValue();
        }
        catch (DocumentException e) {
            this.logger.error((Object)("get rd install path failed." + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        catch (SAXException e) {
            this.logger.error((Object)"parse faile!", (Throwable)e);
        }
        return installPath;
    }

    private String getDBInstallPath(String installFilePath) {
        installFilePath = installFilePath.trim();
        SAXReader reader = new SAXReader();
        String dbFilePath = "";
        File file = new File(installFilePath);
        try {
            CommonUtil.setSecurityFeatures((SAXReader)reader);
            Document document = reader.read(file);
            Element root = document.getRootElement();
            Element properties = root.element("database");
            dbFilePath = properties.attribute("dbfilepath").getValue();
        }
        catch (DocumentException e) {
            this.logger.error((Object)("get gsDB install path failed." + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        catch (SAXException e) {
            this.logger.error((Object)"parse faile!", (Throwable)e);
        }
        return dbFilePath;
    }
}

