/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.system.template.initializer;

import com.huawei.lego.com.south.sdk.model.Protocol;
import com.huawei.lego.com.south.sdk.model.SnmpPara;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.util.LegoProperties;
import com.huawei.lego.core.system.template.dao.ITemplateDao;
import java.util.Properties;

public class DefaultTemplateProvider
implements SystemStatusChangedListener {
    private static final int DEFAULT_PORT = 161;
    private static final int RETRY_TIMES = 3;
    private static final int TIME_OUT = 5;
    private static final String KEY_IS_SNMP_PARA = "snmpPara";
    private ITemplateDao templateDao = null;

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() == Status.STATUS_STARTED) {
            this.afterPropertiesSet();
        }
    }

    private void afterPropertiesSet() {
        this.provideSnmpTemplate();
    }

    private void provideSnmpTemplate() {
        String isDefaultSnmpPara = LegoProperties.getProperty((String)KEY_IS_SNMP_PARA, (String)Boolean.FALSE.toString());
        if (isDefaultSnmpPara.equals(Boolean.FALSE.toString())) {
            return;
        }
        Properties prop = new Properties();
        prop.put("templateName", "default_SNMPv3_template");
        prop.put("version", (Object)3);
        prop.put("isTemplate", (Object)true);
        if (this.templateDao.getTemplateList(prop).isEmpty()) {
            SnmpPara templatev3 = new SnmpPara();
            templatev3.setIsTemplate(Boolean.valueOf(true));
            templatev3.setTemplateName("default_SNMPv3_template");
            templatev3.setPort(161);
            templatev3.setRetries(3);
            templatev3.setTimeout(5);
            templatev3.setVersion(3);
            templatev3.setSecurityName("");
            this.templateDao.addTemplate((Protocol)templatev3, SnmpPara.class.getName());
        }
    }

    public ITemplateDao getTemplateDao() {
        return this.templateDao;
    }

    public void setTemplateDao(ITemplateDao templateDao) {
        this.templateDao = templateDao;
    }
}

