/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.discover.service;

import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.Node;
import com.huawei.lego.com.south.sdk.model.Protocol;
import com.huawei.lego.com.south.sdk.model.SnmpPara;
import com.huawei.lego.com.south.sdk.model.TelnetPara;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.comm.internal.jms.core.MessageCenter;
import com.huawei.lego.core.sdk.common.ServiceProvider;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.mediation.synchronize.snmp.model.SnmpSyncParamInfo;
import com.huawei.lego.core.sdk.mediation.synchronize.snmp.model.SnmpSynchronizeParameter;
import com.huawei.lego.core.sdk.mediation.synchronize.snmp.util.SnmpSynchronizeUtil;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryResult;
import com.huawei.lego.nem.discover.sdk.service.INodeEditor;
import com.huawei.lego.nem.discover.service.AbstractDiscoveryThread;
import com.huawei.lego.nem.discover.util.DiscoveryUtil;
import com.huawei.lego.nem.discover.util.WatchUtil;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class AutoDiscoveryThread
extends AbstractDiscoveryThread {
    private static final int VALUE_2 = 2;
    private static final int VALUE_2000 = 2000;
    private static final int VALUE_1000 = 1000;
    private static final Log LOGGER = LogFactory.getInstance(AutoDiscoveryThread.class);
    private List<INodeEditor> nodelist;

    public AutoDiscoveryThread(DiscoveryPolicy policy) {
        super(policy);
    }

    public AutoDiscoveryThread(DiscoveryPolicy policy, List<INodeEditor> nodeEditorList) {
        super(policy);
        this.nodelist = nodeEditorList;
    }

    private List<String[]> getMibResult(String ip) {
        List resultStringArrayList;
        block2: {
            resultStringArrayList = null;
            try {
                ServiceProvider.getResourceService().snmpReadTest(ip, super.getPolicy().getSnmpPara());
                String[] targetOidArray = new String[]{".1.3.6.1.2.1.1.1", ".1.3.6.1.2.1.1.2", ".1.3.6.1.2.1.1.5"};
                SnmpSyncParamInfo param = new SnmpSyncParamInfo();
                param.setReferredAReferingOid(new String[]{null, null});
                param.setTargetOidList(null);
                SnmpSynchronizeParameter snmpSynchronizeParameter = new SnmpSynchronizeParameter(new String[]{ip, null}, super.getPolicy().getManagementProtocolMap(), new String[]{null, null, null, null}, null, null, param);
                resultStringArrayList = SnmpSynchronizeUtil.getMibValueFromAgent(Arrays.asList(targetOidArray), (SnmpSynchronizeParameter)snmpSynchronizeParameter);
            }
            catch (Exception e) {
                LOGGER.error((Object)("exception when getMibValueFromAgent" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
                if (super.getPolicy().getDiscoveryNonSnmpDevice().booleanValue()) break block2;
                ExceptionUtil.rethrowException((Exception)e, null, (long)1053L, null);
            }
        }
        return resultStringArrayList;
    }

    private void discoverWithICMP(String ip) {
        Node node = new Node();
        node.setIpAddress(ip);
        if (this.nodelist != null && !this.nodelist.isEmpty()) {
            INodeEditor nodeEditor = this.nodelist.get(0);
            node = nodeEditor.editNode(node, super.getPolicy());
        }
        node.setSysOid(ip);
        node.setUuid(ip);
        node.setName(ip);
        node.setDiscoveredTime(new Timestamp(System.currentTimeMillis()));
        node.setMainType("lego.dic.discoverypolicy.thirdPartyDevice");
        node.setSubType("lego.dic.discoverypolicy.thirdPartyDevice");
        node.setLocation(super.getPolicy().getLocation());
        node.setIsTopMo(Boolean.valueOf(true));
        SnmpPara snmpPara = super.getPolicy().getSnmpPara();
        snmpPara.setTemplateName(UUID.randomUUID().toString());
        snmpPara.setDiscoveryPolicy(null);
        snmpPara.setId(null);
        snmpPara.setIsTemplate(Boolean.valueOf(false));
        snmpPara.setIsManagementProtocol(Boolean.valueOf(true));
        snmpPara.setNode(node);
        node.addManagementProtocol(SnmpPara.class.getName(), (Protocol)snmpPara);
        TelnetPara telnetPara = super.getPolicy().getTelnetPara();
        if (telnetPara != null) {
            telnetPara.setTemplateName(UUID.randomUUID().toString());
            telnetPara.setDiscoveryPolicy(null);
            telnetPara.setId(null);
            telnetPara.setIsTemplate(Boolean.valueOf(false));
            telnetPara.setIsManagementProtocol(Boolean.valueOf(true));
            telnetPara.setNode(node);
            node.addManagementProtocol(TelnetPara.class.getName(), (Protocol)telnetPara);
        }
        node.setTopoElementId(super.getPolicy().getTopoElementId());
        ServiceProvider.getResourceService().addMoAndSubMo((ManagedObject)node);
        DiscoveryResult discoveryResult = new DiscoveryResult();
        discoveryResult.setDiscoveryPolicy(super.getPolicy());
        discoveryResult.setFinishTime(new Timestamp(System.currentTimeMillis()));
        discoveryResult.setIpAddress(ip);
        discoveryResult.setSuccess(Boolean.valueOf(true));
        discoveryResult.setDeviceMainTypeI18n("lego.dic.discoverypolicy.thirdPartyDevice");
        discoveryResult.setDeviceSubTypeI18n("lego.dic.discoverypolicy.thirdPartyDevice");
        ServiceProvider.getDiscoveryService().updateDiscoveryResultAndPolicy(discoveryResult, true);
    }

    @Override
    public void run() {
        Map ipRangeMap = super.getPolicy().getIpRangeMap();
        for (Map.Entry entrySet : ipRangeMap.entrySet()) {
            if (super.isCancel()) {
                return;
            }
            String startIp = (String)entrySet.getKey();
            String endIp = (String)entrySet.getValue();
            long startIpLong = WatchUtil.getAddrLong(startIp);
            long endIpLong = WatchUtil.getAddrLong(endIp);
            long ipCount = endIpLong + 1L - startIpLong;
            boolean icmpPingSuccess = true;
            for (long j = 0L; !super.isCancel() && j < ipCount; ++j) {
                String ip = WatchUtil.convertAddr(startIpLong + j);
                icmpPingSuccess = this.checkIcmpPing(icmpPingSuccess, ip);
            }
        }
    }

    private boolean checkIcmpPing(boolean icmpPingSuccess, String ip) {
        try {
            if (DiscoveryUtil.checkIpDuplicate(ip)) {
                throw new LegoCheckedException(1056L);
            }
            icmpPingSuccess = this.checkIPReachable(ip);
            CommonUtil.sleep((long)1000L);
        }
        catch (LegoCheckedException ex) {
            this.doException(icmpPingSuccess, ex.getErrorCode(), ip);
        }
        catch (Exception e) {
            LOGGER.error((Object)("exception when discovery" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            this.doException(icmpPingSuccess, 1053L, ip);
        }
        return icmpPingSuccess;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkIPReachable(String ip) {
        boolean icmpPingSuccess = true;
        if (super.isIpReachable(ip)) {
            List<String[]> resultStringArrayList = this.getMibResult(ip);
            if (resultStringArrayList == null || resultStringArrayList.isEmpty()) {
                LOGGER.warn((Object)("can not get system info from mib in auto discovery, ip is : " + ip + ", snmpPara is : " + super.getPolicy().getSnmpPara()), 1L);
                if (!super.getPolicy().getDiscoveryNonSnmpDevice().booleanValue()) throw new LegoCheckedException(1053L);
                this.discoverWithICMP(ip);
                return icmpPingSuccess;
            } else {
                this.sendMessage(ip, resultStringArrayList);
            }
            return icmpPingSuccess;
        } else {
            LOGGER.warn((Object)("icmp ping is failed, ip is : " + ip), 1L);
            icmpPingSuccess = false;
            ServiceProvider.getDiscoveryService().updateDiscoveryPolicy(super.getPolicy(), false);
        }
        return icmpPingSuccess;
    }

    private void sendMessage(String ip, List<String[]> resultStringArrayList) {
        String[] resultStringArray = resultStringArrayList.get(0);
        if (resultStringArray.length < 3) {
            return;
        }
        String sysDesc = resultStringArray[0];
        String sysObjectID = resultStringArray[1];
        String sysName = resultStringArray[2];
        Node node = new Node();
        node.setIpAddress(ip);
        node.setDiscoveredTime(new Timestamp(System.currentTimeMillis()));
        node.setSysDescr(sysDesc);
        node.setSysName(sysName);
        node.addManagementProtocol(SnmpPara.class.getName(), (Protocol)super.getPolicy().getSnmpPara());
        node.addManagementProtocol(TelnetPara.class.getName(), (Protocol)super.getPolicy().getTelnetPara());
        sysObjectID = this.getSysID(sysObjectID);
        node.setSysOid(sysObjectID);
        node.setLocation(super.getPolicy().getLocation());
        SnmpPara snmpPara = super.getPolicy().getSnmpPara();
        snmpPara.setTemplateName(UUID.randomUUID().toString());
        snmpPara.setDiscoveryPolicy(null);
        snmpPara.setId(null);
        snmpPara.setIsTemplate(Boolean.valueOf(false));
        snmpPara.setIsManagementProtocol(Boolean.valueOf(true));
        TelnetPara telnetPara = super.getPolicy().getTelnetPara();
        if (telnetPara != null) {
            telnetPara.setTemplateName(UUID.randomUUID().toString());
            telnetPara.setDiscoveryPolicy(null);
            telnetPara.setId(null);
            telnetPara.setIsTemplate(Boolean.valueOf(false));
            telnetPara.setIsManagementProtocol(Boolean.valueOf(true));
        }
        HashMap<String, Object> messageBody = new HashMap<String, Object>();
        messageBody.put("snmpDiscoveredNode", node);
        messageBody.put("discoveryPolicy", super.getPolicy());
        LOGGER.info((Object)("messageBody in AutoDiscoveryThread is : " + messageBody), 1L);
        MessageUnit mu = new MessageUnit();
        mu.setCmdcode(101L);
        mu.setObj(messageBody);
        mu.setMt(MessageTopic.COMMAND);
        mu.setSourceAppName(this.getClass().getName());
        MessageCenter.getInstance().sendMessage(mu);
        CommonUtil.sleep((long)2000L);
    }

    private String getSysID(String sysObjectID) {
        if (sysObjectID != null && sysObjectID.contains(".iso.org.dod.internet.private.enterprises")) {
            sysObjectID = sysObjectID.replace(".iso.org.dod.internet.private.enterprises", ".1.3.6.1.4.1");
            LOGGER.info((Object)("converted sysObjectID is : " + sysObjectID), 1L);
        }
        return sysObjectID;
    }

    private void doException(boolean icmpPingSuccess, long errorCode, String ip) {
        if (icmpPingSuccess) {
            DiscoveryResult discoveryResult = new DiscoveryResult();
            discoveryResult.setDiscoveryPolicy(super.getPolicy());
            discoveryResult.setFinishTime(new Timestamp(System.currentTimeMillis()));
            discoveryResult.setIpAddress(ip);
            discoveryResult.setSuccess(Boolean.valueOf(false));
            discoveryResult.setErrorCode(Long.valueOf(errorCode));
            ServiceProvider.getDiscoveryService().updateDiscoveryResultAndPolicy(discoveryResult, true);
        } else {
            ServiceProvider.getDiscoveryService().updateDiscoveryPolicy(super.getPolicy(), false);
        }
    }
}

